/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.suggestion;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.DisplayableResult;
import com.mathworks.helpsearch.product.DocProduct;

public class PageSuggestion
implements DisplayableResult {
    private final DocProduct fProduct;
    private final String fTitle;
    private final String fSummary;
    private final String fPath;

    public PageSuggestion(DocProduct prod, String title, String summary, String loc) {
        this.fProduct = prod;
        this.fTitle = title;
        this.fSummary = summary;
        this.fPath = loc;
    }

    @Override
    public DocProduct getProduct() {
        return this.fProduct;
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    @Override
    public String getSummary() {
        return this.fSummary;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    public String getPageId() {
        return CategoryUtils.createIdFromFilePath(this.fProduct, this.getPath());
    }

    public String toString() {
        return this.getTitle();
    }

    private String concat() {
        return this.fTitle + "|" + this.fSummary + "|" + this.fPath;
    }

    public boolean equals(Object other) {
        if (other instanceof PageSuggestion) {
            PageSuggestion otherSugg = (PageSuggestion)other;
            return this.concat().equals(otherSugg.concat());
        }
        return false;
    }

    public int hashCode() {
        return this.concat().hashCode();
    }
}

