/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product.validation;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.validation.DocSetValidationCheck;
import com.mathworks.helpsearch.product.validation.DocSetValidationResponse;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneIndexUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ValidSearchIndexCheck
implements DocSetValidationCheck {
    private final IndexLocation fLocation;

    public ValidSearchIndexCheck(IndexLocation location) {
        this.fLocation = location;
    }

    @Override
    public DocSetValidationResponse validate(DocumentationSet docSet) {
        try {
            Map<DocumentationSearchField, Boolean> results = this.validateSearchFields(docSet.getFormat());
            return this.validateResults(results);
        }
        catch (IOException ioe) {
            DocSetValidationResponse response = new DocSetValidationResponse();
            response.addMessage(DocSetValidationResponse.Status.ERROR, "Could not access search database: " + ioe.getMessage());
            response.addTroubleshootingStep("Check that a search index exists at [" + this.fLocation.getSearchDirectory().toString() + "]");
            response.addException(ioe);
            return response;
        }
    }

    private Map<DocumentationSearchField, Boolean> validateSearchFields(ContentFormat format) throws IOException {
        List<DocumentationSearchField> toCheck = ValidSearchIndexCheck.getRequiredSearchFields(format);
        return LuceneIndexUtils.validateSearchFields((IndexLocation)this.fLocation, toCheck);
    }

    private DocSetValidationResponse validateResults(Map<DocumentationSearchField, Boolean> results) {
        DocSetValidationResponse response = new DocSetValidationResponse();
        for (Map.Entry<DocumentationSearchField, Boolean> result : results.entrySet()) {
            if (!result.getValue().booleanValue()) {
                response.addMessage(DocSetValidationResponse.Status.ERROR, "Search index is missing required field: [" + result.getKey().getFieldName() + "]");
                continue;
            }
            response.addMessage(DocSetValidationResponse.Status.OK, "Search index contains required field: [" + result.getKey().getFieldName() + "]");
        }
        if (response.getSeverity() == DocSetValidationResponse.Status.ERROR) {
            response.addTroubleshootingStep("The search index may not have been updated after a change to the indexer.  Rebuilding the search index should resolve this issue.");
            response.addTroubleshootingStep("The search indexer may need to be updated to correctly handle the required search field.  [We would like to add a search indexer validation tool to link to here]");
            response.addTroubleshootingStep("The documentation may be malformed in a way that prevents the indexer from populating all of the required fields.  [We would like to add a document validator to link to here]");
        }
        return response;
    }

    private static List<DocumentationSearchField> getRequiredSearchFields(ContentFormat format) {
        LinkedList<DocumentationSearchField> required = new LinkedList<DocumentationSearchField>();
        required.add(DocumentationSearchField.BODY);
        required.add(DocumentationSearchField.PRODUCT);
        required.add(DocumentationSearchField.RELATIVE_PATH);
        required.add(DocumentationSearchField.RESULT_TYPE);
        required.add(DocumentationSearchField.TITLE_DISPLAY);
        required.add(DocumentationSearchField.TITLE_SEARCH);
        required.add(DocumentationSearchField.SUMMARY);
        if (format == ContentFormat.DOC_CENTER_DOC) {
            required.add(DocumentationSearchField.ANCESTOR_ID);
            required.add(DocumentationSearchField.ANCESTOR_LABEL);
        }
        return required;
    }

    @Override
    public String getName() {
        return "Search Index Validation Check";
    }

    @Override
    public String getDescription() {
        return "Validates that the documentation set's search index is a valid Lucene index that contains the fields required for documentation searches.  This check does NOT validate the content of the index.";
    }
}

