/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product.validation;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.validation.DocSetValidationCheck;
import com.mathworks.helpsearch.product.validation.DocSetValidationResponse;
import com.mathworks.search.SearchField;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneIndexUtils;
import java.util.HashMap;
import java.util.Map;

public class UnknownProductsCheck
implements DocSetValidationCheck {
    private final Map<String, Integer> fProductStats;

    public UnknownProductsCheck(Map<String, Integer> productStats) {
        this.fProductStats = new HashMap<String, Integer>(productStats);
    }

    public UnknownProductsCheck(IndexLocation location) {
        Map productStats = null;
        try {
            productStats = LuceneIndexUtils.getSearchFieldStatistics((IndexLocation)location, (SearchField)DocumentationSearchField.PRODUCT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fProductStats = productStats;
    }

    @Override
    public DocSetValidationResponse validate(DocumentationSet docSet) {
        DocSetValidationResponse response = new DocSetValidationResponse();
        if (this.fProductStats == null) {
            response.addMessage(DocSetValidationResponse.Status.ERROR, "Failed to load product data from the search index.");
            response.addTroubleshootingStep("Check that this documentation set has a valid search index.");
            return response;
        }
        boolean unknownProductExists = false;
        for (String product : this.fProductStats.keySet()) {
            DocProduct fromDocSet = docSet.getProductByIndexString(product);
            if (fromDocSet == null) {
                response.addMessage(DocSetValidationResponse.Status.ERROR, "Search index contains an unknown product: \"" + product + "\"");
                unknownProductExists = true;
                continue;
            }
            response.addMessage(DocSetValidationResponse.Status.OK, product + " : " + fromDocSet.getDisplayName());
        }
        if (unknownProductExists) {
            response.addTroubleshootingStep("The search index may not have been updated after products were changed or removed from the documentation set.  Rebuilding the search index will typically solve this issue");
        }
        return response;
    }

    @Override
    public String getName() {
        return "Unknown Products in Search Index";
    }

    @Override
    public String getDescription() {
        return "Validates that every product in the search index is defined in the corresponding documentation set.  If this validation fails, it typically means that the documentation set has been updated without a corresponding update to the search index.";
    }
}

