/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.index.DocumentationDocument;
import java.util.List;
import java.util.Locale;

public enum SimpleReport {
    INVALID_BREADCRUMB,
    TITLES,
    NO_TYPE,
    NO_TITLE,
    BROKEN_LINK;


    public String getFileName() {
        return this.toString().toLowerCase(Locale.ENGLISH).replaceAll("_", "") + ".txt";
    }

    public static SimpleReport fromFileName(String fileName) {
        if (!fileName.endsWith(".txt")) {
            fileName = fileName + ".txt";
        }
        for (SimpleReport report : SimpleReport.values()) {
            if (!report.getFileName().equals(fileName)) continue;
            return report;
        }
        return null;
    }

    public boolean includeDocument(DocumentationDocument doc) {
        switch (this) {
            case TITLES: {
                return SimpleReport.hasTitle(doc);
            }
            case NO_TYPE: {
                return doc.getType() == null;
            }
            case NO_TITLE: {
                return !SimpleReport.hasTitle(doc);
            }
            case INVALID_BREADCRUMB: {
                return doc.getProduct().getDocSet().getFormat() == ContentFormat.DOC_CENTER_DOC && (doc.isBreadCrumbMalformed() || !SimpleReport.isBreadCrumbValid(doc));
            }
        }
        return false;
    }

    public boolean excludesFromIndex() {
        return this != INVALID_BREADCRUMB && this != TITLES;
    }

    private static boolean hasTitle(DocumentationDocument doc) {
        String title = doc.getTitle();
        return title != null && title.trim().length() > 0;
    }

    private static boolean isBreadCrumbValid(DocumentationDocument doc) {
        List<ResultCategory> breadCrumbs = doc.getBreadCrumbs();
        if (breadCrumbs != null) {
            for (ResultCategory category : breadCrumbs) {
                if (category.getNodesRootFirst().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

