/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.index.DirectoryListingTraversalStrategy;
import com.mathworks.helpsearch.index.DocCrawler;
import com.mathworks.helpsearch.index.DocTraversalStrategy;
import com.mathworks.helpsearch.index.DocumentParser;
import com.mathworks.helpsearch.index.DocumentQueue;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.HtmlParserFactory;
import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import com.mathworks.helpsearch.index.IndexDocumentBuilder;
import com.mathworks.helpsearch.index.IndexUtils;
import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import com.mathworks.helpsearch.index.ProductLinkResolver;
import com.mathworks.helpsearch.index.ReportBuilder;
import com.mathworks.helpsearch.index.TraversalStrategyQueue;
import com.mathworks.helpsearch.index.classic.ClassicDocHtmlParserFactory;
import com.mathworks.helpsearch.index.doccenter.DocCenterHtmlParserFactory;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchField;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ProductIndexer {
    private final IndexerConfig fConfig;
    private final DocProduct fProduct;
    private final DocumentParser fDocumentParser;
    private final IndexDocumentBuilder<? extends SearchField> fIndexDocBuilder;
    private final Indexer fIndexer;
    private final DocumentQueue fQueue;
    private final File fHelpDir;
    private final LocalizedFileLocator fLocator;
    private final List<String> fFailedToIndex = new LinkedList<String>();
    private ReportBuilder fReportBuilder = new ReportBuilder();
    private boolean fWriteReports = true;
    private PrintStream fOutputStream = System.out;

    public ProductIndexer(IndexerConfig config, DocProduct product, HtmlToDomAdapter domAdapter, IndexDocumentBuilder<? extends SearchField> indexDocBuilder, Indexer indexer) {
        this(config, product, ProductIndexer.getQueue(product, config), ProductIndexer.createDocumentParser(product, config, domAdapter), indexDocBuilder, indexer);
    }

    ProductIndexer(IndexerConfig config, DocProduct product, DocumentQueue documentQueue, DocumentParser docParser, IndexDocumentBuilder<? extends SearchField> indexDocBuilder, Indexer indexer) {
        this.fConfig = config;
        this.fProduct = product;
        this.fDocumentParser = docParser;
        this.fIndexDocBuilder = indexDocBuilder;
        this.fIndexer = indexer;
        this.fHelpDir = config.getHelpLocation(product);
        this.fQueue = documentQueue;
        this.fLocator = config.getFileLocator();
    }

    private static DocumentQueue getQueue(DocProduct product, IndexerConfig config) {
        return new TraversalStrategyQueue(ProductIndexer.getTraversalStrategy(product, config));
    }

    private static DocTraversalStrategy getTraversalStrategy(DocProduct product, IndexerConfig config) {
        switch (product.getDocSet().getFormat()) {
            case CLASSIC_DOC: {
                File helpDir = config.getHelpLocation(product);
                return new DirectoryListingTraversalStrategy(helpDir);
            }
        }
        return new DocCrawler();
    }

    private static DocumentParser createDocumentParser(DocProduct product, IndexerConfig config, HtmlToDomAdapter domAdapter) {
        HtmlParserFactory parserFactory = ProductIndexer.getParserFactory(product, config);
        return new DocumentParser(product.getDocSet().getFormat(), domAdapter, parserFactory, config.getFileLocator());
    }

    void setLogOutputStream(OutputStream stream) {
        this.fOutputStream = new PrintStream(stream);
    }

    void setReportBuilder(ReportBuilder builder) {
        this.fReportBuilder = builder;
    }

    ReportBuilder getReportBuilder() {
        return this.fReportBuilder;
    }

    private static HtmlParserFactory getParserFactory(DocProduct product, IndexerConfig config) {
        ContentFormat format = product.getDocSet().getFormat();
        switch (format) {
            case CLASSIC_DOC: {
                return new ClassicDocHtmlParserFactory();
            }
        }
        ProductLinkResolver resolver = new ProductLinkResolver(config, product);
        return new DocCenterHtmlParserFactory(product, resolver);
    }

    public void disableReports() {
        this.fWriteReports = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean index() {
        boolean bl;
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy MM dd HH:mm:ss.SSS");
        long startTime = System.currentTimeMillis();
        this.log("Start time: " + timestampFormat.format(new Date(startTime)));
        this.log("Content directory:  " + this.fHelpDir.getAbsolutePath());
        this.log("Index directory:    " + this.fConfig.getIndexDirectory());
        try {
            bl = this.openAndPopulateIndex();
        }
        catch (Exception e) {
            boolean bl2;
            try {
                this.log("An error occurred while indexing " + this.fProduct.getDisplayName() + ": " + e.getMessage());
                e.printStackTrace(this.fOutputStream);
                bl2 = false;
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                this.log("End time: " + timestampFormat.format(new Date(endTime)));
                long millis = endTime - startTime;
                String timeString = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
                this.log("***** Finished indexing " + this.fProduct.getDisplayName() + " in " + timeString + " *****\n\n");
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            this.log("End time: " + timestampFormat.format(new Date(endTime)));
            long millis = endTime - startTime;
            String timeString = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
            this.log("***** Finished indexing " + this.fProduct.getDisplayName() + " in " + timeString + " *****\n\n");
            return bl2;
        }
        long endTime = System.currentTimeMillis();
        this.log("End time: " + timestampFormat.format(new Date(endTime)));
        long millis = endTime - startTime;
        String timeString = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        this.log("***** Finished indexing " + this.fProduct.getDisplayName() + " in " + timeString + " *****\n\n");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean openAndPopulateIndex() throws Exception {
        this.fIndexer.openIndex();
        try {
            boolean bl = this.populateIndex();
            return bl;
        }
        finally {
            this.fIndexer.closeIndex();
        }
    }

    private boolean populateIndex() throws Exception {
        boolean written;
        int numDocs = this.indexFromLandingPage();
        if (!this.fFailedToIndex.isEmpty()) {
            String docs = this.fFailedToIndex.size() == 1 ? " document" : " documents";
            this.log("Indexing failed for " + this.fFailedToIndex.size() + docs);
            for (String doc : this.fFailedToIndex) {
                this.log("\t" + doc);
            }
            return false;
        }
        this.log("Indexed " + numDocs + " documents");
        if (this.fWriteReports && !(written = this.fReportBuilder.writeAllReports(this.getResourceDirectory(), this.fProduct.getDocSet().getFormat()))) {
            this.log("Unable to create reports - no resource directory available.");
        }
        return true;
    }

    int indexFromLandingPage() throws Exception {
        int docCount = 0;
        while (this.fQueue.hasNext()) {
            boolean success = this.indexNextDocument();
            if (!success) continue;
            ++docCount;
        }
        return docCount;
    }

    boolean indexNextDocument() throws Exception {
        String next = (String)this.fQueue.next();
        if (this.fLocator != null) {
            next = this.fLocator.getUnlocalizedFileName(next);
        }
        DocumentationDocument doc = new DocumentationDocument(this.fProduct, next);
        boolean success = this.parseAndIndexDocument(doc);
        this.fQueue.updateAfterDocument(doc, success);
        return success;
    }

    protected boolean parseAndIndexDocument(DocumentationDocument doc) throws Exception {
        return this.parseDocument(doc) && this.indexDocument(doc);
    }

    private boolean parseDocument(DocumentationDocument doc) throws Exception {
        boolean success = this.fDocumentParser.parseDocument(doc, this.fHelpDir);
        if (!success) {
            this.fReportBuilder.reportBrokenLink(doc);
        }
        return success;
    }

    private boolean indexDocument(DocumentationDocument doc) throws Exception {
        IndexDocument<? extends SearchField> indexDoc;
        boolean include = this.fReportBuilder.addToReports(doc);
        if (!doc.getTitle().equals(doc.getRelativePath()) && include && (indexDoc = this.createIndexDocument(doc)) != null) {
            this.addDocumentToIndex(indexDoc, doc.getRelativePath());
            return true;
        }
        return false;
    }

    private IndexDocument<? extends SearchField> createIndexDocument(DocumentationDocument doc) {
        try {
            return this.fIndexDocBuilder.createIndexDocument(doc);
        }
        catch (RuntimeException e) {
            this.log("Caught an exception while indexing document: " + doc.getRelativePath());
            throw e;
        }
    }

    private void addDocumentToIndex(IndexDocument<? extends SearchField> indexDoc, String relPath) throws IOException {
        try {
            this.fIndexer.addDocument(indexDoc);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            this.fFailedToIndex.add(relPath);
        }
    }

    private File getResourceDirectory() {
        return IndexUtils.getProductResourceDirectory(this.fConfig, this.fProduct, this.fWriteReports);
    }

    private void log(String message) {
        this.fOutputStream.println(message);
    }
}

