/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.DocSearcher;
import com.mathworks.helpsearch.DocumentationQuery;
import com.mathworks.helpsearch.DocumentationResultAdapter;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.DocumentationSearchResult;
import com.mathworks.helpsearch.HighlightProvider;
import com.mathworks.helpsearch.facets.DocFacetResults;
import com.mathworks.helpsearch.facets.FacetHelperBuilder;
import com.mathworks.helpsearch.facets.FacetSearchHelper;
import com.mathworks.helpsearch.facets.Facetable;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductFilter;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.FilterCollector;
import com.mathworks.search.ListSearchResultCollector;
import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchResultFilter;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchStringParseException;
import com.mathworks.search.SearchStringParser;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class SearchEngineDocSearcher
implements DocSearcher {
    private static final int MAX_HIGHLIGHT_LENGTH = 250;
    private boolean fOpened = false;
    private final SearchEngine fEngine;
    private final SearchCriteria fCriteria;
    private final List<FacetSearchHelper<? extends Facetable>> fFacetHelpers;
    private final DocumentationResultAdapter fResultAdapter;
    private final boolean fSortAlphabetically;
    private ProductFilter fProductFilter = null;
    private FilterCollector fProdFilterCollector = null;
    private ListSearchResultCollector<DocumentationSearchResult> fListCollector;

    public SearchEngineDocSearcher(DocumentationSet docSet, SearchEngine engine, DocumentationQuery query) throws SearchStringParseException {
        this(docSet, engine, query, FacetHelperBuilder.buildFacetHelpers(docSet, query, engine));
    }

    SearchEngineDocSearcher(DocumentationSet docSet, SearchEngine engine, DocumentationQuery query, List<FacetSearchHelper<? extends Facetable>> facetHelpers) throws SearchStringParseException {
        this.fEngine = engine;
        this.fFacetHelpers = facetHelpers;
        List<SearchExpression> facetExprs = SearchEngineDocSearcher.getFacetExpressions(facetHelpers);
        String queryWithoutFacets = query == null ? "" : query.getSearchText();
        SearchExpression queryExpression = SearchEngineDocSearcher.buildQueryExpression(queryWithoutFacets, !facetExprs.isEmpty());
        this.fSortAlphabetically = queryExpression == null;
        this.fCriteria = SearchEngineDocSearcher.buildCriteria(facetExprs, queryExpression);
        HighlightProvider highlighter = new HighlightProvider(queryExpression, 250);
        this.fResultAdapter = new DocumentationResultAdapter(highlighter, docSet);
    }

    @Override
    public void addProductFilter(ProductFilter filter) {
        this.fProductFilter = filter;
    }

    @Override
    public void doSearch() throws SearchException {
        if (!this.fOpened) {
            this.openIndex();
            this.fOpened = true;
        }
        LinkedList<Object> collectors = new LinkedList<Object>();
        this.fListCollector = this.createListCollector();
        collectors.add(this.fListCollector);
        collectors.addAll(this.getFacetCollectors());
        if (this.fProductFilter == null) {
            SearchResultCollector[] collectorsArray = collectors.toArray(new SearchResultCollector[collectors.size()]);
            this.fEngine.search(this.fCriteria, collectorsArray);
        } else {
            this.fProdFilterCollector = new FilterCollector((SearchResultFilter)this.fProductFilter, collectors);
            this.fEngine.search(this.fCriteria, new SearchResultCollector[]{this.fProdFilterCollector});
        }
    }

    private ListSearchResultCollector<DocumentationSearchResult> createListCollector() {
        if (this.fSortAlphabetically) {
            return ListSearchResultCollector.createCollector((SearchResultAdapter)this.fResultAdapter, (Comparator)new SortByTitleComparator());
        }
        return ListSearchResultCollector.createCollector((SearchResultAdapter)this.fResultAdapter);
    }

    private void openIndex() throws SearchException {
        try {
            this.fEngine.openIndex();
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    @Override
    public void cleanup() throws SearchException {
        try {
            this.fEngine.closeIndex();
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    private List<SearchResultCollector> getFacetCollectors() {
        LinkedList<SearchResultCollector> collectors = new LinkedList<SearchResultCollector>();
        for (FacetSearchHelper<? extends Facetable> facetHelper : this.fFacetHelpers) {
            SearchResultCollector collector = facetHelper.getCollector();
            if (collector == null) continue;
            collectors.add(collector);
        }
        return collectors;
    }

    @Override
    public SearchResults<DocumentationSearchResult> getSearchResults(int start, int num) throws SearchException {
        return this.fListCollector.getResults(start, num);
    }

    @Override
    public List<DocFacetResults> getFacetResults() {
        LinkedList<DocFacetResults> resultsList = new LinkedList<DocFacetResults>();
        for (FacetSearchHelper<? extends Facetable> helper : this.fFacetHelpers) {
            DocFacetResults<? extends Facetable> results = helper.getResults();
            if (results == null) continue;
            resultsList.add(results);
        }
        Collections.sort(resultsList);
        return resultsList;
    }

    @Override
    public int getNumFilteredByProduct() {
        return this.fProdFilterCollector == null ? 0 : this.fProdFilterCollector.getNumFiltered();
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.fEngine;
    }

    public void setMaxResults(int maxResults) {
        this.fCriteria.setMaxResults(maxResults);
    }

    public SearchCriteria getSearchCriteria() {
        return this.fCriteria;
    }

    private static SearchCriteria buildCriteria(List<SearchExpression> facetExprs, SearchExpression queryExpression) throws SearchStringParseException {
        LinkedList<SearchExpression> exprs = new LinkedList<SearchExpression>(facetExprs);
        if (queryExpression != null) {
            exprs.add(0, queryExpression);
        }
        if (exprs.size() == 1) {
            return new SearchCriteria((SearchExpression)exprs.get(0));
        }
        return new SearchCriteria((SearchExpression)new CompoundSearchExpression(exprs));
    }

    private static List<SearchExpression> getFacetExpressions(Collection<FacetSearchHelper<? extends Facetable>> facetHelpers) {
        LinkedList<SearchExpression> exprs = new LinkedList<SearchExpression>();
        for (FacetSearchHelper<? extends Facetable> facetHelper : facetHelpers) {
            SearchExpression facetExpr = facetHelper.getExpression();
            if (facetExpr == null) continue;
            exprs.add(facetExpr);
        }
        return exprs;
    }

    private static SearchExpression buildQueryExpression(String query, boolean facetsSelected) throws SearchStringParseException {
        if (query.trim().length() == 0 && facetsSelected) {
            return null;
        }
        SearchExpression queryExpr = SearchStringParser.buildExpression((String)query.trim());
        queryExpr.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
        return queryExpr;
    }

    private class SortByTitleComparator
    implements Comparator<SearchResult> {
        private SortByTitleComparator() {
        }

        @Override
        public int compare(SearchResult result1, SearchResult result2) {
            String title1 = result1.getFieldValue(DocumentationSearchField.TITLE_DISPLAY.getFieldName());
            String title2 = result2.getFieldValue(DocumentationSearchField.TITLE_DISPLAY.getFieldName());
            return title1.compareToIgnoreCase(title2);
        }
    }

    public static enum DocumentationFacet {
        CATEGORY,
        TYPE,
        PRODUCT;

    }
}

