/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.SearchConfig;
import java.io.File;
import java.io.IOException;

public class SearchDirectory {
    private static final String LOCK_FILE_NAME = "indexlock";
    private SearchConfig fConfig;

    public SearchDirectory(SearchConfig config) {
        this.fConfig = config;
    }

    public File getIndexDir() {
        return this.fConfig.getIndexDirectory();
    }

    private File getLockFile() {
        File indexDir = this.getIndexDir();
        return new File(indexDir, LOCK_FILE_NAME);
    }

    public boolean createLock() throws IOException {
        if (this.fConfig.getUseLocks()) {
            File lockFile = this.getLockFile();
            return lockFile.exists() || lockFile.createNewFile();
        }
        return true;
    }

    public boolean removeLock() throws IOException {
        if (this.fConfig.getUseLocks()) {
            File lockFile = this.getLockFile();
            return !lockFile.exists() || lockFile.delete();
        }
        return true;
    }

    public boolean isLocked() {
        if (this.fConfig.getUseLocks()) {
            File lockFile = this.getLockFile();
            return lockFile.exists();
        }
        return false;
    }
}

