/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.DisplayableResult;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.HighlightProvider;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.SearchHighlight;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.SearchResult;
import java.util.Collections;
import java.util.List;

public class DocumentationSearchResult
implements DisplayableResult {
    private final SearchResult fRawResult;
    private final DocumentationSet fDocSet;
    private final HighlightProvider fProvider;
    private List<SearchHighlight> fHighlights;

    public DocumentationSearchResult(SearchResult rawResult, DocumentationSet docSet, HighlightProvider provider) {
        this.fRawResult = rawResult;
        this.fDocSet = docSet;
        this.fProvider = provider;
    }

    @Override
    public String getPath() {
        return this.getFieldValue(DocumentationSearchField.RELATIVE_PATH);
    }

    @Override
    public String getSummary() {
        String summary = this.getFieldValue(DocumentationSearchField.SUMMARY);
        if (summary != null && summary.length() > 0) {
            return summary;
        }
        return null;
    }

    @Override
    public String getTitle() {
        return this.getFieldValue(DocumentationSearchField.TITLE_DISPLAY);
    }

    @Override
    public DocProduct getProduct() {
        String prodString = this.getFieldValue(DocumentationSearchField.PRODUCT);
        return this.fDocSet.getProductByIndexString(prodString);
    }

    public String getDescription() {
        return this.getFieldValue(DocumentationSearchField.DESCRIPTION);
    }

    public List<SearchHighlight> getHighlights() {
        if (this.fHighlights == null && this.fProvider != null) {
            this.populateHighlights();
        }
        return Collections.unmodifiableList(this.fHighlights);
    }

    private void populateHighlights() {
        try {
            String body = this.getFieldValue(DocumentationSearchField.BODY);
            this.fHighlights = this.fProvider.getHighlights(body);
        }
        catch (Exception e) {
            this.fHighlights = Collections.emptyList();
        }
    }

    public List<ResultCategory> getBreadCrumbs() {
        String breadCrumbText = this.getFieldValue(DocumentationSearchField.ANCESTOR_LABEL);
        return CategoryUtils.parseSearchIndexString(breadCrumbText);
    }

    public InformationType getType() {
        String type = this.getFieldValue(DocumentationSearchField.RESULT_TYPE);
        return this.fDocSet.getFormat().getInfoTypeByIndexString(type);
    }

    private String getFieldValue(DocumentationSearchField field) {
        return this.fRawResult.getFieldValue(field.getFieldName());
    }
}

