/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.SearchField;
import java.util.HashMap;
import java.util.Map;

public enum DocumentationSearchField implements SearchField<DocumentationSearchField>
{
    RELATIVE_PATH("relpath", true, true, false),
    TITLE_DISPLAY("displaytitle", false, true, false),
    TITLE_SEARCH("searchtitle", true, false, true),
    BODY("body", true, true, true),
    RESULT_TYPE("resulttype", true, true, false),
    SUMMARY("summary", true, true, true),
    DESCRIPTION("desc", false, true, false),
    NODE_ID("pageid", true, true, false),
    ANCESTOR_ID("ancestorid", true, true, true),
    PARENT_ID("parentid", true, false, false),
    ANCESTOR_LABEL("ancestorlabel", false, true, false),
    POPULARITY("popularity", false, true, false),
    PRODUCT("product", true, true, false),
    REFPAGE_FLAG("ref_page", true, false, false),
    REFPAGE_ENTITY_INFO("ref_entity", true, true, true),
    REFPAGE_ENTITY_NAME("ref_name", true, false, true),
    REFPAGE_ENTITY_INFO_CASE("ref_entity_case", true, false, true),
    REFPAGE_ENTITY_NAME_CASE("ref_name_case", true, false, true),
    REFPAGE_ENTITY_TYPE("ref_type", true, false, true),
    SYNTAX_LINES("syntax", false, true, false),
    UNFACETED_CATEGORY("catfacet", false, true, false);

    private static final Map<String, DocumentationSearchField> BY_NAME;
    private final String fName;
    private final boolean fIndexed;
    private final boolean fStored;
    private final boolean fAnalyzed;

    private static Map<String, DocumentationSearchField> getFieldsByName() {
        HashMap<String, DocumentationSearchField> fieldMap = new HashMap<String, DocumentationSearchField>();
        for (DocumentationSearchField field : DocumentationSearchField.values()) {
            fieldMap.put(field.getFieldName(), field);
        }
        return fieldMap;
    }

    private DocumentationSearchField(String name, boolean indexed, boolean stored, boolean analyzed) {
        this.fName = name;
        this.fIndexed = indexed;
        this.fStored = stored;
        this.fAnalyzed = analyzed;
    }

    public String getFieldName() {
        return this.fName;
    }

    public boolean isIndexed() {
        return this.fIndexed;
    }

    public boolean isStored() {
        return this.fStored;
    }

    public boolean isAnalyzed() {
        return this.fAnalyzed;
    }

    public float getWeight() {
        return 1.0f;
    }

    public BooleanSearchOperator getBooleanOperator() {
        return BooleanSearchOperator.SHOULD_OCCUR;
    }

    public DocumentationSearchField getSearchField() {
        return this;
    }

    public static DocumentationSearchField fromFieldName(String fieldName) {
        return BY_NAME.get(fieldName);
    }

    static {
        BY_NAME = DocumentationSearchField.getFieldsByName();
    }
}

