/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.facets.DocFacet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentationQuery {
    private static final Pattern FACET_PATTERN = Pattern.compile("(\\S+):([\\S-]+)");
    private final String fFullSearchString;
    private final String fSearchText;
    private final Map<DocFacet, String> fFacets;

    public DocumentationQuery(String fullSearchString, ContentFormat format) {
        this.fFullSearchString = fullSearchString == null ? "" : fullSearchString;
        Matcher matcher = FACET_PATTERN.matcher(this.fFullSearchString);
        this.fFacets = new LinkedHashMap<DocFacet, String>();
        StringBuffer searchText = new StringBuffer();
        while (matcher.find()) {
            String field = matcher.group(1);
            DocFacet facet = DocFacet.fromFacetPrefix(field);
            if (facet != null && facet.useFacetWithFormat(format)) {
                String rawValue = matcher.group(2);
                this.fFacets.put(facet, rawValue);
                matcher.appendReplacement(searchText, "");
                continue;
            }
            matcher.appendReplacement(searchText, matcher.group());
        }
        matcher.appendTail(searchText);
        this.fSearchText = searchText.toString().trim().replaceAll("\\s+", " ");
    }

    public String getFullSearchString() {
        return this.fFullSearchString;
    }

    public String getSearchText() {
        return this.fSearchText;
    }

    public Map<DocFacet, String> getFacets() {
        return Collections.unmodifiableMap(this.fFacets);
    }
}

