/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import java.util.Comparator;
import java.util.Locale;

public abstract class DocCenterResultComparator<T>
implements Comparator<T> {
    private final String fSearchText;

    public DocCenterResultComparator(String searchString) {
        this.fSearchText = searchString.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public int compare(T t1, T t2) {
        boolean start2;
        boolean exact2;
        String title1 = this.getTitle(t1).toLowerCase(Locale.ENGLISH);
        String title2 = this.getTitle(t2).toLowerCase(Locale.ENGLISH);
        boolean exact1 = this.fSearchText.equals(title1);
        if (exact1 != (exact2 = this.fSearchText.equals(title2))) {
            return exact1 ? -1 : 1;
        }
        boolean start1 = title1.toLowerCase(Locale.ENGLISH).startsWith(this.fSearchText);
        if (start1 == (start2 = title2.toLowerCase(Locale.ENGLISH).startsWith(this.fSearchText))) {
            int byPopularity = this.compareByPopularity(t1, t2);
            if (byPopularity != 0) {
                return byPopularity;
            }
            int byLength = title1.length() - title2.length();
            if (byLength != 0) {
                return byLength;
            }
            int byScore = this.compareByScore(t1, t2);
            if (byScore != 0) {
                return byScore;
            }
            return title1.compareTo(title2);
        }
        return start1 ? -1 : 1;
    }

    private int compareByPopularity(T t1, T t2) {
        int hits1 = this.getPopularity(t1);
        int hits2 = this.getPopularity(t2);
        return hits2 - hits1;
    }

    private int compareByScore(T t1, T t2) {
        float byScore = this.getScore(t2) - this.getScore(t1);
        if (byScore > 0.0f) {
            return 1;
        }
        if (byScore < 0.0f) {
            return -1;
        }
        return 0;
    }

    protected abstract String getTitle(T var1);

    protected abstract int getPopularity(T var1);

    protected abstract float getScore(T var1);
}

