/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.beans.EnumPair;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.PropertyEditor;
import com.mathworks.page.plottool.plotbrowser.MLPropertyTypeConverter;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import java.awt.Color;
import java.awt.Component;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ComboControl
extends PropertyControl {
    protected final EventHackedComboBox fCombo = new EventHackedComboBox();
    protected Icon[] fIcons;
    protected NumberFormat fNumberFormat;
    protected Object fPrevValue = null;
    protected boolean fCanBeEmpty = true;
    protected boolean fCanBeNegative = true;
    protected boolean fCanBeNAN = true;

    public ComboControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper();
        this.fCombo.setName(string2 + "." + string);
    }

    public ComboControl(String string, EnumPair[] enumPairArray, String string2) {
        this.constructorHelper(enumPairArray);
        this.fCombo.setName(string2 + "." + string);
    }

    public ComboControl(String string, CellEditorListener cellEditorListener, EnumPair[] enumPairArray, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper(enumPairArray);
        this.fCombo.setName(string2 + "." + string);
    }

    public ComboControl(String string, CellEditorListener cellEditorListener, EnumPair[] enumPairArray, String[] stringArray, String string2) {
        super(string, cellEditorListener);
        this.fIcons = new Icon[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.fIcons[i] = stringArray[i] == null ? null : PropertyEditor.makeImage(stringArray[i]);
        }
        this.constructorHelper(enumPairArray);
        this.fCombo.setName(string2 + "." + string);
    }

    private void constructorHelper() {
        this.setCustomEditor((JComponent)((Object)this.fCombo));
    }

    private void constructorHelper(EnumPair[] enumPairArray) {
        this.constructorHelper();
        this.fCombo.setRenderer(new ComboCellRenderer());
        Object[] objectArray = new Object[enumPairArray.length];
        String[] stringArray = new String[enumPairArray.length];
        for (int i = 0; i < enumPairArray.length; ++i) {
            objectArray[i] = enumPairArray[i].getObjectValue();
            stringArray[i] = enumPairArray[i].getName();
        }
        this.setOptions(objectArray, stringArray);
        this.fNumberFormat = NumberFormat.getInstance(Locale.US);
        this.fNumberFormat.setGroupingUsed(false);
        this.setMaximumFractionDigits(3);
    }

    @Override
    public String getName() {
        if (this.fCombo != null) {
            return this.fCombo.getName() + "." + this.getClass().getSimpleName();
        }
        return null;
    }

    public int getMaximumFractionDigits() {
        return this.fNumberFormat.getMaximumFractionDigits();
    }

    public void setMaximumFractionDigits(int n) {
        this.fNumberFormat.setMaximumFractionDigits(n);
    }

    public void setOptions(Object[] objectArray, String[] stringArray) {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        if (stringArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.putValueString(stringArray[i], objectArray[i]);
                defaultComboBoxModel.addElement(stringArray[i]);
            }
        } else {
            for (Object object : objectArray) {
                defaultComboBoxModel.addElement(object);
            }
        }
        this.fCombo.setModel(defaultComboBoxModel);
    }

    @Override
    public void addEditStoppedSupport() {
        this.fCombo.addActionListener(this.action);
    }

    @Override
    public void setDisplayedValue(Object object) {
        this.fCombo.willFireActionEvents = false;
        if (object == PropertyControl.MIXED_VALUES) {
            if (this.fCombo.isEditable()) {
                this.fPrevValue = PropertyControl.MIXED_VALUES;
            } else {
                this.fCombo.setEditable(true);
                this.fPrevValue = PropertyControl.MIXED_VALUES;
                this.fCombo.setEditable(false);
            }
        } else {
            String string = this.valueToString(object);
            if (string != null) {
                this.fPrevValue = string;
            } else if (object instanceof Float) {
                this.fPrevValue = this.fNumberFormat.format(((Float)object).floatValue());
            } else if (object instanceof Double) {
                this.fPrevValue = this.fNumberFormat.format((Double)object);
            } else if (object instanceof String) {
                Object object2 = null;
                for (int i = 0; i < this.fCombo.getItemCount(); ++i) {
                    Object object3 = this.fCombo.getItemAt(i);
                    if (!(object3 instanceof String) || !((String)object3).equalsIgnoreCase((String)object)) continue;
                    object2 = object3;
                    break;
                }
                this.fPrevValue = object2 != null ? object2 : object;
            } else {
                this.fPrevValue = object;
            }
        }
        this.fCombo.setSelectedItem(this.fPrevValue);
        this.fCombo.willFireActionEvents = true;
    }

    public boolean getCanBeEmpty() {
        return this.fCanBeEmpty;
    }

    public void setCanBeEmpty(boolean bl) {
        this.fCanBeEmpty = bl;
    }

    public boolean getCanBeNegative() {
        return this.fCanBeNegative;
    }

    public void setCanBeNegative(boolean bl) {
        this.fCanBeNegative = bl;
    }

    public boolean getCanBeNAN() {
        return this.fCanBeNAN;
    }

    public void setCanBeNAN(boolean bl) {
        this.fCanBeNAN = bl;
    }

    @Override
    public Object getDisplayedValue() {
        String[] stringArray = this.fCombo.getSelectedItem();
        String[] stringArray2 = null;
        if (stringArray instanceof String) {
            Class clazz = this.getPropertyType();
            if (this.fCombo.isEditable()) {
                String string = (String)stringArray;
                String string2 = clazz == MLArrayRef.class ? MLPropertyTypeConverter.lookupDataType(this.getPropertyName(), this.getValue().getClass().getName()) : this.getPropertyType().getName();
                try {
                    if (!this.fCanBeEmpty && string.length() == 0) {
                        this.errorAndCleanup(string, "PropertyControl.error.empty");
                        return null;
                    }
                    if (!this.fCanBeNAN && string.equalsIgnoreCase("nan")) {
                        this.errorAndCleanup(string, "PropertyControl.error.parse");
                        return null;
                    }
                    if (PropertyControl.MIXED_VALUES.equals(string) && this.getValue() != null && this.getValue() instanceof Object[] && (string2.equals("double") || string2.equals("float") || string2.equals("int"))) {
                        return string;
                    }
                    if (string2.equals("double")) {
                        stringArray2 = Double.valueOf(string);
                    } else if (string2.equals("float")) {
                        stringArray2 = Float.valueOf(string);
                    } else if (string2.equals("int")) {
                        stringArray2 = Integer.valueOf(string);
                    } else if (string2.startsWith("[L") && string2.indexOf("String") > -1) {
                        stringArray2 = new String[]{string};
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorAndCleanup(string, "PropertyControl.error.parse");
                    return null;
                }
                if (!this.fCanBeNegative && (string2.equals("double") && (Double)stringArray2 <= 0.0 || string2.equals("float") && ((Float)stringArray2).floatValue() <= 0.0f || string2.equals("int") && (Integer)stringArray2 <= 0)) {
                    this.errorAndCleanup(string, "PropertyControl.error.negative");
                    return null;
                }
            } else {
                stringArray2 = this.stringToValue((String)stringArray);
            }
        }
        if (stringArray2 == null) {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    protected void errorAndCleanup(String string, String string2) {
        ErrorHandler.showSimpleError(MessageFormat.format(PropertyEditorResources.getBundle().getString(string2), string), this.getTopLevelAncestor());
        this.fCombo.willFireActionEvents = false;
        this.fCombo.setSelectedItem(this.fPrevValue);
        this.fCombo.willFireActionEvents = true;
        this.fCombo.requestFocus();
    }

    protected boolean validate(Object object) {
        return true;
    }

    public boolean isEditable() {
        return this.fCombo.isEditable();
    }

    public void setEditable(boolean bl) {
        this.fCombo.setEditable(bl);
    }

    public int getMaximumRowCount() {
        return this.fCombo.getMaximumRowCount();
    }

    public void setMaximumRowCount(int n) {
        this.fCombo.setMaximumRowCount(n);
    }

    class ComboCellRenderer
    extends BasicComboBoxRenderer {
        private final Border selectedBorder = BorderFactory.createLineBorder(UIManager.getColor("ComboBox.selectionBackground"), 2);
        private final Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);

        @Override
        public Color getBackground() {
            return UIManager.getColor("ComboBox.background");
        }

        @Override
        public Color getForeground() {
            return UIManager.getColor("ComboBox.foreground");
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ComboBoxModel comboBoxModel = ComboControl.this.fCombo.getModel();
            if (ComboControl.this.fIcons != null) {
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    if (!comboBoxModel.getElementAt(i).equals(object)) continue;
                    this.setIcon(ComboControl.this.fIcons[i]);
                    if (ComboControl.this.fIcons[i] == null) {
                        this.setText(comboBoxModel.getElementAt(i).toString());
                    } else {
                        this.setText(null);
                    }
                    break;
                }
            } else {
                this.setIcon(null);
            }
            if (n >= 0) {
                if (bl) {
                    this.setBorder(this.selectedBorder);
                } else {
                    this.setBorder(this.emptyBorder);
                }
            } else {
                this.setBorder(this.emptyBorder);
            }
            return this;
        }
    }

    protected static class EventHackedComboBox
    extends MJComboBox {
        protected boolean willFireActionEvents = true;

        protected EventHackedComboBox() {
        }

        protected void fireActionEvent() {
            if (this.willFireActionEvents) {
                super.fireActionEvent();
            }
        }
    }
}

