/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.page.export.PrintExportSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class PrintExportPanel
extends MJPanel
implements ActionListener,
PropertyChangeListener {
    private String fPrefDir;
    private Vector fExistingStyles = new Vector();
    private MJPanel fPnlProps;
    private _SnapButton fBtnSnap;
    private PrintExportSettings fPrintExportSettings;
    private MJComboBox fComboStyleSheets;
    private MJButton fBtnStyleSheetSave;
    private MJTabbedPane fTabPanel;
    static final String STYLESHEET_DEFAULT = "default";
    private String fCurrentStylesheet = "default";
    static final ResourceBundle sResHandle = ResourceBundle.getBundle("com.mathworks.page.export.resources.RES_PrintExportPreview");
    static final String sAuto = sResHandle.getString("auto");
    private static final String sModified = sResHandle.getString("modified");
    private static final String sDefault = sResHandle.getString("default");

    public PrintExportPanel(String string) throws Exception {
        this.fPrefDir = string;
        this.fPrintExportSettings = new PrintExportSettings(Toolkit.getDefaultToolkit().getScreenResolution());
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PrintExportPanel.this.createUI();
                }
            };
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
        } else {
            this.createUI();
        }
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.fPnlProps = new MJPanel();
        this.fPnlProps.setLayout((LayoutManager)new GridBagLayout());
        this.add((Component)this.fPnlProps, "Center");
        Dimension dimension = new Dimension(250, 50);
        this.fPnlProps.setMinimumSize(dimension);
        this.fPnlProps.setVisible(true);
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        this.fBtnSnap = new _SnapButton((Component)this.fPnlProps);
        this.fBtnSnap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintExportPanel.this.OnBtnSnap();
            }
        });
        this.add((Component)mJPanel, "East");
        mJPanel.add((Component)this.fBtnSnap, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fBtnSnap.setToolTipText(sResHandle.getString("button.hideshowprops"));
        MJLabel mJLabel = new MJLabel(sResHandle.getString("stylesheet"));
        this.fComboStyleSheets = new MJComboBox();
        this.fComboStyleSheets.setEditorColumnCount(15);
        this.fBtnStyleSheetSave = new MJButton(sResHandle.getString("saveas"));
        this.fPnlProps.add((Component)mJLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 3, 3), 0, 0));
        this.fPnlProps.add((Component)this.fComboStyleSheets, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 3, 3, 3), 0, 0));
        this.fPnlProps.add((Component)this.fBtnStyleSheetSave, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 3, 3, 10), 0, 0));
        File[] fileArray = new File(this.fPrefDir).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                string = string.substring(0, string.lastIndexOf(46));
                this.fComboStyleSheets.addItem((Object)string);
                this.fExistingStyles.add(string);
            }
        }
        if (!this.fExistingStyles.contains(STYLESHEET_DEFAULT)) {
            this.fExistingStyles.add(STYLESHEET_DEFAULT);
            this.fComboStyleSheets.addItem((Object)sDefault);
        }
        this.fComboStyleSheets.addActionListener((ActionListener)this);
        this.fBtnStyleSheetSave.addActionListener((ActionListener)this);
        this.fTabPanel = new MJTabbedPane();
        this.fPnlProps.add((Component)this.fTabPanel, (Object)new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 18, 1, new Insets(10, 3, 20, 3), 0, 0));
        this.setName("PreviewPanel");
        this.fComboStyleSheets.setName("Combo_StyleSheetOptions");
        this.fBtnStyleSheetSave.setName("Button_StyleSheetSaveAs");
        this.fBtnSnap.setName("Button_Snap");
        this.fTabPanel.setName("TabbedProperties");
    }

    public void addTabbedPanel(final String string, final String string2, final MJPanel mJPanel) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PrintExportPanel.this.fTabPanel.add(string, (Component)mJPanel);
                mJPanel.setName(string2);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public void setActiveTab(final int n) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PrintExportPanel.this.fTabPanel.setSelectedIndex(n);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public void initialize(final double d, final double d2, final Object[] objectArray, final Object[] objectArray2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PrintExportPanel.this.initialize(d, d2, objectArray, objectArray2);
                }
            };
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
        } else {
            this.fPrintExportSettings.removePropertyChangeListener(this);
            this.fPrintExportSettings.initialize(d, d2, objectArray, objectArray2);
            String string = this.fPrintExportSettings.getStylesheet();
            this.fComboStyleSheets.removeActionListener((ActionListener)this);
            if (!this.fExistingStyles.contains(string) || string.equals(sModified)) {
                string = sModified;
                this.fComboStyleSheets.addItem((Object)string);
                this.fComboStyleSheets.setSelectedItem((Object)string);
                this.fPrintExportSettings.setStylesheet(this, string);
            }
            if (string.equals(STYLESHEET_DEFAULT)) {
                string = sDefault;
            }
            this.fComboStyleSheets.setSelectedItem((Object)string);
            this.fComboStyleSheets.addActionListener((ActionListener)this);
            this.fPrintExportSettings.addPropertyChangeListener(this);
        }
    }

    public PrintExportSettings getPrintExportSettings() {
        return this.fPrintExportSettings;
    }

    private void OnBtnSnap() {
        boolean bl = this.fPnlProps.isVisible();
        if (bl) {
            this.setVisible(false);
            this.fPnlProps.setVisible(false);
            this.setVisible(true);
        } else {
            this.setVisible(false);
            this.fPnlProps.setVisible(true);
            this.setVisible(true);
        }
        this.fBtnSnap.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object.equals(this.fComboStyleSheets)) {
                this.onStyleSheetChanged();
            } else if (object.equals(this.fBtnStyleSheetSave)) {
                this.onStyleSheetSave();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onStyleSheetChanged() {
        String string = (String)this.fComboStyleSheets.getSelectedItem();
        if (!string.equals(sModified)) {
            this.fPrintExportSettings.removePropertyChangeListener(this);
            try {
                if (string.equals(sDefault)) {
                    string = STYLESHEET_DEFAULT;
                }
                File file = new File(this.fPrefDir, string + ".txt");
                this.fPrintExportSettings.LoadStyleSheet(file.getAbsolutePath());
                this.fComboStyleSheets.removeItem((Object)sModified);
                this.fCurrentStylesheet = string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.fPrintExportSettings.addPropertyChangeListener(this);
        }
    }

    private void onStyleSheetSave() {
        DialogSaveStyleSheet dialogSaveStyleSheet = new DialogSaveStyleSheet();
        dialogSaveStyleSheet.setModal(true);
        dialogSaveStyleSheet.setName("Dlg_SaveStyleSheet");
        dialogSaveStyleSheet.setTitle(sResHandle.getString("savestylesheet"));
        Dimension dimension = dialogSaveStyleSheet.getPreferredSize();
        dialogSaveStyleSheet.setSize((int)(dimension.getWidth() * 1.25), (int)(dimension.getHeight() * 1.5));
        dialogSaveStyleSheet.setLocation(this.fBtnStyleSheetSave.getLocationOnScreen());
        String string = dialogSaveStyleSheet.showDialog();
        if (string != null) {
            this.fComboStyleSheets.removeActionListener((ActionListener)this);
            this.fComboStyleSheets.removeItem((Object)sModified);
            if (!this.fExistingStyles.contains(string)) {
                this.fExistingStyles.add(string);
                this.fComboStyleSheets.addItem((Object)string);
            }
            this.fComboStyleSheets.setSelectedItem((Object)string);
            this.fComboStyleSheets.addActionListener((ActionListener)this);
            this.fCurrentStylesheet = string;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("StyleSheet")) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.fComboStyleSheets.removeActionListener((ActionListener)this);
            this.fComboStyleSheets.removeItem((Object)sModified);
            if (!this.fExistingStyles.contains(string)) {
                this.fExistingStyles.add(string);
                this.fComboStyleSheets.addItem((Object)string);
            }
            this.fComboStyleSheets.setSelectedItem((Object)string);
            this.fComboStyleSheets.addActionListener((ActionListener)this);
        } else if (!this.fComboStyleSheets.getSelectedItem().equals(sModified) && this.needMarkModified(propertyChangeEvent)) {
            this.fPrintExportSettings.removePropertyChangeListener(this);
            this.fComboStyleSheets.addItem((Object)sModified);
            this.fComboStyleSheets.setSelectedItem((Object)sModified);
            this.fPrintExportSettings.setStylesheet(this, sModified);
            this.fPrintExportSettings.addPropertyChangeListener(this);
        }
    }

    private boolean needMarkModified(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        PrintExportSettings printExportSettings = (PrintExportSettings)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        bl = (string != "PaperPosition" || !printExportSettings.isPositionModeAuto()) && string != "FigSize";
        return bl;
    }

    static String convertL10n(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return stringArray2[i];
        }
        return string;
    }

    private class DialogSaveStyleSheet
    extends MJDialog
    implements ActionListener {
        private MJRadioButton fRadExistingStylesheet;
        private MJRadioButton fRadNewStylesheet;
        private MJComboBox fComboExistingStylesheets;
        private MJTextField fTextNewStylesheet;
        private MJButton fBtnSave;
        private MJButton fBtnCancel;
        private String fSavedName;
        private boolean fAllowDefaultOverwrite = false;

        DialogSaveStyleSheet() {
            this.createUI();
        }

        private void createUI() {
            Vector vector = (Vector)PrintExportPanel.this.fExistingStyles.clone();
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            if (!this.fAllowDefaultOverwrite) {
                vector.remove(PrintExportPanel.STYLESHEET_DEFAULT);
            }
            this.fRadExistingStylesheet = new MJRadioButton(sResHandle.getString("stylesheet.save.existing"));
            this.fRadExistingStylesheet.setName("RadBtn_OverwriteExistingStylesheet");
            this.fRadNewStylesheet = new MJRadioButton(sResHandle.getString("stylesheet.save.new"));
            this.fRadNewStylesheet.setName("RadBtn_CreateNewStylesheet");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.fRadExistingStylesheet);
            buttonGroup.add((AbstractButton)this.fRadNewStylesheet);
            this.fRadExistingStylesheet.addActionListener((ActionListener)this);
            this.fRadNewStylesheet.addActionListener((ActionListener)this);
            this.fComboExistingStylesheets = new MJComboBox();
            this.fComboExistingStylesheets.setName("Combo_OverwriteExistingStylesheet");
            this.fTextNewStylesheet = new MJTextField();
            this.fTextNewStylesheet.setName("Text_CreateNewStylesheet");
            for (int i = 0; i < vector.size(); ++i) {
                this.fComboExistingStylesheets.addItem(vector.get(i));
            }
            this.fComboExistingStylesheets.setSelectedItem((Object)PrintExportPanel.this.fCurrentStylesheet);
            this.fBtnSave = new MJButton(sResHandle.getString("save"));
            this.fBtnSave.setName("Btn_Save");
            this.fBtnCancel = new MJButton(sResHandle.getString("cancel"));
            this.fBtnCancel.setName("Btn_Cancel");
            this.fBtnSave.addActionListener((ActionListener)this);
            this.fBtnCancel.addActionListener((ActionListener)this);
            container.add((Component)this.fRadExistingStylesheet, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
            container.add((Component)this.fComboExistingStylesheets, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 3, 0, 6), 0, 0));
            container.add((Component)this.fRadNewStylesheet, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 6, 0, 0), 0, 0));
            container.add((Component)this.fTextNewStylesheet, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 6), 0, 0));
            container.add((Component)this.fBtnSave, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 12, 0, new Insets(6, 3, 6, 0), 0, 0));
            container.add((Component)this.fBtnCancel, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 12, 0, new Insets(6, 3, 6, 6), 0, 0));
            if (vector.isEmpty()) {
                this.fRadNewStylesheet.setSelected(true);
                this.fRadExistingStylesheet.setEnabled(false);
                this.fComboExistingStylesheets.setEnabled(false);
            } else {
                this.fRadExistingStylesheet.setSelected(true);
                this.fTextNewStylesheet.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(this.fRadExistingStylesheet) || object.equals(this.fRadNewStylesheet)) {
                this.onSaveTypeChanged();
            } else if (object.equals(this.fBtnSave)) {
                this.onSave();
            } else if (object.equals(this.fBtnCancel)) {
                this.onCancel();
            }
        }

        private void onSaveTypeChanged() {
            if (this.fRadExistingStylesheet.isSelected()) {
                this.fComboExistingStylesheets.setEnabled(true);
                this.fTextNewStylesheet.setEnabled(false);
            } else {
                this.fComboExistingStylesheets.setEnabled(false);
                this.fTextNewStylesheet.setEnabled(true);
            }
        }

        public String showDialog() {
            super.show();
            return this.fSavedName;
        }

        private void onSave() {
            try {
                String string;
                if (this.fRadExistingStylesheet.isSelected()) {
                    this.fSavedName = string = (String)this.fComboExistingStylesheets.getSelectedItem();
                } else {
                    string = this.fTextNewStylesheet.getText().trim();
                    if (string.length() == 0) {
                        MJOptionPane.showMessageDialog((Component)((Object)this), (Object)"Please enter a stylesheet name");
                        return;
                    }
                    for (int i = 0; i < this.fComboExistingStylesheets.getItemCount(); ++i) {
                        if (!this.fComboExistingStylesheets.getItemAt(i).equals(string)) continue;
                        if (JOptionPane.showOptionDialog((Component)((Object)this), "Stylesheet with the given name exits.\n Do you want to overwrite", "Print Preview Warning", 0, 2, null, null, null) == 0) break;
                        return;
                    }
                    this.fSavedName = string;
                }
                PrintExportPanel.this.fPrintExportSettings.SaveStyleSheet(new File(PrintExportPanel.this.fPrefDir, string + ".txt").getAbsolutePath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.fSavedName = null;
            }
            this.dispose();
        }

        private void onCancel() {
            this.dispose();
        }
    }

    private class _SnapButton
    extends JButton {
        private static final int SIZE = 5;
        private Component fComponent;

        _SnapButton(Component component) {
            this.fComponent = component;
            Dimension dimension = new Dimension(5, 50);
            this.setBorderPainted(false);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setPreferredSize(dimension);
            this.setBackground(new Color(1.0f, 0.9843137f, 0.94509804f));
        }

        @Override
        public void paint(Graphics graphics) {
            super.paintComponent(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            int n = (int)rectangle.getMinX();
            int n2 = (int)rectangle.getMinY();
            int n3 = (int)rectangle.getMaxX();
            int n4 = (int)rectangle.getMaxY();
            int n5 = (n2 + n4) / 2;
            graphics.drawLine(n, n4, n, n2);
            graphics.drawLine(n, n2, n3, n2);
            graphics.drawLine(n3, n2, n3, n4);
            graphics.drawLine(n3, n4, n, n4);
            graphics.drawLine(n3, n4 - 1, n, n4 - 1);
            if (this.fComponent.isVisible()) {
                graphics.drawLine(n, n5 + 5, n3, n5);
                graphics.drawLine(n, n5 - 5, n3, n5);
            } else {
                graphics.drawLine(n3, n5 + 5, n, n5);
                graphics.drawLine(n3, n5 - 5, n, n5);
            }
        }
    }
}

