/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.binding.KeyStrokeList;
import java.util.Arrays;
import java.util.List;
import javax.swing.KeyStroke;

public class NavigationalBindingUtils {
    private NavigationalBindingUtils() {
    }

    static boolean hasNavigationalStrokes(KeyStrokeList keyStrokeList) {
        return NavigationalBindingUtils.hasKeypadNavigationalStrokes(keyStrokeList) || NavigationalBindingUtils.hasRegularNavigationalStrokes(keyStrokeList);
    }

    public static boolean hasKeypadNavigationalStrokes(KeyStrokeList keyStrokeList) {
        for (KeyStroke keyStroke : keyStrokeList.getKeyStrokes()) {
            if (keyStroke.getKeyCode() != 225 && keyStroke.getKeyCode() != 224 && keyStroke.getKeyCode() != 226 && keyStroke.getKeyCode() != 227) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRegularNavigationalStrokes(KeyStrokeList keyStrokeList) {
        for (KeyStroke keyStroke : keyStrokeList.getKeyStrokes()) {
            if (keyStroke.getKeyCode() != 40 && keyStroke.getKeyCode() != 38 && keyStroke.getKeyCode() != 37 && keyStroke.getKeyCode() != 39) continue;
            return true;
        }
        return false;
    }

    private static KeyStrokeList getVersionWithKeypad(KeyStrokeList keyStrokeList) {
        if (NavigationalBindingUtils.hasRegularNavigationalStrokes(keyStrokeList)) {
            KeyStroke[] keyStrokeArray = new KeyStroke[keyStrokeList.getKeyStrokes().size()];
            for (int i = 0; i != keyStrokeArray.length; ++i) {
                KeyStroke keyStroke = keyStrokeList.getKeyStrokes().get(i);
                keyStrokeArray[i] = keyStroke.getKeyCode() == 40 ? KeyStroke.getKeyStroke(225, keyStroke.getModifiers()) : (keyStroke.getKeyCode() == 38 ? KeyStroke.getKeyStroke(224, keyStroke.getModifiers()) : (keyStroke.getKeyCode() == 37 ? KeyStroke.getKeyStroke(226, keyStroke.getModifiers()) : (keyStroke.getKeyCode() == 39 ? KeyStroke.getKeyStroke(227, keyStroke.getModifiers()) : keyStroke)));
            }
            return new KeyStrokeList(keyStrokeArray);
        }
        return keyStrokeList;
    }

    private static KeyStrokeList getVersionWithoutKeypad(KeyStrokeList keyStrokeList) {
        if (NavigationalBindingUtils.hasKeypadNavigationalStrokes(keyStrokeList)) {
            KeyStroke[] keyStrokeArray = new KeyStroke[keyStrokeList.getKeyStrokes().size()];
            for (int i = 0; i != keyStrokeArray.length; ++i) {
                KeyStroke keyStroke = keyStrokeList.getKeyStrokes().get(i);
                keyStrokeArray[i] = keyStroke.getKeyCode() == 225 ? KeyStroke.getKeyStroke(40, keyStroke.getModifiers()) : (keyStroke.getKeyCode() == 224 ? KeyStroke.getKeyStroke(38, keyStroke.getModifiers()) : (keyStroke.getKeyCode() == 226 ? KeyStroke.getKeyStroke(37, keyStroke.getModifiers()) : (keyStroke.getKeyCode() == 227 ? KeyStroke.getKeyStroke(39, keyStroke.getModifiers()) : keyStroke)));
            }
            return new KeyStrokeList(keyStrokeArray);
        }
        return keyStrokeList;
    }

    static List<KeyStrokeList> getAllVersions(KeyStrokeList keyStrokeList) {
        assert (NavigationalBindingUtils.hasNavigationalStrokes(keyStrokeList)) : "This method should only be called if the binding contains navigation strokes";
        return Arrays.asList(NavigationalBindingUtils.getVersionWithoutKeypad(keyStrokeList), NavigationalBindingUtils.getVersionWithKeypad(keyStrokeList));
    }
}

