/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.SimpleDOMParser;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNode;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.mwswing.binding.ReadWriteException;
import com.mathworks.util.PlatformInfo;
import com.mathworks.xml.XMLUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Element;

public class KeyBindingReaderUtils {
    static final String ACTION_TAG = "Action";
    static final String CONTEXT_TAG = "Context";
    static final String KEYSET_TAG = "KeySet";
    static final String RES_BUNDLE_ATTRIBUTE = "resbundle";
    static final String FOLLOWS_ATTRIBUTE = "follows";
    static final String ID_ATTRIBUTE = "id";
    static final String UNSPECIFIED_VALUE = "Unspecified";
    static final String LABEL_RES = "Label";
    public static final String CUSTOM_KEY_SET_TAG = "CustomKeySet";
    static final String DERIVED_FROM_ATTRIBUTE = "derivedfrom";
    static final String MODIFIED_DEFAULT_ATTRIBUTE = "modifieddefault";

    private KeyBindingReaderUtils() {
    }

    public static SimpleElement getTopElement(InputStream inputStream, String string) throws ReadWriteException {
        SimpleElement simpleElement = null;
        BufferedReader bufferedReader = null;
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            String string2 = XMLUtils.getEncoding((InputStream)new ByteArrayInputStream(byArray));
            bufferedReader = string2 == null ? new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray))) : new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string2));
            SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
            simpleElement = simpleDOMParser.parse(bufferedReader);
            if (!string.equals(simpleElement.getNodeName())) {
                throw new ReadWriteException(ReadWriteException.IOErrorType.READ_UNKNOWN, "reader.error.missingNode", string);
            }
        }
        catch (IOException iOException) {
            try {
                throw new ReadWriteException(iOException, ReadWriteException.IOErrorType.FILE_READ_ERROR);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((Reader)bufferedReader);
        return simpleElement;
    }

    static String[] getNodeValue(SimpleNode simpleNode, String string, String string2) {
        SimpleNodeList simpleNodeList = simpleNode.getChildNodes();
        String[] stringArray = null;
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            SimpleElement simpleElement = (SimpleElement)simpleNodeList.item(i);
            if (simpleElement == null || !simpleElement.getNodeName().equals(string)) continue;
            stringArray = new String[2];
            stringArray[0] = simpleElement.getFirstChild().getNodeValue();
            if (string2 == null || !simpleElement.hasAttribute(string2)) break;
            stringArray[1] = simpleElement.getAttribute(string2);
            break;
        }
        return stringArray;
    }

    static String getFromRes(ResourceBundle resourceBundle, String string, String string2, String string3) throws ReadWriteException {
        return KeyBindingReaderUtils.getFromRes(resourceBundle, string, string2, string3, true);
    }

    static String getFromRes(ResourceBundle resourceBundle, String string, String string2, String string3, boolean bl) throws ReadWriteException {
        assert (resourceBundle != null) : "This class has no resource bundle.";
        String string4 = string + "." + string2 + "." + string3;
        String string5 = null;
        try {
            string5 = resourceBundle.getString(string4);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (bl && string5 == null) {
            throw new ReadWriteException(ReadWriteException.IOErrorType.READ_RESOURCE_ERROR, "reader.error.missingKey", string4);
        }
        return string5;
    }

    static ResourceBundle getResourceBundle(SimpleElement simpleElement) {
        String string = simpleElement.getAttribute(RES_BUNDLE_ATTRIBUTE);
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.replace('/', '.');
        int n = string.lastIndexOf(".properties");
        assert (n != -1) : "Resource file '" + string + "' did not end in properties";
        string = string.substring(0, n);
        return ResourceBundle.getBundle(string);
    }

    static List<KeyStrokeList> createKeyBindings(SimpleElement simpleElement, boolean bl) {
        LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>();
        SimpleNodeList simpleNodeList = simpleElement.getChildNodes();
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            if (simpleElement2 == null) continue;
            if (simpleElement2.getNodeName().equals("Stroke")) {
                linkedList.add(new KeyStrokeList(KeyBindingReaderUtils.getStrokeFromElement(simpleElement2)));
                continue;
            }
            if (!simpleElement2.getNodeName().equals("Sequence")) continue;
            SimpleNodeList simpleNodeList2 = simpleElement2.getChildNodes();
            LinkedList<KeyStroke> linkedList2 = new LinkedList<KeyStroke>();
            for (int j = 0; j < simpleNodeList2.getLength(); ++j) {
                SimpleElement simpleElement3 = (SimpleElement)simpleNodeList2.item(j);
                if (simpleElement3 == null || !simpleElement3.getNodeName().equals("Stroke")) continue;
                linkedList2.add(KeyBindingReaderUtils.getStrokeFromElement(simpleElement3));
            }
            if (linkedList2.isEmpty()) continue;
            linkedList.add(new KeyStrokeList(linkedList2.toArray(new KeyStroke[linkedList2.size()])));
        }
        if (linkedList.isEmpty() && !bl) {
            linkedList = null;
        }
        return linkedList;
    }

    static List<KeyStrokeList> createKeyBindings(SimpleElement simpleElement) {
        return KeyBindingReaderUtils.createKeyBindings(simpleElement, false);
    }

    private static KeyStroke getStrokeFromElement(SimpleElement simpleElement) {
        String string = simpleElement.getAttribute("code");
        Integer n = (Integer)KeyStrokeUtils.sVK_NameToValueMap.get(string);
        boolean bl = KeyBindingReaderUtils.isModifierOn(simpleElement, "alt");
        boolean bl2 = KeyBindingReaderUtils.isModifierOn(simpleElement, "altgraph");
        boolean bl3 = KeyBindingReaderUtils.isModifierOn(simpleElement, "sysctrl");
        boolean bl4 = KeyBindingReaderUtils.isModifierOn(simpleElement, "ctrl");
        boolean bl5 = KeyBindingReaderUtils.isModifierOn(simpleElement, "meta");
        boolean bl6 = KeyBindingReaderUtils.isModifierOn(simpleElement, "shift");
        return KeyStrokeUtils.createKeyStroke(n, bl, bl2, bl3, bl4, bl5, bl6);
    }

    private static boolean isModifierOn(SimpleElement simpleElement, String string) {
        String string2 = simpleElement.getAttribute(string);
        return string2 != null && string2.equalsIgnoreCase("on");
    }

    static void addKeyStrokeToElement(Element element, KeyStroke keyStroke) {
        element.setAttribute("code", KeyStrokeUtils.sVK_ValueToNameMap.get(keyStroke.getKeyCode()));
        int n = keyStroke.getModifiers();
        if ((n & 8) != 0) {
            element.setAttribute("alt", "on");
        }
        if ((n & 0x20) != 0) {
            element.setAttribute("altgraph", "on");
        }
        if (PlatformInfo.isMacintosh() && (n & KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK) != 0) {
            element.setAttribute("sysctrl", "on");
        }
        if ((n & 2) != 0) {
            element.setAttribute("ctrl", "on");
        }
        if ((n & 4) != 0) {
            element.setAttribute("meta", "on");
        }
        if ((n & 1) != 0) {
            element.setAttribute("shift", "on");
        }
    }
}

