/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.Painter;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.mwswing.ToolTipProvider;
import com.mathworks.mwswing.WeakPropertyChangeCoupler;
import com.mathworks.mwswing.text.MTextAction;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MJButton
extends JButton {
    protected boolean fFlyOverAppearance = false;
    protected boolean fTextHidden = false;
    protected boolean fAcceptFocus = true;
    protected boolean fAutoMnemonicEnabled = true;
    protected String fOriginalString = "";
    private boolean fInPaint;
    private PropertyChangeListener fActionPropertyHandler;
    private Painter<AbstractButton> fBackgroundPainter = null;
    protected static final String BASE_NAME = "Button";
    private static HierarchyListener sLocalHierarchyListener = new LocalHierarchyListener();
    static JToolBar sDummyToolBarParent;

    public MJButton() {
        this.setText("");
        this.doCustomSetup();
        this.addSafetyListener();
    }

    public MJButton(Action action) {
        this.setAction(action);
        this.doCustomSetup();
        this.addSafetyListener();
    }

    public MJButton(Icon icon) {
        super(icon);
        this.setText("");
        this.doCustomSetup();
        this.addSafetyListener();
    }

    public MJButton(String string) {
        this.setText(string);
        this.doCustomSetup();
        this.addSafetyListener();
    }

    public MJButton(String string, Icon icon) {
        super(icon);
        this.setText(string);
        this.doCustomSetup();
        this.addSafetyListener();
    }

    protected void doCustomSetup() {
        this.setBorderPainted(!this.fFlyOverAppearance);
        FlyOverListener flyOverListener = new FlyOverListener();
        this.addMouseListener(flyOverListener);
        this.addFocusListener(flyOverListener);
        this.addHierarchyListener(sLocalHierarchyListener);
    }

    @Override
    public Color getForeground() {
        return PlatformInfo.isWindowsModernAppearance() && !this.isEnabled() ? UIManager.getColor("Button.foreground") : super.getForeground();
    }

    private void addSafetyListener() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    @Override
    public void setText(String string) {
        if (string != null || !this.fTextHidden) {
            this.fOriginalString = string;
        }
        if (!this.fAutoMnemonicEnabled) {
            super.setText(string);
            return;
        }
        if (string == null) {
            super.setText(null);
            this.setMnemonic('\u0000');
            return;
        }
        super.setText(MJUtilities.exciseAmpersand(string));
        MJUtilities.setMnemonicFromText(this, string);
    }

    public void setAutoMnemonicEnabled(boolean bl) {
        this.fAutoMnemonicEnabled = bl;
        this.setText(this.fOriginalString);
    }

    public boolean isAutoMnemonicEnabled() {
        return this.fAutoMnemonicEnabled;
    }

    public void setFlyOverAppearance(boolean bl) {
        this.fFlyOverAppearance = bl;
        this.setBorderPainted(!bl);
    }

    public void setFocusTraversable(boolean bl) {
        this.fAcceptFocus = bl;
        this.setRequestFocusEnabled(bl);
    }

    public boolean hasFlyOverAppearance() {
        return this.fFlyOverAppearance;
    }

    @Override
    public boolean isFocusTraversable() {
        return this.fAcceptFocus;
    }

    protected boolean super_isFocusTraversable() {
        return super.isFocusTraversable();
    }

    @Override
    public void setAction(Action action) {
        Object object;
        Object object2;
        Action action2 = this.getAction();
        if (action2 != null) {
            WeakPropertyChangeCoupler.detach(action2, this.fActionPropertyHandler);
        }
        super.setAction(action);
        if (action == null) {
            if (action2 instanceof MJAbstractAction || action2 instanceof MTextAction) {
                this.setIcon(null);
                this.setName(BASE_NAME);
            }
            return;
        }
        if (this.fActionPropertyHandler == null) {
            this.fActionPropertyHandler = new ActionPropertyHandler();
        }
        WeakPropertyChangeCoupler.attach(action, this.fActionPropertyHandler);
        if (this.getText() != null && this.getMnemonic() != 0 && (object2 = (Integer)action.getValue("MnemonicIndex")) != null) {
            this.setDisplayedMnemonicIndex((Integer)object2);
        }
        if ((object2 = (String)action.getValue("ComponentName")) != null) {
            this.setName((String)object2 + BASE_NAME);
        }
        if (action instanceof MJAbstractAction) {
            object = ((ExtendedAction)action).getButtonOnlyIcon();
            if (object != null) {
                this.setIcon((Icon)object);
            }
        } else if (action instanceof MTextAction && (object = ((ExtendedAction)action).getButtonOnlyIcon()) != null) {
            this.setIcon((Icon)object);
        }
        object = this.getParent();
        if (object instanceof MJToolBar) {
            this.hideText();
        }
    }

    @Override
    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        Integer n = action == null ? null : (Integer)action.getValue("MnemonicKey");
        this.setMnemonic(n == null ? 0 : n);
    }

    @Override
    public String getToolTipText() {
        ToolTipProvider toolTipProvider;
        Action action = this.getAction();
        if (action != null && (toolTipProvider = (ToolTipProvider)action.getValue("toolTipProvider")) != null) {
            return toolTipProvider.getToolTipText();
        }
        return super.getToolTipText();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        ToolTipProvider toolTipProvider;
        Action action = this.getAction();
        if (action != null && (toolTipProvider = (ToolTipProvider)action.getValue("toolTipProvider")) != null) {
            return toolTipProvider.getToolTipText(mouseEvent);
        }
        return super.getToolTipText(mouseEvent);
    }

    public void hideText() {
        this.fTextHidden = true;
        AccessibleContext accessibleContext = this.getAccessibleContext();
        String string = accessibleContext.getAccessibleName();
        this.setText(null);
        if (accessibleContext.getAccessibleName() == null) {
            accessibleContext.setAccessibleName(string);
        }
        this.revalidate();
        this.repaint();
    }

    public void unHideText() {
        if (this.fTextHidden) {
            this.fTextHidden = false;
            this.setText(this.fOriginalString);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = this.isEnabled() && PlatformInfo.isMacintosh() && mouseEvent.isPopupTrigger();
        if (bl) {
            this.setEnabled(false);
        }
        super.processMouseEvent(mouseEvent);
        if (bl) {
            this.setEnabled(true);
        }
    }

    @Override
    public Container getParent() {
        Container container = super.getParent();
        if (this.fFlyOverAppearance && this.fInPaint && PlatformInfo.useWindowsXPAppearance() && !(container instanceof JToolBar) && !this.hasFocus() && (this.getModel().isPressed() || this.getModel().isRollover())) {
            if (sDummyToolBarParent == null) {
                sDummyToolBarParent = new MJToolBar();
            }
            container = sDummyToolBarParent;
        }
        return container;
    }

    @Override
    public boolean isContentAreaFilled() {
        if (this.fFlyOverAppearance && this.fInPaint && PlatformInfo.useWindowsXPAppearance() && !(this.getParent() instanceof JToolBar) && !this.hasFocus() && !this.getModel().isPressed() && !this.getModel().isRollover()) {
            return false;
        }
        return super.isContentAreaFilled();
    }

    @Override
    public void setBorderPainted(boolean bl) {
        boolean bl2 = !this.fFlyOverAppearance || !PlatformInfo.useWindowsXPAppearance();
        super.setBorderPainted(bl && bl2);
    }

    @Override
    public void paint(Graphics graphics) {
        this.fInPaint = true;
        super.paint(graphics);
        this.fInPaint = false;
    }

    public void setBackgroundPainter(Painter<AbstractButton> painter) {
        this.fBackgroundPainter = painter;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.fBackgroundPainter != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            this.fBackgroundPainter.paint(this, graphics2D, 0, 0, this.getWidth(), this.getHeight());
            graphics2D.dispose();
        }
        super.paintComponent(graphics);
    }

    private static class LocalHierarchyListener
    implements HierarchyListener {
        private LocalHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            MJButton mJButton = (MJButton)hierarchyEvent.getComponent();
            ButtonModel buttonModel = mJButton.getModel();
            buttonModel.setArmed(false);
            buttonModel.setRollover(false);
            if (mJButton.hasFlyOverAppearance()) {
                mJButton.setBorderPainted(false);
            }
        }
    }

    private class FlyOverListener
    extends MouseAdapter
    implements FocusListener {
        private boolean fIsOverButton;

        private FlyOverListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.fIsOverButton = true;
            if (MJButton.this.fFlyOverAppearance && MJButton.this.isEnabled() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MJButton.this.setBorderPainted(true);
                MJButton.this.invalidate();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.fIsOverButton = false;
            if (MJButton.this.fFlyOverAppearance && MJButton.this.isBorderPainted() && !MJButton.this.hasFocus() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MJButton.this.setBorderPainted(false);
                MJButton.this.invalidate();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (MJButton.this.fFlyOverAppearance && !this.fIsOverButton && !MJButton.this.hasFocus() && MJButton.this.isBorderPainted()) {
                MJButton.this.setBorderPainted(false);
                MJButton.this.invalidate();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (MJButton.this.fFlyOverAppearance && !MJButton.this.isBorderPainted()) {
                MJButton.this.setBorderPainted(true);
                MJButton.this.invalidate();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (MJButton.this.fFlyOverAppearance && MJButton.this.isBorderPainted() && !this.fIsOverButton) {
                MJButton.this.setBorderPainted(false);
                MJButton.this.invalidate();
            }
        }
    }

    private class ActionPropertyHandler
    implements PropertyChangeListener {
        private ActionPropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("buttonIcon")) {
                MJButton.this.setIcon((Icon)propertyChangeEvent.getNewValue());
            } else if (MJButton.this.getParent() instanceof MJToolBar || MJButton.this.fTextHidden) {
                if (propertyChangeEvent.getPropertyName().equals("Name")) {
                    MJButton.this.hideText();
                } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                    MJButton.this.setMnemonic('\u0000');
                }
            }
        }
    }
}

