/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.FontSize;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;

public final class FontUtils {
    private static final Font SANS_SERIF_13 = new Font("SansSerif", 0, 13);
    private static final String WINDOWS_UIMANAGER_FONT_ENTRY = "OptionPane.font";
    private static String[] sFontListFull;
    private static final String[] FONT_NAMES;
    private static final String[] FONT_NAMES_GLNX;
    private static final String[] FONT_NAMES_SOL2;
    private static final String[] FONT_NAMES_MAC;
    private static final String[] FONT_NAMES_WIN_ENGLISH;
    private static final String[] FONT_NAMES_WIN_JAPANESE;
    private static final String[] FONT_ENCODINGS_ENGLISH;
    private static final String[] FONT_ENCODINGS_JAPANESE;
    private static final int REFERENCE_FONT_INDEX = 0;
    private static String[] sDefaultFontNames;
    private static String[] sDefaultFontEncodings;
    private static final List<FontSize> STANDARD_SIZES;
    private static final File SKIP_FONTS_FILE;
    private static final Collection<String> sFonts;

    private FontUtils() {
    }

    public static Font getSystemUIFont() {
        return PlatformInfo.isMacintosh() ? FontUtils.getMacSystemFont() : (PlatformInfo.isXWindows() ? FontUtils.getLinuxSystemFont() : FontUtils.getWindowsSystemFont());
    }

    public static Font getDefaultReadingFont() {
        return PlatformInfo.isWindows() && LanguageUtils.isCJK() ? FontUtils.getWindowsCJKDefaultFont() : SANS_SERIF_13;
    }

    private static Font getWindowsSystemFont() {
        assert (PlatformInfo.isWindows()) : "This method should only be called on Windows";
        Font font = LanguageUtils.isCJK() ? FontUtils.getWindowsCJKDefaultFont() : UIManager.getFont(WINDOWS_UIMANAGER_FONT_ENTRY);
        assert (font != null) : "Font should never be null";
        return font;
    }

    private static Font getMacSystemFont() {
        assert (PlatformInfo.isMacintosh()) : "This method should only be called on the Macintosh";
        return UIManager.getFont("ToolBar.font");
    }

    private static Font getLinuxSystemFont() {
        assert (PlatformInfo.isXWindows()) : "This method should only be called on Linux";
        return SANS_SERIF_13;
    }

    private static Font getWindowsCJKDefaultFont() {
        assert (PlatformInfo.isWindows()) : "Should only be invoked on Windows";
        assert (LanguageUtils.isCJK()) : "Should only be invoked on Chinese, Japanese or Korean";
        Font font = UIManager.getFont(WINDOWS_UIMANAGER_FONT_ENTRY);
        int n = font.getSize() == 11 ? 12 : font.getSize();
        return font.deriveFont((float)n);
    }

    public static Font getPrinterFont(Font font) {
        return font.deriveFont((float)font.getSize() * 72.0f / 96.0f);
    }

    public static List<String> getFontStyles() {
        return Arrays.asList(MJUtilities.intlString("font.style.plain"), MJUtilities.intlString("font.style.bold"), MJUtilities.intlString("font.style.italic"), MJUtilities.intlString("font.style.bolditalic"));
    }

    public static String styleToString(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("'font' cannot be null");
        }
        String string = font.getStyle() == 0 ? MJUtilities.intlString("font.style.plain") : (font.getStyle() == 2 ? MJUtilities.intlString("font.style.italic") : (font.getStyle() == 1 ? MJUtilities.intlString("font.style.bold") : MJUtilities.intlString("font.style.bolditalic")));
        return string;
    }

    public static int stringToStyle(String string) {
        int n = MJUtilities.intlString("font.style.italic").equals(string) ? 2 : (MJUtilities.intlString("font.style.bold").equals(string) ? 1 : (MJUtilities.intlString("font.style.bolditalic").equals(string) ? 3 : 0));
        return n;
    }

    public static List<String> getFontNames() {
        return Collections.unmodifiableList(Arrays.asList(FontUtils.getFontList()));
    }

    public static List<FontSize> getStandardSizes() {
        return STANDARD_SIZES;
    }

    public static synchronized String[] getFontList() {
        if (sFontListFull == null) {
            List list = Collections.emptyList();
            try {
                if (SKIP_FONTS_FILE.exists()) {
                    list = FileUtils.readLines((File)SKIP_FONTS_FILE);
                }
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
            ArrayList<String> arrayList = new ArrayList<String>(sFonts.size());
            for (String string : sFonts) {
                if (string == null || string.length() == 0 || list.contains(string) || !FontUtils.validateFont(new Font(string, 0, 10))) continue;
                arrayList.add(string);
            }
            sFontListFull = arrayList.toArray(new String[arrayList.size()]);
        }
        return sFontListFull;
    }

    public static String getOSFontName(String string) {
        String string2 = FontUtils.translatePureJavaToOS(string);
        if (string2 != null) {
            return FontUtils.escapesToUnicode(string2);
        }
        return string;
    }

    public static synchronized String getOSFontEncoding(String string) {
        if (!PlatformInfo.isWindows()) {
            return null;
        }
        if (sDefaultFontNames == null) {
            FontUtils.initFontValues();
        }
        for (int i = 0; i < 5; ++i) {
            if (!string.equalsIgnoreCase(FONT_NAMES[i])) continue;
            return sDefaultFontEncodings[i];
        }
        return sDefaultFontEncodings[0];
    }

    private static synchronized String translatePureJavaToOS(String string) {
        if (sDefaultFontNames == null) {
            FontUtils.initFontValues();
        }
        for (int i = 0; i < 5; ++i) {
            if (!string.equalsIgnoreCase(FONT_NAMES[i])) continue;
            return sDefaultFontNames[i];
        }
        return null;
    }

    private static synchronized void initFontValues() {
        if (PlatformInfo.isWindows()) {
            if (LanguageUtils.isJapanese()) {
                sDefaultFontNames = FONT_NAMES_WIN_JAPANESE;
                sDefaultFontEncodings = FONT_ENCODINGS_JAPANESE;
            } else {
                sDefaultFontNames = FONT_NAMES_WIN_ENGLISH;
                sDefaultFontEncodings = FONT_ENCODINGS_ENGLISH;
            }
        }
        if (PlatformInfo.isLinux()) {
            sDefaultFontNames = FONT_NAMES_GLNX;
        }
        if (PlatformInfo.isSolaris()) {
            sDefaultFontNames = FONT_NAMES_SOL2;
        }
        if (PlatformInfo.isMacintosh()) {
            sDefaultFontNames = FONT_NAMES_MAC;
        }
        if (sDefaultFontNames == null) {
            sDefaultFontNames = FONT_NAMES_SOL2;
        }
    }

    private static String escapesToUnicode(String string) {
        StringBuilder stringBuilder = new StringBuilder(64);
        if (string == null) {
            string = FontUtils.translatePureJavaToOS(FONT_NAMES[0]);
        }
        EscapeHandler escapeHandler = new EscapeHandler(new StringReader(string));
        try {
            int n = escapeHandler.read();
            while (n != -1) {
                stringBuilder.append((char)n);
                n = escapeHandler.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int getTextWidth(Font font, String string) {
        return FontUtils.getFontMetrics(font).stringWidth(string);
    }

    public static Dimension getTextSize(Font font, String string) {
        FontMetrics fontMetrics = FontUtils.getFontMetrics(font);
        return new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
    }

    public static int getAscent(Font font) {
        return FontUtils.getFontMetrics(font).getAscent();
    }

    public static boolean validateFont(Font font) {
        return sFonts.contains(font.getName()) && font.canDisplay('a') && font.canDisplay('z') && font.canDisplay('A') && font.canDisplay('Z') && font.canDisplay('0') && font.canDisplay('1');
    }

    static {
        if (PlatformInfo.isWindows() && LanguageUtils.isJapanese()) {
            GraphicsEnvironment.getLocalGraphicsEnvironment().preferProportionalFonts();
        }
        sFontListFull = null;
        FONT_NAMES = new String[]{"dialog", "dialoginput", "serif", "sansserif", "monospaced"};
        FONT_NAMES_GLNX = new String[]{"lucida", "lucidatypewriter", "lucidabright", "lucida", "lucidatypewriter"};
        FONT_NAMES_SOL2 = new String[]{"helvetica", "courier", "times", "helvetica", "courier"};
        FONT_NAMES_MAC = new String[]{"helvetica", "courier", "times", "helvetica", "courier"};
        FONT_NAMES_WIN_ENGLISH = new String[]{"Arial", "Courier New", "Times New Roman", "Arial", "Courier New"};
        FONT_NAMES_WIN_JAPANESE = new String[]{"Arial", "Courier New", "Times New Roman", "Arial", "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af"};
        FONT_ENCODINGS_ENGLISH = new String[]{"ANSI_CHARSET", "ANSI_CHARSET", "ANSI_CHARSET", "ANSI_CHARSET", "ANSI_CHARSET"};
        FONT_ENCODINGS_JAPANESE = new String[]{"ANSI_CHARSET", "ANSI_CHARSET", "ANSI_CHARSET", "ANSI_CHARSET", "SHIFTJIS_CHARSET"};
        sDefaultFontNames = null;
        sDefaultFontEncodings = null;
        STANDARD_SIZES = Arrays.asList(FontSize.createFromPointSize(8), FontSize.createFromPointSize(9), FontSize.createFromPointSize(10), FontSize.createFromPointSize(12), FontSize.createFromPointSize(14), FontSize.createFromPointSize(18), FontSize.createFromPointSize(24), FontSize.createFromPointSize(36), FontSize.createFromPointSize(48));
        SKIP_FONTS_FILE = new File(com.mathworks.util.FileUtils.getPreferencesDirectory(), "badfonts.txt");
        sFonts = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    private static class EscapeHandler
    extends FilterReader {
        EscapeHandler(StringReader stringReader) {
            super(stringReader);
        }

        @Override
        public int read() throws IOException {
            int n = this.in.read();
            if (n != 92) {
                return n;
            }
            this.in.mark(1);
            int n2 = this.in.read();
            if (n2 != 117) {
                this.in.reset();
                return n;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((char)this.in.read());
            stringBuilder.append((char)this.in.read());
            stringBuilder.append((char)this.in.read());
            stringBuilder.append((char)this.in.read());
            String string = stringBuilder.toString();
            try {
                return Integer.valueOf(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Bad Unicode escape");
            }
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            int n4 = 0;
            for (int i = n; i < n + n2 && (n3 = this.in.read()) != -1; ++i) {
                cArray[i] = (char)n3;
                ++n4;
            }
            return n4;
        }

        @Override
        public long skip(long l) throws IOException {
            char[] cArray = new char[(int)l];
            return this.read(cArray);
        }
    }
}

