/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import org.apache.commons.lang.Validate;

public final class FontSize {
    private static final float JAVA_DPI = 72.0f;
    private static final float SCREEN_DPI;
    private static float sScreenDpi;
    private final int fDisplaySize;
    private final int fJavaSize;

    public static FontSize createFromPointSize(String string) {
        try {
            Float f = Float.valueOf(Float.parseFloat(string.trim()));
            if (f.floatValue() > 0.0f) {
                return FontSize.createFromPointSize(Math.round(f.floatValue()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static FontSize createFromPointSize(int n) {
        Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)("'pointSize' must be greater than zero: " + n));
        return new FontSize((float)n * (sScreenDpi / 72.0f), n);
    }

    public static FontSize createFromJavaFont(Font font) {
        Validate.notNull((Object)font, (String)"'javaFont' cannot be null");
        return new FontSize(font.getSize(), (float)font.getSize() * 72.0f / sScreenDpi);
    }

    public int getJavaSize() {
        return this.fJavaSize;
    }

    public String getDisplaySize() {
        return String.valueOf(this.fDisplaySize);
    }

    public int hashCode() {
        return this.getJavaSize();
    }

    public boolean equals(Object object) {
        return object instanceof FontSize && ((FontSize)object).getJavaSize() == this.getJavaSize();
    }

    public String toString() {
        return this.getDisplaySize();
    }

    private FontSize(float f, float f2) {
        this.fDisplaySize = Math.round(f2);
        this.fJavaSize = Math.round(f);
    }

    private static void setScreenDpi(int n) {
        sScreenDpi = n;
    }

    static {
        sScreenDpi = SCREEN_DPI = GraphicsEnvironment.isHeadless() ? 96.0f : (float)Toolkit.getDefaultToolkit().getScreenResolution();
    }
}

