/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class FocusReturnHandler {
    private Component fPreviousFocusOwner;

    public FocusReturnHandler(Component component) {
        this.setup(component);
    }

    private void setup(final Component component) {
        if (component instanceof JComboBox) {
            this.setup(((JComboBox)component).getEditor().getEditorComponent());
        }
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Component component2 = focusEvent.getOppositeComponent();
                if (component2 != null && FocusReturnHandler.this.fPreviousFocusOwner == null && !(component2 instanceof JRootPane) && SwingUtilities.windowForComponent(component2) == SwingUtilities.windowForComponent(focusEvent.getComponent())) {
                    FocusReturnHandler.this.fPreviousFocusOwner = component2;
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Component component2;
                if (!(focusEvent.isTemporary() || (component2 = focusEvent.getOppositeComponent()) != null && SwingUtilities.isDescendingFrom(component2, component.getParent()))) {
                    FocusReturnHandler.this.fPreviousFocusOwner = null;
                }
            }
        });
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27 || n == 9 && keyEvent.isControlDown()) {
                    FocusReturnHandler.this.relinquishFocus();
                }
            }
        });
    }

    public void relinquishFocus() {
        if (this.fPreviousFocusOwner != null) {
            this.fPreviousFocusOwner.requestFocus();
            this.fPreviousFocusOwner = null;
        }
    }
}

