/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.SearchField;
import com.mathworks.search.Visitable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class SearchExpression
implements Visitable {
    private List<SearchField> fSearchFields;
    private BooleanSearchOperator fOperator = BooleanSearchOperator.MUST_OCCUR;

    protected SearchExpression() {
    }

    protected SearchExpression(BooleanSearchOperator operator) {
        this.fOperator = operator;
    }

    public SearchExpression addSearchField(SearchField field) {
        if (this.fSearchFields == null) {
            this.fSearchFields = new ArrayList<SearchField>();
        }
        this.fSearchFields.add(field);
        return this;
    }

    public Collection<SearchField> getSearchFields() {
        if (this.fSearchFields != null) {
            return Collections.unmodifiableCollection(this.fSearchFields);
        }
        return null;
    }

    public void setBooleanOperator(BooleanSearchOperator operator) {
        this.fOperator = operator;
    }

    public BooleanSearchOperator getBooleanOperator() {
        return this.fOperator;
    }

    protected final String getFieldString() {
        StringBuilder s = new StringBuilder();
        if (this.fSearchFields != null) {
            for (SearchField field : this.fSearchFields) {
                if (s.length() > 0) {
                    s.append(';');
                }
                s.append(field.getFieldName());
                if (field.getWeight() == 1.0f) continue;
                s.append(',').append(String.valueOf(field.getWeight()));
            }
            s.append(':');
        }
        return s.toString();
    }

    protected final String getOperatorString() {
        switch (this.fOperator) {
            case MUST_NOT_OCCUR: {
                return "-";
            }
            case MUST_OCCUR: {
                return "+";
            }
        }
        return "";
    }
}

