/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.ListSearchResults;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchResultScoreComparator;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SimpleResultAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ListSearchResultCollector<T>
implements SearchResultCollector {
    private final SearchResultAdapter<T> fAdapter;
    private final List<SearchResult> fCollectedResults;
    private final Comparator<SearchResult> fComparator;

    private ListSearchResultCollector(SearchResultAdapter<T> adapter) {
        this(adapter, new SearchResultScoreComparator());
    }

    private ListSearchResultCollector(SearchResultAdapter<T> adapter, Comparator<SearchResult> comparator) {
        this.fAdapter = adapter;
        this.fCollectedResults = new ArrayList<SearchResult>();
        this.fComparator = comparator;
    }

    public static ListSearchResultCollector<SearchResult> createCollector() {
        return new ListSearchResultCollector<SearchResult>(new SimpleResultAdapter());
    }

    public static ListSearchResultCollector<SearchResult> createCollector(Comparator<SearchResult> comparator) {
        return new ListSearchResultCollector<SearchResult>(new SimpleResultAdapter(), comparator);
    }

    public static <T> ListSearchResultCollector<T> createCollector(SearchResultAdapter<T> adapter) {
        return new ListSearchResultCollector<T>(adapter);
    }

    public static <T> ListSearchResultCollector<T> createCollector(SearchResultAdapter<T> adapter, Comparator<SearchResult> comparator) {
        return new ListSearchResultCollector<T>(adapter, comparator);
    }

    @Override
    public void examineResult(SearchResult result) throws SearchException {
        this.fCollectedResults.add(result);
    }

    @Override
    public void resultsComplete() {
    }

    public int getNumResults() {
        return this.fCollectedResults.size();
    }

    public SearchResults<T> getResults(int start, int numResults) throws SearchException {
        List<SearchResult> toInclude = this.getResultsToInclude(start, numResults);
        ArrayList<T> external = new ArrayList<T>();
        for (SearchResult rawResult : toInclude) {
            external.add(this.fAdapter.adaptResult(rawResult));
        }
        return new ListSearchResults(external, this.fCollectedResults.size(), start);
    }

    private List<SearchResult> getResultsToInclude(int start, int numResults) {
        if (this.fCollectedResults.size() > start) {
            Collections.sort(this.fCollectedResults, this.fComparator);
            if (start > 0 || numResults > 0 && start + numResults < this.fCollectedResults.size()) {
                return this.fCollectedResults.subList(start, Math.min(start + numResults, this.fCollectedResults.size()));
            }
            return this.fCollectedResults;
        }
        return Collections.emptyList();
    }
}

