/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragListener;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.TooManyListenersException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;

public class ToolPaletteButton
extends MJToggleButton
implements MouseListener,
MouseMotionListener {
    private int fID;
    private boolean fBusy;
    private ButtonGroup buttonGroup;
    private DragListener fDragListener;
    private boolean fMouseIn;
    private boolean fSupportsFocus;
    private boolean fRollover;
    private boolean fWantsToShow;
    private boolean fTracking;

    ToolPaletteButton(Icon icon, String string, ButtonGroup buttonGroup, int n) {
        this.setIcon(icon);
        this.setText(string);
        if (string != null && string.length() > 0) {
            this.setHorizontalAlignment(10);
        }
        this.fID = n;
        this.buttonGroup = buttonGroup;
        buttonGroup.add((AbstractButton)((Object)this));
        if (PlatformInfo.getAppearance() != 0) {
            this.fSupportsFocus = true;
        }
        if (PlatformInfo.useWindowsXPAppearance()) {
            this.fRollover = true;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    ToolPaletteButton(Icon icon, ButtonGroup buttonGroup, int n) {
        this(icon, null, buttonGroup, n);
        this.setHorizontalAlignment(10);
        int n2 = this.getMargin().top + 1;
        this.setMargin(new Insets(n2, n2, n2, n2));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.fBusy) {
            this.fBusy = false;
        }
    }

    public int getID() {
        return this.fID;
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public void setBusy(boolean bl) {
        this.fBusy = bl;
    }

    public boolean isBusy() {
        return this.fBusy;
    }

    public synchronized void addDragListener(DragListener dragListener) throws TooManyListenersException {
        if (this.fDragListener != null) {
            throw new TooManyListenersException();
        }
        this.fDragListener = dragListener;
    }

    public synchronized void removeDragListener(DragListener dragListener) {
        if (this.fDragListener == dragListener) {
            this.fDragListener = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.fRollover && !this.fMouseIn) {
            this.fMouseIn = true;
            if (this.isEnabled()) {
                this.repaint();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.fWantsToShow = false;
        if (this.fRollover && this.fMouseIn) {
            this.fMouseIn = false;
            if (this.isEnabled()) {
                this.repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (this.isEnabled() && rectangle.contains(mouseEvent.getPoint())) {
            this.fTracking = true;
            this.fMouseIn = true;
            if (this.fSupportsFocus) {
                this.requestFocus();
            }
            this.repaint();
            if (this.fDragListener != null) {
                this.fDragListener.startDrag(mouseEvent);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (this.fTracking) {
            this.fTracking = false;
            if (this.fMouseIn != rectangle.contains(mouseEvent.getPoint())) {
                this.fMouseIn = rectangle.contains(mouseEvent.getPoint());
                this.repaint();
            }
            if (this.fMouseIn) {
                this.setSelected(this.isSelected());
                this.fMouseIn = rectangle.contains(mouseEvent.getPoint());
                this.repaint();
            }
            if (this.fDragListener != null) {
                this.fDragListener.finishDrag(mouseEvent);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.fWantsToShow && !this.fMouseIn) {
            this.fWantsToShow = true;
            this.mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fTracking) {
            if (this.fDragListener != null) {
                this.fDragListener.continueDrag(mouseEvent);
            } else {
                boolean bl;
                Point point = mouseEvent.getPoint();
                Dimension dimension = this.getSize();
                boolean bl2 = bl = point.x >= 0 && point.x <= dimension.width && point.y >= 0 && point.y <= dimension.height;
                if (this.fMouseIn != bl) {
                    this.fMouseIn = bl;
                    this.repaint();
                }
            }
        }
    }
}

