/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.layout;

import com.mathworks.services.Prefs;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.layout.LayoutEnum;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoMove;
import java.awt.Point;
import java.util.List;
import java.util.Vector;

public class AlignmentManager {
    private LayoutArea fLayoutArea;

    public AlignmentManager(LayoutArea layoutArea) {
        this.fLayoutArea = layoutArea;
    }

    public void alignControls(LayoutEnum layoutEnum, boolean bl) {
        if (this.fLayoutArea.getSelectedObjectCount() <= 1) {
            return;
        }
        Vector<LOControlWrapper> vector = this.fLayoutArea.getSelectedControls();
        UndoMove undoMove = null;
        if (bl) {
            undoMove = new UndoMove(this.fLayoutArea, vector);
        }
        switch (layoutEnum) {
            case ALIGN_LEFT: {
                AlignmentManager.alignLeft(vector);
                break;
            }
            case ALIGN_RIGHT: {
                AlignmentManager.alignRight(vector);
                break;
            }
            case ALIGN_CENTER_HORZ: {
                AlignmentManager.alignHorizontalCenter(vector);
                break;
            }
            case ALIGN_GRID_HORZ: {
                AlignmentManager.alignHorizontalGrid(vector);
                break;
            }
            case ALIGN_TOP: {
                AlignmentManager.alignTop(vector);
                break;
            }
            case ALIGN_BOTTOM: {
                AlignmentManager.alignBottom(vector);
                break;
            }
            case ALIGN_CENTER_VERT: {
                AlignmentManager.alignVerticalCenter(vector);
                break;
            }
            case ALIGN_GRID_VERT: {
                AlignmentManager.alignVerticalGrid(vector);
            }
        }
        if (bl) {
            if (undoMove.moveComplete()) {
                if (this.fLayoutArea.getFigure() != null) {
                    LayoutLooper.requestMove(vector, null);
                } else {
                    this.fLayoutArea.fireObjectChangedEvent(vector);
                }
                this.fLayoutArea.fireContentChangedEvent();
                this.fLayoutArea.fireUndoEvent(undoMove);
            }
            this.fLayoutArea.updateSelection();
        }
    }

    private static void alignLeft(List<LOControlWrapper> list) {
        LOControlWrapper lOControlWrapper = AlignmentManager.findLeftmostControl(list);
        for (LOControlWrapper lOControlWrapper2 : list) {
            if (lOControlWrapper2.equals(lOControlWrapper)) continue;
            int n = lOControlWrapper2.getLeft() - lOControlWrapper.getLeft();
            lOControlWrapper2.offsetRect(-n, 0);
        }
    }

    private static void alignRight(List<LOControlWrapper> list) {
        LOControlWrapper lOControlWrapper = AlignmentManager.findRightmostControl(list);
        for (LOControlWrapper lOControlWrapper2 : list) {
            if (lOControlWrapper2.equals(lOControlWrapper)) continue;
            int n = lOControlWrapper2.getRight() - lOControlWrapper.getRight();
            lOControlWrapper2.offsetRect(-n, 0);
        }
    }

    private static void alignTop(List<LOControlWrapper> list) {
        LOControlWrapper lOControlWrapper = AlignmentManager.findTopmostControl(list);
        for (LOControlWrapper lOControlWrapper2 : list) {
            if (lOControlWrapper2.equals(lOControlWrapper)) continue;
            int n = lOControlWrapper2.getTop() - lOControlWrapper.getTop();
            lOControlWrapper2.offsetRect(0, -n);
        }
    }

    private static void alignBottom(List<LOControlWrapper> list) {
        LOControlWrapper lOControlWrapper = AlignmentManager.findBottommostControl(list);
        for (LOControlWrapper lOControlWrapper2 : list) {
            if (lOControlWrapper2.equals(lOControlWrapper)) continue;
            int n = lOControlWrapper2.getBottom() - lOControlWrapper.getBottom();
            lOControlWrapper2.offsetRect(0, -n);
        }
    }

    private static void alignHorizontalCenter(List<LOControlWrapper> list) {
        Point point = AlignmentManager.findMassCenterPoint(list);
        for (LOControlWrapper lOControlWrapper : list) {
            Point point2 = AlignmentManager.findObjectCenterPoint(lOControlWrapper);
            int n = point2.x - point.x;
            lOControlWrapper.offsetRect(-n, 0);
        }
    }

    private static void alignVerticalCenter(List<LOControlWrapper> list) {
        Point point = AlignmentManager.findMassCenterPoint(list);
        for (LOControlWrapper lOControlWrapper : list) {
            Point point2 = AlignmentManager.findObjectCenterPoint(lOControlWrapper);
            int n = point2.y - point.y;
            lOControlWrapper.offsetRect(0, -n);
        }
    }

    private static Point findObjectCenterPoint(LOControlWrapper lOControlWrapper) {
        int n = (lOControlWrapper.getLeft() + lOControlWrapper.getRight()) / 2;
        int n2 = (lOControlWrapper.getTop() + lOControlWrapper.getBottom()) / 2;
        return new Point(n, n2);
    }

    private static Point findMassCenterPoint(List<LOControlWrapper> list) {
        LOControlWrapper lOControlWrapper = AlignmentManager.findTopmostControl(list);
        LOControlWrapper lOControlWrapper2 = AlignmentManager.findBottommostControl(list);
        LOControlWrapper lOControlWrapper3 = AlignmentManager.findLeftmostControl(list);
        LOControlWrapper lOControlWrapper4 = AlignmentManager.findRightmostControl(list);
        Point point = new Point(-1, -1);
        point.x = (lOControlWrapper3.getLeft() + lOControlWrapper4.getRight()) / 2;
        point.y = (lOControlWrapper.getTop() + lOControlWrapper2.getBottom()) / 2;
        return point;
    }

    private static LOControlWrapper findTopmostControl(List<LOControlWrapper> list) {
        LOControlWrapper lOControlWrapper = null;
        int n = Integer.MAX_VALUE;
        for (LOControlWrapper lOControlWrapper2 : list) {
            int n2;
            if (!lOControlWrapper2.isSelected() || (n2 = lOControlWrapper2.getTop()) > n) continue;
            lOControlWrapper = lOControlWrapper2;
            n = n2;
        }
        return lOControlWrapper;
    }

    private static LOControlWrapper findBottommostControl(List<LOControlWrapper> list) {
        LOControlWrapper lOControlWrapper = null;
        int n = Integer.MIN_VALUE;
        for (LOControlWrapper lOControlWrapper2 : list) {
            int n2;
            if (!lOControlWrapper2.isSelected() || (n2 = lOControlWrapper2.getBottom()) < n) continue;
            lOControlWrapper = lOControlWrapper2;
            n = n2;
        }
        return lOControlWrapper;
    }

    private static LOControlWrapper findLeftmostControl(List<LOControlWrapper> list) {
        LOControlWrapper lOControlWrapper = null;
        int n = Integer.MAX_VALUE;
        for (LOControlWrapper lOControlWrapper2 : list) {
            int n2;
            if (!lOControlWrapper2.isSelected() || (n2 = lOControlWrapper2.getLeft()) > n) continue;
            lOControlWrapper = lOControlWrapper2;
            n = n2;
        }
        return lOControlWrapper;
    }

    private static LOControlWrapper findRightmostControl(List<LOControlWrapper> list) {
        LOControlWrapper lOControlWrapper = null;
        int n = Integer.MIN_VALUE;
        for (LOControlWrapper lOControlWrapper2 : list) {
            int n2;
            if (!lOControlWrapper2.isSelected() || (n2 = lOControlWrapper2.getRight()) < n) continue;
            lOControlWrapper = lOControlWrapper2;
            n = n2;
        }
        return lOControlWrapper;
    }

    private static void alignHorizontalGrid(List<LOControlWrapper> list) {
        int n = Prefs.getIntegerPref((String)"LayoutGridWidth");
        if (n > 1) {
            for (LOControlWrapper lOControlWrapper : list) {
                if (!lOControlWrapper.isSelected()) continue;
                int n2 = lOControlWrapper.getLeft() % n;
                lOControlWrapper.offsetRect(-n2, 0);
            }
        }
    }

    private static void alignVerticalGrid(List<LOControlWrapper> list) {
        int n = Prefs.getIntegerPref((String)"LayoutGridWidth");
        if (n > 1) {
            for (LOControlWrapper lOControlWrapper : list) {
                if (!lOControlWrapper.isSelected()) continue;
                int n2 = lOControlWrapper.getTop() % n;
                lOControlWrapper.offsetRect(0, -n2);
            }
        }
    }
}

