/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.mathworks.common.icons.ControlIcon;
import com.mathworks.hg.types.HGFontName;
import com.mathworks.hg.util.HGHelpers;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.icons.GuideIcon;
import com.mathworks.toolbox.matlab.guide.icons.MenuEditorIcon;
import com.mathworks.util.CategoricalVariable;
import javax.swing.Icon;

public enum HGControl {
    UNKNOWN("Unknown", "Unknown", "Unknown", "Unknown", ControlIcon.UNKNOWN.getIcon()),
    AXES("axes", "axes", "Axes", "matlab.graphics.axis.Axes", ControlIcon.AXES.getIcon()),
    FIGURE("figure", "figure", "Figure", "matlab.ui.Figure", ControlIcon.FIGURE.getIcon()),
    UICONTROL("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.UNKNOWN.getIcon()),
    PUSHBUTTON("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.PUSHBUTTON.getIcon()),
    SCROLLBAR("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.SCROLLBAR.getIcon()),
    RADIOBUTTON("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.RADIOBUTTON.getIcon()),
    CHECKBOX("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.CHECKBOX.getIcon()),
    TEXTEDIT("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.TEXTEDIT.getIcon()),
    LABEL("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.LABEL.getIcon()),
    FRAME("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.FRAME.getIcon()),
    COMBOBOX("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.COMBOBOX.getIcon()),
    LISTBOX("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.LISTBOX.getIcon()),
    TOGGLEBUTTON("uicontrol", "uicontrol", "StyleControl", "matlab.ui.control.StyleControl", ControlIcon.TOGGLEBUTTON.getIcon()),
    TABLE("uitable", "uitable", "Table", "matlab.ui.control.Table", ControlIcon.TABLE.getIcon()),
    CONTAINER("uicontainer", "uicontainer", "UIContainer", "matlab.ui.container.internal.UIContainer", ControlIcon.PANEL.getIcon()),
    PANEL("uipanel", "uipanel", "Panel", "matlab.ui.container.Panel", ControlIcon.PANEL.getIcon()),
    BUTTONGROUP("uitools.uibuttongroup", "uitools.uibuttongroup", "ButtonGroup", "matlab.ui.container.ButtonGroup", ControlIcon.BUTTONGROUP.getIcon()),
    MENU("uimenu", "uimenu", "Menu", "matlab.ui.container.Menu", MenuEditorIcon.NEW_MENU.getIcon()),
    SUBMENU("uimenu", "uimenu", "Menu", "matlab.ui.container.Menu", MenuEditorIcon.SUBMENU.getIcon()),
    MENUITEM("uimenu", "uimenu", "Menu", "matlab.ui.container.Menu", MenuEditorIcon.NEW_MENUITEM.getIcon()),
    CONTEXTMENU("uicontextmenu", "uicontextmenu", "ContextMenu", "matlab.ui.container.ContextMenu", MenuEditorIcon.NEW_CONTEXTMENU.getIcon()),
    TABGROUP("uitabgroup", "uitabgroup", "TabGroup", "matlab.ui.container.TabGroup", ControlIcon.UNKNOWN.getIcon()),
    TAB("uitab", "uitab", "Tab", "matlab.ui.container.Tab", ControlIcon.UNKNOWN.getIcon()),
    TOOLBAR("uitoolbar", "uitoolbar", "Toolbar", "matlab.ui.container.Toolbar", GuideIcon.TOOLBAR.getIcon()),
    PUSHTOOL("uipushtool", "uipushtool", "PushTool", "matlab.ui.container.toolbar.PushTool", GuideIcon.PUSHTOOL.getIcon()),
    TOGGLETOOL("uitoggletool", "uitoggletool", "ToggleTool", "matlab.ui.container.toolbar.ToggleTool", GuideIcon.TOGGLETOOL.getIcon());

    private static final boolean sIsHG2;
    private String fHG1ControlName;
    private String fHG1ClassName;
    private String fHG2ControlName;
    private String fHG2ClassName;
    private Icon fControlIcon;

    private HGControl(String string2, String string3, String string4, String string5, Icon icon) {
        this.fHG1ControlName = string2;
        this.fHG1ClassName = string3;
        this.fHG2ControlName = string4;
        this.fHG2ClassName = string5;
        this.fControlIcon = icon;
    }

    public String getControlName() {
        return sIsHG2 ? this.fHG2ControlName : this.fHG1ControlName;
    }

    public String getClassName() {
        return sIsHG2 ? this.fHG2ClassName : this.fHG1ClassName;
    }

    public Icon getControlIcon() {
        return this.fControlIcon;
    }

    public static HGControl getControlForUDDObject(String string, UDDObject uDDObject) {
        if (string.equals(UICONTROL.getClassName())) {
            return HGControl.getStyleControlForUDDObject(string, uDDObject);
        }
        if (string.equals(MENU.getClassName())) {
            if (FIGURE.getClassName().equals(uDDObject.browseableParent().toString())) {
                return MENU;
            }
            if (uDDObject.browseableHasChildren()) {
                return SUBMENU;
            }
            return MENUITEM;
        }
        for (HGControl hGControl : HGControl.values()) {
            if (!string.equals(hGControl.getClassName())) continue;
            return hGControl;
        }
        if (LayoutLooper.isAxes(uDDObject)) {
            return AXES;
        }
        if (LayoutLooper.isContainer(uDDObject)) {
            return CONTAINER;
        }
        return UNKNOWN;
    }

    private static HGControl getStyleControlForUDDObject(String string, UDDObject uDDObject) {
        Object object = HGControl.getPropertyValueForCompatibility(uDDObject, "Style");
        if (object != null && object instanceof Integer) {
            switch ((Integer)object) {
                case 0: {
                    return PUSHBUTTON;
                }
                case 1: {
                    return SCROLLBAR;
                }
                case 2: {
                    return RADIOBUTTON;
                }
                case 3: {
                    return CHECKBOX;
                }
                case 4: {
                    return TEXTEDIT;
                }
                case 5: {
                    return LABEL;
                }
                case 6: {
                    return FRAME;
                }
                case 7: {
                    return COMBOBOX;
                }
                case 8: {
                    return LISTBOX;
                }
                case 9: {
                    return TOGGLEBUTTON;
                }
            }
        }
        return UNKNOWN;
    }

    public static Icon getDisplayIconForControl(String string, UDDObject uDDObject) {
        return HGControl.getControlForUDDObject(string, uDDObject).getControlIcon();
    }

    public static String getDisplayTextForControl(String string, UDDObject uDDObject) {
        String string2 = string;
        HGControl hGControl = HGControl.getControlForUDDObject(string, uDDObject);
        if (!UNKNOWN.equals((Object)hGControl)) {
            String string3 = hGControl.getControlName();
            String string4 = null;
            try {
                switch (hGControl) {
                    case AXES: 
                    case CONTEXTMENU: 
                    case CONTAINER: 
                    case TABGROUP: 
                    case TABLE: 
                    case TOOLBAR: 
                    case UNKNOWN: {
                        string4 = HGControl.getStringProperty(uDDObject, "Tag");
                        break;
                    }
                    case BUTTONGROUP: 
                    case PANEL: {
                        String string5 = HGControl.getStringProperty(uDDObject, "Title");
                        string4 = HGControl.getStringProperty(uDDObject, "Tag");
                        if (string5.length() <= 0) break;
                        string4 = string4 + " \"" + string5 + '\"';
                        break;
                    }
                    case CHECKBOX: 
                    case COMBOBOX: 
                    case FRAME: 
                    case LABEL: 
                    case LISTBOX: 
                    case PUSHBUTTON: 
                    case RADIOBUTTON: 
                    case SCROLLBAR: 
                    case TEXTEDIT: 
                    case TOGGLEBUTTON: {
                        String string6 = HGControl.getStringProperty(uDDObject, "String");
                        string4 = HGControl.getStringProperty(uDDObject, "Tag");
                        if (string6.length() <= 0) break;
                        string4 = string4 + " \"" + string6 + '\"';
                        break;
                    }
                    case FIGURE: {
                        string4 = HGControl.getStringProperty(uDDObject, "Name");
                        break;
                    }
                    case MENU: 
                    case MENUITEM: 
                    case SUBMENU: {
                        string4 = HGControl.getStringProperty(uDDObject, "Label");
                        break;
                    }
                    case PUSHTOOL: 
                    case TOGGLETOOL: {
                        String string7 = HGControl.getStringProperty(uDDObject, "TooltipString");
                        string4 = HGControl.getStringProperty(uDDObject, "Tag");
                        if (string7.length() <= 0) break;
                        string4 = string4 + " \"" + string7 + '\"';
                        break;
                    }
                }
            }
            catch (Exception exception) {
                string4 = null;
            }
            string2 = string3;
            if (string4 != null && string4.length() > 0) {
                string2 = string2 + " (" + string4 + ')';
            }
        }
        return string2;
    }

    public static String getStringProperty(UDDObject uDDObject, String string) {
        Object object = HGControl.getPropertyValueForCompatibility(uDDObject, string);
        String string2 = "";
        if (object != null) {
            String[] stringArray;
            if (object instanceof String) {
                string2 = (String)object;
            } else if (object instanceof String[] && (stringArray = (String[])object).length > 0) {
                string2 = stringArray[0];
            }
        }
        return string2;
    }

    public static Object getPropertyValueForCompatibility(UDDObject uDDObject, String string) {
        Object object = uDDObject.getPropertyValue(string);
        if (sIsHG2) {
            if (object instanceof CategoricalVariable) {
                object = ((CategoricalVariable)object).getValue();
            } else if (object instanceof MLArrayRef) {
                MLArrayRef mLArrayRef = (MLArrayRef)object;
                if (mLArrayRef.isDouble()) {
                    object = mLArrayRef.getData();
                }
            } else if (object instanceof HGFontName) {
                object = ((HGFontName)object).getFontName();
            }
        }
        return object;
    }

    public static void setPropertyValueForCompatibility(UDDObject uDDObject, String string, Object object) {
        Object object2;
        if (sIsHG2 && object instanceof Integer && (object2 = uDDObject.getPropertyValue(string)) instanceof CategoricalVariable) {
            ((CategoricalVariable)object2).setValue(object);
            object = object2;
        }
        uDDObject.setPropertyValue(string, object);
    }

    static {
        sIsHG2 = HGHelpers.isHGUsingMATLABClasses();
    }
}

