/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.example.browser.Browser;
import com.sun.jini.example.browser.EntryTreePanel;
import com.sun.jini.outrigger.AdminIterator;
import com.sun.jini.outrigger.JavaSpaceAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.jini.core.entry.Entry;

class SpaceBrowser
extends JFrame {
    private static final int MINIMUM_WINDOW_WIDTH = 320;
    private Browser browser;
    private static final Entry[] emptyArray = new Entry[0];

    public SpaceBrowser(JavaSpaceAdmin javaSpaceAdmin, Browser browser) {
        super("SpaceBrowser");
        this.browser = browser;
        SpaceEntryPanel spaceEntryPanel = new SpaceEntryPanel(javaSpaceAdmin);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new BrowserMenuBar(spaceEntryPanel), "North");
        this.getContentPane().add((Component)spaceEntryPanel, "Center");
        this.validate();
        this.pack();
        this.setSize(this.getSize().width < 320 ? 320 : this.getSize().width, this.getSize().height);
        Rectangle rectangle = browser.getBounds();
        Dimension dimension = this.getPreferredSize();
        int n = rectangle.x + (rectangle.width - dimension.width) / 2;
        int n2 = rectangle.y + (rectangle.height - dimension.height) / 2;
        this.setLocation(n < 0 ? 0 : n, n2 < 0 ? 0 : n2);
    }

    class SpaceEntryPanel
    extends EntryTreePanel {
        private JavaSpaceAdmin admin;

        public SpaceEntryPanel(JavaSpaceAdmin javaSpaceAdmin) {
            super(false);
            this.admin = javaSpaceAdmin;
            this.refreshPanel();
        }

        protected Entry[] getEntryArray() {
            try {
                Entry entry;
                AdminIterator adminIterator = this.admin.contents(null, null, 128);
                LinkedList<Entry> linkedList = new LinkedList<Entry>();
                while ((entry = adminIterator.next()) != null) {
                    linkedList.add(entry);
                }
                adminIterator.close();
                return linkedList.toArray(emptyArray);
            }
            catch (Throwable throwable) {
                Browser.logger.log(Level.INFO, "obtaining entries failed", throwable);
                return null;
            }
        }
    }

    class BrowserMenuBar
    extends JMenuBar {
        private EntryTreePanel entryPanel;

        public BrowserMenuBar(EntryTreePanel entryTreePanel) {
            this.entryPanel = entryTreePanel;
            JMenu jMenu = this.add(new JMenu("File"));
            JMenuItem jMenuItem = jMenu.add(new JMenuItem("Refresh"));
            jMenuItem.addActionListener(SpaceBrowser.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserMenuBar.this.entryPanel.refreshPanel();
                }
            }));
            jMenuItem = jMenu.add(new JMenuItem("Close"));
            jMenuItem.addActionListener(SpaceBrowser.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SpaceBrowser.this.setVisible(false);
                }
            }));
        }
    }
}

