/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.ContentLoader;
import ice.storm.CurrentRecord;
import ice.storm.HistoryEntry;
import ice.storm.HistoryManager;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.Viewport;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class PseudoHistoryManager
implements HistoryManager {
    private final int OEAB = 50;
    private int addChild = 50;
    private int applySnapshot = 50;
    protected StormBase base;
    private Hashtable clear = new Hashtable();
    private Hashtable dispose = new Hashtable();
    private Hashtable do_getEntries = new Hashtable();
    private Hashtable elementAt = new Hashtable();
    private Hashtable elements = new Hashtable();
    private Hashtable equals = new Hashtable();
    private Hashtable findViewportByHistoryId = new Hashtable();

    public PseudoHistoryManager(StormBase stormBase) {
        this.base = stormBase;
    }

    public void setBackHistorySize(int n) {
        this.addChild = n;
    }

    public void setForwardHistorySize(int n) {
        this.applySnapshot = n;
    }

    public int getBackHistorySize() {
        return this.addChild;
    }

    public int getForwardHistorySize() {
        return this.applySnapshot;
    }

    public HistoryEntry[] do_getEntries(String string, Hashtable hashtable) {
        HistoryEntry[] historyEntryArray = null;
        Viewport viewport = this.base.findViewportByName(string);
        Stack stack = this.do_getEntries(viewport, hashtable);
        if (stack != null) {
            int n = stack.size();
            historyEntryArray = new HistoryEntry[n];
            int n2 = 0;
            while (n2 < n) {
                historyEntryArray[n2] = (PseudoViewport)stack.elementAt(n2);
                ++n2;
            }
        }
        return historyEntryArray;
    }

    public HistoryEntry[] getBackEntries(String string) {
        return this.do_getEntries(string, this.clear);
    }

    public HistoryEntry[] getForwardEntries(String string) {
        return this.do_getEntries(string, this.dispose);
    }

    private String[] OEAB(String string, Hashtable hashtable) {
        String[] stringArray = null;
        Viewport viewport = this.base.findViewportByName(string);
        Stack stack = this.do_getEntries(viewport, hashtable);
        if (stack != null) {
            int n = stack.size();
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = ((PseudoViewport)stack.elementAt((int)n2)).url;
                ++n2;
            }
        }
        return stringArray;
    }

    public String[] getForwardHistory(String string) {
        return this.OEAB(string, this.dispose);
    }

    public String[] getBackHistory(String string) {
        return this.OEAB(string, this.clear);
    }

    private HistoryEntry addChild(String string, String string2, int n, Hashtable hashtable) {
        PseudoViewport pseudoViewport = null;
        Viewport viewport = this.base.findViewportByName(string);
        String string3 = viewport.getHistoryId();
        Stack stack = this.do_getEntries(viewport, hashtable);
        if (stack != null) {
            int n2 = stack.size();
            n = Math.min(n, n2);
            pseudoViewport = new PseudoViewport(string3, string2);
            stack.insertElementAt(pseudoViewport, n);
        }
        return pseudoViewport;
    }

    public HistoryEntry addToBackHistory(String string, String string2, int n) {
        return this.addChild(string, string2, n, this.clear);
    }

    public HistoryEntry addToForwardHistory(String string, String string2, int n) {
        return this.addChild(string, string2, n, this.dispose);
    }

    public void clearAllHistories() {
        Stack stack;
        Enumeration enumeration = this.clear.elements();
        while (enumeration.hasMoreElements()) {
            stack = (Stack)enumeration.nextElement();
            this.applySnapshot(stack);
        }
        enumeration = this.dispose.elements();
        while (enumeration.hasMoreElements()) {
            stack = (Stack)enumeration.nextElement();
            this.applySnapshot(stack);
        }
        this.clear.clear();
        this.dispose.clear();
        this.findViewportByHistoryId.clear();
        this.elements.clear();
        this.equals.clear();
    }

    public void clearHistoryForViewport(Viewport viewport) {
        String string = viewport.getHistoryId();
        Stack stack = (Stack)this.clear.get(string);
        Stack stack2 = (Stack)this.dispose.get(string);
        this.applySnapshot(stack);
        this.applySnapshot(stack2);
        this.clear.remove(string);
        this.dispose.remove(string);
        this.do_getEntries.remove(string);
        this.elementAt.remove(viewport.getId());
        this.findViewportByHistoryId.remove(string);
        this.elements.remove(string);
        this.equals.remove(string);
    }

    /*
     * Unable to fully structure code
     */
    private void applySnapshot(Stack var1_1) {
        if (var1_1 != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (PseudoViewport)var1_1.pop();
            if (var2_2 == null) continue;
            var2_2.dispose();
lbl6:
            // 3 sources

            ** while (!var1_1.isEmpty())
        }
lbl7:
        // 1 sources

    }

    public String getCurrentLocation(String string) {
        CurrentRecord currentRecord = (CurrentRecord)this.elementAt.get(string);
        if (currentRecord == null) {
            return null;
        }
        return currentRecord.loc;
    }

    private byte[] base(String string) {
        CurrentRecord currentRecord = (CurrentRecord)this.elementAt.get(string);
        if (currentRecord == null) {
            return null;
        }
        return currentRecord.postData;
    }

    public void reload(String string) {
        Viewport viewport = this.base.findViewportByName(string);
        PseudoViewport pseudoViewport = (PseudoViewport)this.do_getEntries.get(viewport.getHistoryId());
        if (pseudoViewport == null) {
            return;
        }
        this.equals(pseudoViewport);
        this.get(pseudoViewport);
        this.elements(pseudoViewport);
    }

    private boolean clear(String string, String string2) {
        Viewport viewport;
        Viewport viewport2 = null;
        Viewport viewport3 = viewport = this.base.findViewportByHistoryId(string);
        boolean bl = true;
        while (viewport3.getParent() != null) {
            viewport3 = viewport3.getParent();
            if (bl) {
                viewport2 = viewport3;
            }
            bl = false;
        }
        PseudoViewport pseudoViewport = new PseudoViewport(string, string2);
        byte[] byArray = this.base(viewport.getId());
        String string3 = this.getCurrentLocation(viewport.getId());
        if (string3 != null && string3.equals(string2) && this.base(viewport.getId()) != null && byArray == null) {
            return false;
        }
        if (byArray != null) {
            pseudoViewport.postData = byArray;
        }
        if (bl) {
            this.do_getEntries.put(string, pseudoViewport);
        } else {
            PseudoViewport pseudoViewport2;
            PseudoViewport pseudoViewport3;
            PseudoViewport pseudoViewport4 = this.dispose(viewport3.getHistoryId());
            if (pseudoViewport4 == null) {
                this.clear(viewport3.getHistoryId(), this.getCurrentLocation(viewport3.getId()));
                pseudoViewport4 = this.dispose(viewport3.getHistoryId());
            }
            if ((pseudoViewport3 = this.getLocation(pseudoViewport4, viewport2.getHistoryId(), true)) == null) {
                this.clear(viewport2.getHistoryId(), this.getCurrentLocation(viewport2.getId()));
                pseudoViewport3 = this.getLocation(pseudoViewport4, viewport2.getHistoryId(), true);
            }
            if ((pseudoViewport2 = this.getLocation(pseudoViewport3, string, true)) != null) {
                PseudoViewport pseudoViewport5 = this.getCurrentLocation(pseudoViewport4);
                pseudoViewport3 = this.getLocation(pseudoViewport5, viewport2.getHistoryId(), true);
                pseudoViewport2 = this.getLocation(pseudoViewport3, string, true);
                this.getId(pseudoViewport3, pseudoViewport2, pseudoViewport);
                this.do_getEntries.put(viewport3.getHistoryId(), pseudoViewport5);
            } else {
                this.getHistoryId(pseudoViewport3, pseudoViewport);
            }
        }
        return true;
    }

    private PseudoViewport dispose(String string) {
        Viewport viewport = this.base.findViewportByHistoryId(string);
        if (viewport == null) {
            return null;
        }
        PseudoViewport pseudoViewport = (PseudoViewport)this.do_getEntries.get(string);
        if (pseudoViewport == null) {
            while (viewport.getParent() != null) {
                viewport = viewport.getParent();
            }
            pseudoViewport = (PseudoViewport)this.do_getEntries.get(viewport.getHistoryId());
        }
        return pseudoViewport;
    }

    /*
     * Unable to fully structure code
     */
    private Stack do_getEntries(Viewport var1_1, Hashtable var2_2) {
        if (var1_1 != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getParent();
lbl4:
            // 2 sources

            ** while (var1_1.getParent() != null)
        }
lbl5:
        // 1 sources

        var3_3 = var1_1.getHistoryId();
        var4_4 = (Stack<E>)var2_2.get(var3_3);
        if (var4_4 == null) {
            var4_4 = new Stack<E>();
            var2_2.put(var3_3, var4_4);
        } else {
            v0 = var5_5 = var2_2 == this.clear ? this.addChild : this.applySnapshot;
            if (var4_4.size() > var5_5) {
                var6_6 = (PseudoViewport)var4_4.elementAt(0);
                if (var6_6 != null) {
                    var6_6.dispose();
                }
                var4_4.removeElementAt(0);
            }
        }
        return var4_4;
    }

    public void goBack(String string, int n) {
        this.elementAt(string, this.clear, this.dispose, n);
    }

    public void goBack(String string) {
        this.goBack(string, 1);
    }

    private void elementAt(String string, Hashtable hashtable, Hashtable hashtable2, int n) {
        Viewport viewport = this.base.findViewportByName(string);
        Stack stack = this.do_getEntries(viewport, hashtable);
        if (stack == null) {
            return;
        }
        PseudoViewport pseudoViewport = this.dispose(viewport.getHistoryId());
        int n2 = 0;
        while (n2 < n && !stack.isEmpty()) {
            PseudoViewport pseudoViewport2 = pseudoViewport;
            pseudoViewport = (PseudoViewport)stack.pop();
            if ((pseudoViewport = this.findViewportByHistoryId(pseudoViewport)) == null) {
                return;
            }
            if (pseudoViewport2 != null) {
                this.do_getEntries(viewport, hashtable2).push(pseudoViewport2);
            }
            ++n2;
        }
        if (n2 > 0) {
            this.findViewportByName(pseudoViewport);
        }
    }

    public void goForward(String string) {
        this.goForward(string, 1);
    }

    public void goForward(String string, int n) {
        this.elementAt(string, this.dispose, this.clear, n);
    }

    public void goingSomewhere(ContentLoader contentLoader, String string) {
        if (contentLoader.getRedirected()) {
            return;
        }
        String string2 = contentLoader.getLocation();
        if (string2 == null) {
            return;
        }
        String string3 = this.getCurrentLocation(string);
        this.elementAt.put(string, new CurrentRecord(string2, contentLoader.getPostData()));
        Viewport viewport = this.base.findViewportByName(string);
        String string4 = viewport.getHistoryId();
        PseudoViewport pseudoViewport = this.dispose(string4);
        if (!this.clear(string4, string2)) {
            return;
        }
        String string5 = (String)this.findViewportByHistoryId.get(string);
        if (string5 == null || !string5.equals(string2)) {
            if (string3 != null) {
                boolean bl = false;
                if (string3.equals(string2) && contentLoader.getPostData() == pseudoViewport.postData) {
                    bl = true;
                }
                if (!bl) {
                    this.do_getEntries(viewport, this.clear).push(pseudoViewport);
                    Enumeration enumeration = this.dispose.elements();
                    while (enumeration.hasMoreElements()) {
                        Stack stack = (Stack)enumeration.nextElement();
                        while (!stack.isEmpty()) {
                            PseudoViewport pseudoViewport2 = (PseudoViewport)stack.pop();
                            pseudoViewport2.dispose();
                        }
                    }
                    this.dispose.clear();
                }
            }
            this.findViewportByHistoryId.clear();
        }
        this.base.sendViewportMessage(viewport, "history", null, "modified");
    }

    public boolean canGoBack(String string) {
        Stack stack = this.do_getEntries(this.base.findViewportByName(string), this.clear);
        if (stack == null) {
            return false;
        }
        return !stack.isEmpty();
    }

    public boolean canGoForward(String string) {
        Stack stack = this.do_getEntries(this.base.findViewportByName(string), this.dispose);
        if (stack == null) {
            return false;
        }
        return !stack.isEmpty();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Viewport viewport = (Viewport)propertyChangeEvent.getSource();
        Pilot pilot = viewport.getPilot();
        if (pilot == null) {
            return;
        }
        String string2 = viewport.getId();
        String string3 = viewport.getHistoryId();
        String string4 = propertyChangeEvent.getPropertyName();
        String string5 = this.getCurrentLocation(string2);
        String string6 = string = propertyChangeEvent.getNewValue() instanceof String ? (String)propertyChangeEvent.getNewValue() : "";
        if (string4.startsWith("vi") && string.startsWith("ch")) {
            PseudoViewport pseudoViewport = (PseudoViewport)this.elements.get(string3);
            if (pseudoViewport != null) {
                this.first(pseudoViewport);
                this.elements.remove(string3);
            }
        } else if (string4.equals("contentLoading")) {
            PseudoViewport pseudoViewport;
            if (string.equals("request")) {
                if (string5 == null) {
                    return;
                }
                PseudoViewport pseudoViewport2 = this.dispose(string3);
                ContentLoader contentLoader = (ContentLoader)propertyChangeEvent.getOldValue();
                if (contentLoader == null) {
                    return;
                }
                if (string5.equals(contentLoader.getLocation())) {
                    return;
                }
                if (pseudoViewport2 != null) {
                    this.equals(pseudoViewport2);
                }
            } else if (string.equals("end") && (pseudoViewport = (PseudoViewport)this.equals.get(string3)) != null) {
                this.elements(pseudoViewport);
                this.equals.remove(string3);
            }
        }
    }

    private boolean elements(PseudoViewport pseudoViewport) {
        Viewport viewport;
        boolean bl = false;
        PseudoViewport pseudoViewport2 = pseudoViewport.first;
        while (pseudoViewport2 != null) {
            bl |= this.elements(pseudoViewport2);
            pseudoViewport2 = pseudoViewport2.next;
        }
        if (!bl && (viewport = this.base.findViewportByHistoryId(pseudoViewport.historyId)) != null) {
            bl = true;
            viewport.getPilot().applySnapshot(pseudoViewport.snapshot);
        }
        return bl;
    }

    private void equals(PseudoViewport pseudoViewport) {
        Viewport viewport = this.base.findViewportByHistoryId(pseudoViewport.historyId);
        if (viewport == null) {
            return;
        }
        Pilot pilot = viewport.getPilot();
        if (pilot == null) {
            return;
        }
        Object object = pilot.getSnapshot();
        if (object != null) {
            pseudoViewport.snapshot = object;
        }
        PseudoViewport pseudoViewport2 = pseudoViewport.first;
        while (pseudoViewport2 != null) {
            this.equals(pseudoViewport2);
            pseudoViewport2 = pseudoViewport2.next;
        }
    }

    private PseudoViewport findViewportByHistoryId(PseudoViewport pseudoViewport) {
        if (pseudoViewport == null) {
            return null;
        }
        PseudoViewport pseudoViewport2 = null;
        Viewport viewport = this.base.findViewportByHistoryId(pseudoViewport.historyId);
        if (viewport != null) {
            String string = this.getCurrentLocation(viewport.getId());
            if (string != null && string.equals(pseudoViewport.url)) {
                if (this.base(viewport.getId()) != pseudoViewport.postData) {
                    return pseudoViewport;
                }
                PseudoViewport pseudoViewport3 = pseudoViewport.first;
                while (pseudoViewport3 != null) {
                    pseudoViewport2 = this.findViewportByHistoryId(pseudoViewport3);
                    if (pseudoViewport2 == null) {
                        pseudoViewport3 = pseudoViewport3.next;
                        continue;
                    }
                    break;
                }
            } else {
                pseudoViewport2 = pseudoViewport;
            }
        }
        return pseudoViewport2;
    }

    private void findViewportByName(PseudoViewport pseudoViewport) {
        Viewport viewport = this.base.findViewportByHistoryId(pseudoViewport.historyId);
        if (viewport != null) {
            boolean bl;
            if (pseudoViewport.snapshot != null) {
                this.equals.put(pseudoViewport.historyId, pseudoViewport);
            }
            this.findViewportByHistoryId.put(viewport.getId(), pseudoViewport.url);
            String string = this.getCurrentLocation(viewport.getId());
            boolean bl2 = bl = string != null && string.equals(pseudoViewport.url) && this.base(viewport.getId()) == pseudoViewport.postData;
            if (pseudoViewport.first != null) {
                if (bl) {
                    this.first(pseudoViewport);
                    return;
                }
                this.elements.put(pseudoViewport.historyId, pseudoViewport);
            }
            if (!bl) {
                ContentLoader contentLoader = new ContentLoader(pseudoViewport.url, pseudoViewport.first != null);
                if (pseudoViewport.postData != null) {
                    contentLoader.setPostData(null, pseudoViewport.postData);
                }
                this.base.renderContent(contentLoader, viewport.getId());
            }
        }
    }

    private void first(PseudoViewport pseudoViewport) {
        PseudoViewport pseudoViewport2 = pseudoViewport.first;
        while (pseudoViewport2 != null) {
            this.findViewportByName(pseudoViewport2);
            pseudoViewport2 = pseudoViewport2.next;
        }
        this.elements.remove(pseudoViewport.historyId);
    }

    private boolean get(PseudoViewport pseudoViewport) {
        Viewport viewport;
        boolean bl = false;
        PseudoViewport pseudoViewport2 = pseudoViewport.first;
        while (pseudoViewport2 != null) {
            bl |= this.get(pseudoViewport2);
            pseudoViewport2 = pseudoViewport2.next;
        }
        if (!bl && (viewport = this.base.findViewportByHistoryId(pseudoViewport.historyId)) != null) {
            bl = true;
            this.findViewportByHistoryId.put(viewport.getId(), pseudoViewport.url);
            this.base.renderContent(pseudoViewport.url, null, viewport.getId());
        }
        return bl;
    }

    private PseudoViewport getCurrentLocation(PseudoViewport pseudoViewport) {
        PseudoViewport pseudoViewport2 = new PseudoViewport(pseudoViewport.historyId, pseudoViewport.url);
        PseudoViewport pseudoViewport3 = pseudoViewport.first;
        while (pseudoViewport3 != null) {
            this.getHistoryId(pseudoViewport2, this.getCurrentLocation(pseudoViewport3));
            pseudoViewport3 = pseudoViewport3.next;
        }
        return pseudoViewport2;
    }

    private void getHistoryId(PseudoViewport pseudoViewport, PseudoViewport pseudoViewport2) {
        if (pseudoViewport == null || pseudoViewport2 == null) {
            return;
        }
        PseudoViewport pseudoViewport3 = this.getLocation(pseudoViewport, pseudoViewport2.historyId, false);
        if (pseudoViewport3 != null) {
            this.getId(pseudoViewport, pseudoViewport3, pseudoViewport2);
            return;
        }
        pseudoViewport.addChild(pseudoViewport2);
    }

    private void getId(PseudoViewport pseudoViewport, PseudoViewport pseudoViewport2, PseudoViewport pseudoViewport3) {
        pseudoViewport.replaceChild(pseudoViewport2, pseudoViewport3);
        if (pseudoViewport2 != null) {
            pseudoViewport2.dispose();
        }
    }

    private PseudoViewport getLocation(PseudoViewport pseudoViewport, String string, boolean bl) {
        PseudoViewport pseudoViewport2 = null;
        if (pseudoViewport == null) {
            return null;
        }
        if (string.equals(pseudoViewport.historyId)) {
            pseudoViewport2 = pseudoViewport;
        } else {
            PseudoViewport pseudoViewport3 = pseudoViewport.first;
            while (pseudoViewport3 != null) {
                if (bl) {
                    pseudoViewport2 = this.getLocation(pseudoViewport3, string, true);
                    if (pseudoViewport2 != null) {
                        break;
                    }
                } else if (string.equals(pseudoViewport3.historyId)) {
                    pseudoViewport2 = pseudoViewport3;
                    break;
                }
                pseudoViewport3 = pseudoViewport3.next;
            }
        }
        return pseudoViewport2;
    }

    private static class PseudoViewport
    implements HistoryEntry {
        String historyId;
        String url;
        Object snapshot;
        byte[] postData;
        PseudoViewport first;
        PseudoViewport parent;
        PseudoViewport last;
        PseudoViewport next;

        PseudoViewport(String string, String string2) {
            this.url = string2;
            this.historyId = string;
        }

        public String getURL() {
            return this.url;
        }

        public void setURL(String string) {
            this.url = string;
        }

        public void setPostData(byte[] byArray) {
            this.postData = byArray;
        }

        void dispose() {
            PseudoViewport pseudoViewport = this.first;
            while (pseudoViewport != null) {
                pseudoViewport.dispose();
                pseudoViewport = pseudoViewport.next;
            }
            this.snapshot = null;
            this.postData = null;
            this.parent = null;
            this.next = null;
            this.first = null;
            this.last = null;
            this.url = null;
        }

        void replaceChild(PseudoViewport pseudoViewport, PseudoViewport pseudoViewport2) {
            if (pseudoViewport == null || pseudoViewport2 == null || this.first == null) {
                return;
            }
            pseudoViewport2.parent = this;
            if (this.first == pseudoViewport) {
                pseudoViewport2.next = pseudoViewport.next;
                this.first = pseudoViewport2;
            } else {
                PseudoViewport pseudoViewport3 = this.first;
                PseudoViewport pseudoViewport4 = pseudoViewport3.next;
                while (pseudoViewport4 != null) {
                    if (pseudoViewport == pseudoViewport4) {
                        pseudoViewport2.next = pseudoViewport.next;
                        pseudoViewport3.next = pseudoViewport2;
                        break;
                    }
                    pseudoViewport3 = pseudoViewport4;
                    pseudoViewport4 = pseudoViewport3.next;
                }
            }
            if (this.last == pseudoViewport) {
                this.last = pseudoViewport2;
            }
        }

        void addChild(PseudoViewport pseudoViewport) {
            pseudoViewport.parent = this;
            if (this.first == null) {
                pseudoViewport.next = null;
                this.first = this.last = pseudoViewport;
            } else {
                pseudoViewport.next = null;
                this.last.next = pseudoViewport;
                this.last = pseudoViewport;
            }
        }

        public String toString() {
            String string = super.toString() + " " + this.historyId + " " + this.url;
            return string;
        }
    }
}

