/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected ObjArray loops;
    protected ObjArray loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    public NodeTransformer newInstance() {
        return new NodeTransformer();
    }

    public IRFactory createIRFactory(TokenStream tokenStream, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    public Node transform(Node node, Node node2, TokenStream tokenStream, Scriptable scriptable) {
        Node node3;
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        boolean bl = this.inFunction = node.getType() == 110;
        if (!this.inFunction) {
            this.addVariables(node, this.getVariableTable(node));
        }
        this.irFactory = this.createIRFactory(tokenStream, scriptable);
        boolean bl2 = false;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        block22: while ((node3 = preorderNodeIterator.nextNode()) != null) {
            int n = node3.getType();
            block0 : switch (n) {
                case 110: {
                    if (node3 == node) {
                        VariableTable variableTable = this.getVariableTable(node);
                        this.addVariables(node, variableTable);
                        Node node4 = node3.getLastChild();
                        Node node5 = node4.getLastChild();
                        if (node5 != null && node5.getType() == 5) continue block22;
                        node4.addChildToBack(new Node(5));
                        break;
                    }
                    FunctionNode functionNode = (FunctionNode)node3.getProp(5);
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                        functionNode.setCheckThis(true);
                    }
                    this.addParameters(functionNode);
                    NodeTransformer nodeTransformer = this.newInstance();
                    functionNode = (FunctionNode)nodeTransformer.transform(functionNode, node, tokenStream, scriptable);
                    node3.putProp(5, functionNode);
                    ObjArray objArray = (ObjArray)node.getProp(5);
                    if (objArray == null) {
                        objArray = new ObjArray();
                        node.putProp(5, objArray);
                    }
                    objArray.add(functionNode);
                    break;
                }
                case 136: {
                    Object object3;
                    Object object2;
                    Node node6;
                    Node node7 = node3.getFirstChild();
                    node3.removeChild(node7);
                    String string = node7.getString();
                    int n2 = this.loops.size() - 1;
                    while (n2 >= 0) {
                        node6 = (Node)this.loops.get(n2);
                        if (node6.getType() == 136 && string.equals(object2 = (String)node6.getProp(20))) {
                            object3 = Context.getMessage1("msg.dup.label", string);
                            this.reportMessage(Context.getContext(), (String)object3, node3, node, true, scriptable);
                            break block0;
                        }
                        --n2;
                    }
                    node3.putProp(20, string);
                    node6 = new Node(137);
                    object2 = preorderNodeIterator.getCurrentParent();
                    object3 = node3.getNext();
                    while (object3 != null && (((Node)object3).getType() == 136 || ((Node)object3).getType() == 137)) {
                        object3 = ((Node)object3).getNext();
                    }
                    if (object3 == null) continue block22;
                    ((Node)object2).addChildAfter(node6, (Node)object3);
                    node3.putProp(2, node6);
                    if (((Node)object3).getType() == 138) {
                        node3.putProp(3, ((Node)object3).getProp(3));
                    }
                    this.loops.push(node3);
                    this.loopEnds.push(node6);
                    break;
                }
                case 115: {
                    Node node8 = new Node(137);
                    Node node9 = preorderNodeIterator.getCurrentParent();
                    node9.addChildAfter(node8, node3);
                    Node node10 = node3;
                    Node node11 = node3.getFirstChild().next;
                    while (node11 != null) {
                        Node node12 = node11.next;
                        node3.removeChild(node11);
                        node9.addChildAfter(node11, node10);
                        node10 = node11;
                        node11 = node12;
                    }
                    node3.putProp(2, node8);
                    this.loops.push(node3);
                    this.loopEnds.push(node8);
                    node3.putProp(13, new ObjArray());
                    break;
                }
                case 116: 
                case 117: {
                    Node node13 = (Node)this.loops.peek();
                    if (n == 116) {
                        ObjArray objArray = (ObjArray)node13.getProp(13);
                        objArray.add(node3);
                        break;
                    }
                    node13.putProp(14, node3);
                    break;
                }
                case 144: {
                    int n3 = node.getIntProp(22, 0);
                    node.putIntProp(22, n3 + 1);
                    break;
                }
                case 138: {
                    this.loops.push(node3);
                    this.loopEnds.push(node3.getProp(2));
                    break;
                }
                case 124: {
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    this.loops.push(node3);
                    Node node14 = node3.getNext();
                    if (node14.getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(node14);
                    break;
                }
                case 75: {
                    Node node15 = (Node)node3.getProp(21);
                    if (node15 != null) {
                        bl2 = true;
                        this.loops.push(node3);
                        this.loopEnds.push(node15);
                    }
                    int n4 = node.getIntProp(22, 0);
                    node.putIntProp(22, n4 + 1);
                    break;
                }
                case 4: 
                case 137: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node3) continue block22;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    if (!bl2) continue block22;
                    int n5 = this.loops.size() - 1;
                    while (n5 >= 0) {
                        Node node16;
                        Node node17 = (Node)this.loops.get(n5);
                        int n6 = node17.getType();
                        if (n6 == 75) {
                            node16 = new Node(143);
                            Object object = node17.getProp(21);
                            node16.putProp(1, object);
                            preorderNodeIterator.addBeforeCurrent(node16);
                        } else if (n6 == 124) {
                            node16 = new Node(4);
                            preorderNodeIterator.addBeforeCurrent(node16);
                        }
                        --n5;
                    }
                    continue block22;
                }
                case 121: 
                case 122: {
                    Object[] objectArray;
                    Object object;
                    Object object3;
                    Node node18 = null;
                    boolean bl3 = node3.hasChildren();
                    String string = null;
                    if (bl3) {
                        Node node19 = node3.getFirstChild();
                        string = node19.getString();
                        node3.removeChild(node19);
                    }
                    int n7 = this.loops.size() - 1;
                    while (n7 >= 0) {
                        Node node20 = (Node)this.loops.get(n7);
                        int n8 = node20.getType();
                        if (n8 == 124) {
                            object = new Node(4);
                            preorderNodeIterator.addBeforeCurrent((Node)object);
                        } else if (n8 == 75) {
                            object = new Node(143);
                            objectArray = node20.getProp(21);
                            ((Node)object).putProp(1, objectArray);
                            preorderNodeIterator.addBeforeCurrent((Node)object);
                        } else {
                            if (!bl3 && (n8 == 138 || n8 == 115 && n == 121)) {
                                node18 = node20;
                                break;
                            }
                            if (bl3 && n8 == 136 && string.equals((String)node20.getProp(20))) {
                                node18 = node20;
                                break;
                            }
                        }
                        --n7;
                    }
                    int n9 = n == 121 ? 2 : 3;
                    Object object4 = object3 = node18 == null ? null : (Node)node18.getProp(n9);
                    if (node18 == null || object3 == null) {
                        if (!bl3) {
                            object = n == 122 ? Context.getMessage("msg.continue.outside", null) : Context.getMessage("msg.bad.break", null);
                        } else if (node18 != null) {
                            object = Context.getMessage0("msg.continue.nonloop");
                        } else {
                            objectArray = new Object[]{string};
                            object = Context.getMessage("msg.undef.label", objectArray);
                        }
                        this.reportMessage(Context.getContext(), (String)object, node3, node, true, scriptable);
                        node3.setType(128);
                        break;
                    }
                    node3.setType(6);
                    node3.putProp(1, object3);
                    break;
                }
                case 43: {
                    if (this.OEAB(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitCall(node3, node);
                    break;
                }
                case 30: {
                    if (this.OEAB(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitNew(node3, node);
                    break;
                }
                case 108: {
                    Node node21 = node3.getLastChild();
                    node21.setType(46);
                    break;
                }
                case 140: {
                    node3.setType(this.inFunction ? 57 : 2);
                    break;
                }
                case 56: {
                    ObjArray objArray = (ObjArray)node.getProp(12);
                    if (objArray == null) {
                        objArray = new ObjArray();
                        node.putProp(12, objArray);
                    }
                    objArray.add(node3);
                    Node node22 = new Node(56);
                    preorderNodeIterator.replaceCurrent(node22);
                    node22.putProp(12, node3);
                    break;
                }
                case 123: {
                    Object object3;
                    Node node23 = new Node(133);
                    Node node24 = node3.getFirstChild();
                    while (node24 != null) {
                        Node node25 = node24;
                        node24 = node24.getNext();
                        if (!node25.hasChildren()) continue;
                        Node node26 = node25.getFirstChild();
                        node25.removeChild(node26);
                        Node node27 = (Node)this.irFactory.createAssignment(128, node25, node26, null, false);
                        object3 = new Node(57, node27, node3.getLineno());
                        node23.addChildToBack((Node)object3);
                    }
                    preorderNodeIterator.replaceCurrent(node23);
                    break;
                }
                case 10: 
                case 31: {
                    VariableTable variableTable;
                    Node node28;
                    if (!this.inFunction || this.inWithStatement() || (node28 = node3.getFirstChild()) == null || node28.getType() != 61) continue block22;
                    String string = node28.getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded(string)) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if (!(variableTable = this.getVariableTable(node)).hasVariable(string)) break;
                    if (n == 10) {
                        node3.setType(73);
                        node28.setType(46);
                        break;
                    }
                    Node node29 = new Node(109, 51);
                    preorderNodeIterator.replaceCurrent(node29);
                    break;
                }
                case 39: {
                    if (!this.inFunction) break;
                    Node node30 = node3.getFirstChild().getNext();
                    String string = node30 == null ? "" : node30.getString();
                    Context context = Context.getCurrentContext();
                    if ((context == null || !context.isActivationNeeded(string)) && (!string.equals("length") || Context.getContext().getLanguageVersion() != 120)) continue block22;
                    ((FunctionNode)node).setRequiresActivation(true);
                    break;
                }
                case 44: {
                    VariableTable variableTable;
                    if (!this.inFunction || this.inWithStatement()) continue block22;
                    String string = node3.getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded(string)) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if (!(variableTable = this.getVariableTable(node)).hasVariable(string)) break;
                    node3.setType(72);
                    break;
                }
            }
        }
        return node;
    }

    protected void addVariables(Node node, VariableTable variableTable) {
        Object object;
        Object object2;
        Node node2;
        boolean bl = node.getType() == 110;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        ObjToIntMap objToIntMap = null;
        while ((node2 = preorderNodeIterator.nextNode()) != null) {
            int n = node2.getType();
            if (bl && n == 110 && node2 != node && ((FunctionNode)node2.getProp(5)).getFunctionType() == 3) {
                object2 = node2.getString();
                if (object2 == null) continue;
                variableTable.removeLocal((String)object2);
                if (objToIntMap == null) {
                    objToIntMap = new ObjToIntMap();
                }
                objToIntMap.put(object2, 0);
            }
            if (n != 123) continue;
            object2 = node2.getFirstChild();
            while (object2 != null) {
                object = ((Node)object2).getString();
                if (objToIntMap == null || !objToIntMap.has(object)) {
                    variableTable.addLocal((String)object, this.createVariableObject((String)object, false));
                }
                object2 = ((Node)object2).getNext();
            }
        }
        if (bl) {
            FunctionNode functionNode = (FunctionNode)node;
            object2 = functionNode.getFunctionName();
            if (functionNode.getFunctionType() == 2 && object2 != null && ((String)object2).length() > 0 && variableTable.hasVariable((String)object2)) {
                variableTable.addLocal((String)object2, this.createVariableObject((String)object2, false));
                object = node.getLastChild();
                Node node3 = new Node(57, new Node(73, Node.newString((String)object2), new Node(109, 87)));
                ((Node)object).addChildrenToFront(node3);
            }
        }
    }

    protected void addParameters(FunctionNode functionNode) {
        VariableTable variableTable = functionNode.getVariableTable();
        Node node = functionNode.getFirstChild();
        if (node.getType() == 94 && variableTable.getParameterCount() == 0) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                String string = node2.getString();
                variableTable.addParameter(string, this.createVariableObject(string, true));
                node2 = node2.getNext();
            }
        }
    }

    protected Object createVariableObject(String string, boolean bl) {
        return string;
    }

    protected void visitNew(Node node, Node node2) {
    }

    protected void visitCall(Node node, Node node2) {
        Node node3;
        Object object;
        Object object2;
        Node node4 = node.getFirstChild();
        int n = 0;
        Node node5 = node4.getNext();
        while (node5 != null) {
            node5 = node5.getNext();
            ++n;
        }
        boolean bl = false;
        if (node4.getType() == 44) {
            object2 = this.getVariableTable(node2);
            object = node4.getString();
            if (this.inFunction && ((VariableTable)object2).hasVariable((String)object) && !this.inWithStatement()) {
                node4.setType(72);
            } else {
                node.removeChild(node4);
                node4.setType(71);
                node3 = node4.cloneNode();
                node3.setType(46);
                Node node6 = new Node(39, node4, node3);
                node.addChildToFront(node6);
                node4 = node6;
                boolean bl2 = bl = this.inWithStatement() || !this.inFunction;
            }
        }
        if (node4.getType() != 39 && node4.getType() != 41) {
            node.removeChild(node4);
            object2 = this.irFactory.createNewTemp(node4);
            object = this.irFactory.createUseTemp((Node)object2);
            ((Node)object).putProp(6, object2);
            node3 = new Node(141, (Node)object);
            node.addChildToFront(node3);
            node.addChildToFront((Node)object2);
            return;
        }
        object2 = node4.getFirstChild();
        node4.removeChild((Node)object2);
        object = this.irFactory.createNewTemp((Node)object2);
        node4.addChildToFront((Node)object);
        node3 = this.irFactory.createUseTemp((Node)object);
        node3.putProp(6, object);
        if (bl) {
            node3 = new Node(68, node3);
        }
        node.addChildAfter(node3, node4);
    }

    protected boolean inWithStatement() {
        int n = this.loops.size() - 1;
        while (n >= 0) {
            Node node = (Node)this.loops.get(n);
            if (node.getType() == 124) {
                return true;
            }
            --n;
        }
        return false;
    }

    private boolean OEAB(Node node, Node node2) {
        Node node3 = node2.getFirstChild();
        boolean bl = false;
        if (node3.getType() == 44) {
            String string = node3.getString();
            bl = string.equals("eval") || string.equals("With");
        } else if (node3.getType() == 39) {
            String string = node3.getLastChild().getString();
            bl = string.equals("exec");
        }
        if (bl) {
            if (this.inFunction) {
                ((FunctionNode)node).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    protected VariableTable createVariableTable() {
        return new VariableTable();
    }

    protected VariableTable getVariableTable(Node node) {
        if (this.inFunction) {
            return ((FunctionNode)node).getVariableTable();
        }
        VariableTable variableTable = (VariableTable)node.getProp(10);
        if (variableTable == null) {
            variableTable = this.createVariableTable();
            node.putProp(10, variableTable);
        }
        return variableTable;
    }

    protected void reportMessage(Context context, String string, Node node, Node node2, boolean bl, Scriptable scriptable) {
        Object object;
        int n = node.getLineno();
        Object object2 = object = node2 == null ? null : node2.getProp(16);
        if (bl) {
            if (scriptable != null) {
                throw NativeGlobal.constructError(context, "SyntaxError", string, scriptable, (String)object, n, 0, null);
            }
            Context.reportError(string, (String)object, n, null, 0);
        } else {
            Context.reportWarning(string, (String)object, n, null, 0);
        }
    }
}

