/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeString
extends IdScriptable {
    private String string;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeString nativeString = new NativeString("");
        nativeString.prototypeFlag = true;
        nativeString.addAsPrototype(33, context, scriptable, bl);
    }

    private NativeString(String string) {
        this.setMaxId(1);
        this.string = string;
    }

    public String getClassName() {
        return "String";
    }

    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
        this.addIdFunctionProperty(idFunction, -1, bl);
        super.fillConstructorProperties(context, idFunction, bl);
    }

    protected int getIdDefaultAttributes(int n) {
        if (n == 1) {
            return 7;
        }
        return super.getIdDefaultAttributes(n);
    }

    protected Object getIdValue(int n) {
        if (n == 1) {
            return this.wrap_int(this.string.length());
        }
        return super.getIdValue(n);
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case -1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 2;
                }
                case 10: {
                    return 2;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    return 0;
                }
                case 13: {
                    return 2;
                }
                case 14: {
                    return 1;
                }
                case 15: {
                    return 2;
                }
                case 16: {
                    return 0;
                }
                case 17: {
                    return 0;
                }
                case 18: {
                    return 0;
                }
                case 19: {
                    return 0;
                }
                case 20: {
                    return 0;
                }
                case 21: {
                    return 0;
                }
                case 22: {
                    return 0;
                }
                case 23: {
                    return 0;
                }
                case 24: {
                    return 0;
                }
                case 25: {
                    return 0;
                }
                case 26: {
                    return 0;
                }
                case 27: {
                    return 0;
                }
                case 28: {
                    return 0;
                }
                case 29: {
                    return 1;
                }
                case 30: {
                    return 1;
                }
                case 31: {
                    return 1;
                }
                case 32: {
                    return 1;
                }
                case 33: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case -1: {
                    return NativeString.addAsPrototype(objectArray);
                }
                case 2: {
                    return NativeString.jsConstructor(objectArray, scriptable2 == null);
                }
                case 3: {
                    return this.D(scriptable2, idFunction).addIdFunctionProperty();
                }
                case 4: {
                    return this.D(scriptable2, idFunction).append();
                }
                case 5: {
                    return NativeString.charAt(ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 6: {
                    return this.wrap_double(NativeString.equals(ScriptRuntime.toString(scriptable2), objectArray));
                }
                case 7: {
                    return this.wrap_int(NativeString.equalsIgnoreCase(ScriptRuntime.toString(scriptable2), objectArray));
                }
                case 8: {
                    return this.wrap_int(NativeString.execMethod(ScriptRuntime.toString(scriptable2), objectArray));
                }
                case 9: {
                    return NativeString.find_split(context, scriptable, ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 10: {
                    return NativeString.get(context, ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 11: {
                    return NativeString.getContext(ScriptRuntime.toString(scriptable2));
                }
                case 12: {
                    return NativeString.getIdDefaultAttributes(ScriptRuntime.toString(scriptable2));
                }
                case 13: {
                    return NativeString.getIdValue(ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 14: {
                    return NativeString.getLanguageVersion(ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 15: {
                    return NativeString.getRegExpProxy(ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 16: {
                    return NativeString.OEAB(scriptable2, "b", null, null);
                }
                case 17: {
                    return NativeString.OEAB(scriptable2, "i", null, null);
                }
                case 18: {
                    return NativeString.OEAB(scriptable2, "tt", null, null);
                }
                case 19: {
                    return NativeString.OEAB(scriptable2, "strike", null, null);
                }
                case 20: {
                    return NativeString.OEAB(scriptable2, "small", null, null);
                }
                case 21: {
                    return NativeString.OEAB(scriptable2, "big", null, null);
                }
                case 22: {
                    return NativeString.OEAB(scriptable2, "blink", null, null);
                }
                case 23: {
                    return NativeString.OEAB(scriptable2, "sup", null, null);
                }
                case 24: {
                    return NativeString.OEAB(scriptable2, "sub", null, null);
                }
                case 25: {
                    return NativeString.OEAB(scriptable2, "font", "size", objectArray);
                }
                case 26: {
                    return NativeString.OEAB(scriptable2, "font", "color", objectArray);
                }
                case 27: {
                    return NativeString.OEAB(scriptable2, "a", "href", objectArray);
                }
                case 28: {
                    return NativeString.OEAB(scriptable2, "a", "name", objectArray);
                }
                case 29: {
                    return this.wrap_boolean(NativeString.getTopLevelScope(ScriptRuntime.toString(scriptable2), ScriptRuntime.toString(objectArray, 0)));
                }
                case 30: {
                    return this.wrap_boolean(NativeString.indexOf(ScriptRuntime.toString(scriptable2), ScriptRuntime.toString(objectArray, 0)));
                }
                case 31: {
                    return NativeString.NaN(context).match(context, scriptable, scriptable2, objectArray);
                }
                case 32: {
                    return NativeString.NaN(context).search(context, scriptable, scriptable2, objectArray);
                }
                case 33: {
                    return NativeString.NaN(context).replace(context, scriptable, scriptable2, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private NativeString D(Scriptable scriptable, IdFunction idFunction) {
        while (!(scriptable instanceof NativeString)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, true);
        }
        return (NativeString)scriptable;
    }

    private static RegExpProxy NaN(Context context) {
        RegExpProxy regExpProxy = context.getRegExpProxy();
        if (regExpProxy == null) {
            throw Context.reportRuntimeError0("msg.no.regexp");
        }
        return regExpProxy;
    }

    private static String OEAB(Object object, String string, String string2, Object[] objectArray) {
        String string3 = ScriptRuntime.toString(object);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
            stringBuffer.append("=\"");
            stringBuffer.append(ScriptRuntime.toString(objectArray, 0));
            stringBuffer.append('\"');
        }
        stringBuffer.append('>');
        stringBuffer.append(string3);
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    private static String addAsPrototype(Object[] objectArray) {
        int n = objectArray.length;
        if (n < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(ScriptRuntime.toUint16(objectArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static Object jsConstructor(Object[] objectArray, boolean bl) {
        String string;
        String string2 = string = objectArray.length >= 1 ? ScriptRuntime.toString(objectArray[0]) : "";
        if (bl) {
            return new NativeString(string);
        }
        return string;
    }

    public String toString() {
        return this.string;
    }

    private String addIdFunctionProperty() {
        return this.string;
    }

    private String append() {
        return this.string;
    }

    public Object get(int n, Scriptable scriptable) {
        if (0 <= n && n < this.string.length()) {
            return this.string.substring(n, n + 1);
        }
        return super.get(n, scriptable);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (0 <= n && n < this.string.length()) {
            return;
        }
        super.put(n, scriptable, object);
    }

    private static String charAt(String string, Object[] objectArray) {
        double d = ScriptRuntime.toInteger(objectArray, 0);
        if (d < 0.0 || d >= (double)string.length()) {
            return "";
        }
        return string.substring((int)d, (int)d + 1);
    }

    private static double equals(String string, Object[] objectArray) {
        double d = ScriptRuntime.toInteger(objectArray, 0);
        if (d < 0.0 || d >= (double)string.length()) {
            return ScriptRuntime.NaN;
        }
        return string.charAt((int)d);
    }

    private static int equalsIgnoreCase(String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toInteger(objectArray, 1);
        if (d > (double)string.length()) {
            return -1;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return string.indexOf(string2, (int)d);
    }

    private static int execMethod(String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toNumber(objectArray, 1);
        if (d != d || d > (double)string.length()) {
            d = string.length();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return string.lastIndexOf(string2, (int)d);
    }

    /*
     * Unable to fully structure code
     */
    private static int fillConstructorProperties(Scriptable var0, String var1_1, String var2_2, Object var3_3, int[] var4_4, int[] var5_5, boolean[] var6_6, String[][] var7_7) {
        block11: {
            var8_8 = var4_4[0];
            var9_9 = var1_1.length();
            var10_10 = Context.getContext();
            var11_11 = var10_10.getLanguageVersion();
            if (var11_11 != 120 || var3_3 != null || var2_2.length() != 1 || var2_2.charAt(0) != ' ') break block11;
            if (var8_8 == 0) {
                while (var8_8 < var9_9 && Character.isWhitespace(var1_1.charAt(var8_8))) {
                    ++var8_8;
                }
                var4_4[0] = var8_8;
            }
            if (var8_8 != var9_9) ** GOTO lbl14
            return -1;
lbl-1000:
            // 1 sources

            {
                ++var8_8;
lbl14:
                // 2 sources

                ** while (var8_8 < var9_9 && !Character.isWhitespace((char)var1_1.charAt((int)var8_8)))
            }
lbl15:
            // 1 sources

            var12_12 = var8_8;
            while (var12_12 < var9_9 && Character.isWhitespace(var1_1.charAt(var12_12))) {
                ++var12_12;
            }
            var5_5[0] = var12_12 - var8_8;
            return var8_8;
        }
        if (var8_8 > var9_9) {
            return -1;
        }
        if (var3_3 != null) {
            return var10_10.getRegExpProxy().find_split(var0, var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
        }
        if (var11_11 != 0 && var11_11 < 130 && var9_9 == 0) {
            return -1;
        }
        if (var2_2.length() == 0) {
            if (var11_11 == 120) {
                if (var8_8 == var9_9) {
                    var5_5[0] = 1;
                    return var8_8;
                }
                return var8_8 + 1;
            }
            return var8_8 == var9_9 ? -1 : var8_8 + 1;
        }
        if (var4_4[0] >= var9_9) {
            return var9_9;
        }
        var8_8 = var1_1.indexOf(var2_2, var4_4[0]);
        return var8_8 != -1 ? var8_8 : var9_9;
    }

    private static Object find_split(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        int n;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        if (objectArray.length < 1) {
            scriptable3.put(0, scriptable3, (Object)string);
            return scriptable3;
        }
        boolean bl = objectArray.length > 1 && objectArray[1] != Undefined.instance;
        long l = 0L;
        if (bl && (l = ScriptRuntime.toUint32(objectArray[1])) > (long)string.length()) {
            l = 1 + string.length();
        }
        String string2 = null;
        int[] nArray = new int[]{0};
        Object object = null;
        RegExpProxy regExpProxy = context.getRegExpProxy();
        if (regExpProxy != null && regExpProxy.isRegExp(objectArray[0])) {
            object = objectArray[0];
        } else {
            string2 = ScriptRuntime.toString(objectArray[0]);
            nArray[0] = string2.length();
        }
        int[] nArray2 = new int[]{0};
        int n2 = 0;
        boolean[] blArray = new boolean[]{false};
        String[][] stringArray = new String[][]{null};
        while ((n = NativeString.fillConstructorProperties(scriptable, string, string2, object, nArray2, nArray, blArray, stringArray)) >= 0) {
            if (bl && (long)n2 >= l || n > string.length()) break;
            String string3 = string.length() == 0 ? string : string.substring(nArray2[0], n);
            scriptable3.put(n2, scriptable3, (Object)string3);
            ++n2;
            if (object != null && blArray[0]) {
                int n3 = stringArray[0].length;
                int n4 = 0;
                while (n4 < n3) {
                    if (bl && (long)n2 >= l) break;
                    scriptable3.put(n2, scriptable3, (Object)stringArray[0][n4]);
                    ++n2;
                    ++n4;
                }
                blArray[0] = false;
            }
            nArray2[0] = n + nArray[0];
            if (context.getLanguageVersion() < 130 && context.getLanguageVersion() != 0 && !bl && nArray2[0] == string.length()) break;
        }
        return scriptable3;
    }

    private static String get(Context context, String string, Object[] objectArray) {
        double d;
        int n = string.length();
        double d2 = ScriptRuntime.toInteger(objectArray, 0);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length <= 1 || objectArray[1] == Undefined.instance) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > (double)n) {
                d = n;
            }
            if (d < d2) {
                if (context.getLanguageVersion() != 120) {
                    double d3 = d2;
                    d2 = d;
                    d = d3;
                } else {
                    d = d2;
                }
            }
        }
        return string.substring((int)d2, (int)d);
    }

    private static String getContext(String string) {
        return string.toLowerCase();
    }

    private static String getIdDefaultAttributes(String string) {
        return string.toUpperCase();
    }

    int getLength() {
        return this.string.length();
    }

    private static String getIdValue(String string, Object[] objectArray) {
        double d;
        if (objectArray.length < 1) {
            return string;
        }
        double d2 = ScriptRuntime.toInteger(objectArray[0]);
        int n = string.length();
        if (d2 < 0.0) {
            if ((d2 += (double)n) < 0.0) {
                d2 = 0.0;
            }
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length == 1) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            }
            if ((d += d2) > (double)n) {
                d = n;
            }
        }
        return string.substring((int)d2, (int)d);
    }

    private static String getLanguageVersion(String string, Object[] objectArray) {
        CharSequence charSequence;
        int n = objectArray.length;
        if (n == 0) {
            return string;
        }
        int n2 = string.length();
        String[] stringArray = new String[n];
        int n3 = 0;
        while (n3 != n) {
            charSequence = ScriptRuntime.toString(objectArray[n3]);
            stringArray[n3] = charSequence;
            n2 += ((String)charSequence).length();
            ++n3;
        }
        charSequence = new StringBuffer(n2);
        ((StringBuffer)charSequence).append(string);
        int n4 = 0;
        while (n4 != n) {
            ((StringBuffer)charSequence).append(stringArray[n4]);
            ++n4;
        }
        return ((StringBuffer)charSequence).toString();
    }

    private static String getRegExpProxy(String string, Object[] objectArray) {
        if (objectArray.length != 0) {
            double d;
            double d2 = ScriptRuntime.toInteger(objectArray[0]);
            int n = string.length();
            if (d2 < 0.0) {
                if ((d2 += (double)n) < 0.0) {
                    d2 = 0.0;
                }
            } else if (d2 > (double)n) {
                d2 = n;
            }
            if (objectArray.length == 1) {
                d = n;
            } else {
                d = ScriptRuntime.toInteger(objectArray[1]);
                if (d < 0.0) {
                    if ((d += (double)n) < 0.0) {
                        d = 0.0;
                    }
                } else if (d > (double)n) {
                    d = n;
                }
                if (d < d2) {
                    d = d2;
                }
            }
            return string.substring((int)d2, (int)d);
        }
        return string;
    }

    private static boolean getTopLevelScope(String string, String string2) {
        return string.equals(string2);
    }

    private static boolean indexOf(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    protected String getIdName(int n) {
        if (n == 1) {
            return "length";
        }
        if (this.prototypeFlag) {
            switch (n) {
                case -1: {
                    return "fromCharCode";
                }
                case 2: {
                    return "constructor";
                }
                case 3: {
                    return "toString";
                }
                case 4: {
                    return "valueOf";
                }
                case 5: {
                    return "charAt";
                }
                case 6: {
                    return "charCodeAt";
                }
                case 7: {
                    return "indexOf";
                }
                case 8: {
                    return "lastIndexOf";
                }
                case 9: {
                    return "split";
                }
                case 10: {
                    return "substring";
                }
                case 11: {
                    return "toLowerCase";
                }
                case 12: {
                    return "toUpperCase";
                }
                case 13: {
                    return "substr";
                }
                case 14: {
                    return "concat";
                }
                case 15: {
                    return "slice";
                }
                case 16: {
                    return "bold";
                }
                case 17: {
                    return "italics";
                }
                case 18: {
                    return "fixed";
                }
                case 19: {
                    return "strike";
                }
                case 20: {
                    return "small";
                }
                case 21: {
                    return "big";
                }
                case 22: {
                    return "blink";
                }
                case 23: {
                    return "sup";
                }
                case 24: {
                    return "sub";
                }
                case 25: {
                    return "fontsize";
                }
                case 26: {
                    return "fontcolor";
                }
                case 27: {
                    return "link";
                }
                case 28: {
                    return "anchor";
                }
                case 29: {
                    return "equals";
                }
                case 30: {
                    return "equalsIgnoreCase";
                }
                case 31: {
                    return "match";
                }
                case 32: {
                    return "search";
                }
                case 33: {
                    return "replace";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        if (string.equals("length")) {
            return 1;
        }
        if (this.prototypeFlag) {
            return NativeString.instance(string);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int instance(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(2);
                if (c == 'b') {
                    if (string.charAt(0) != 's' || string.charAt(1) != 'u') break;
                    return 24;
                }
                if (c == 'g') {
                    if (string.charAt(0) != 'b' || string.charAt(1) != 'i') break;
                    return 21;
                }
                if (c != 'p' || string.charAt(0) != 's' || string.charAt(1) != 'u') break;
                return 23;
            }
            case 4: {
                char c = string.charAt(0);
                if (c == 'b') {
                    string2 = "bold";
                    n = 16;
                    break;
                }
                if (c != 'l') break;
                string2 = "link";
                n = 27;
                break;
            }
            case 5: {
                switch (string.charAt(4)) {
                    case 'd': {
                        string2 = "fixed";
                        n = 18;
                        break block0;
                    }
                    case 'e': {
                        string2 = "slice";
                        n = 15;
                        break block0;
                    }
                    case 'h': {
                        string2 = "match";
                        n = 31;
                        break block0;
                    }
                    case 'k': {
                        string2 = "blink";
                        n = 22;
                        break block0;
                    }
                    case 'l': {
                        string2 = "small";
                        n = 20;
                        break block0;
                    }
                    case 't': {
                        string2 = "split";
                        n = 9;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (string.charAt(1)) {
                    case 'e': {
                        char c = string.charAt(0);
                        if (c == 'l') {
                            string2 = "length";
                            n = 1;
                            break;
                        }
                        if (c != 's') break;
                        string2 = "search";
                        n = 32;
                        break;
                    }
                    case 'h': {
                        string2 = "charAt";
                        n = 5;
                        break;
                    }
                    case 'n': {
                        string2 = "anchor";
                        n = 28;
                        break;
                    }
                    case 'o': {
                        string2 = "concat";
                        n = 14;
                        break;
                    }
                    case 'q': {
                        string2 = "equals";
                        n = 29;
                        break;
                    }
                    case 't': {
                        string2 = "strike";
                        n = 19;
                        break;
                    }
                    case 'u': {
                        string2 = "substr";
                        n = 13;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (string.charAt(1)) {
                    case 'a': {
                        string2 = "valueOf";
                        n = 4;
                        break block0;
                    }
                    case 'e': {
                        string2 = "replace";
                        n = 33;
                        break block0;
                    }
                    case 'n': {
                        string2 = "indexOf";
                        n = 7;
                        break block0;
                    }
                    case 't': {
                        string2 = "italics";
                        n = 17;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = string.charAt(0);
                if (c == 'f') {
                    string2 = "fontsize";
                    n = 25;
                    break;
                }
                if (c != 't') break;
                string2 = "toString";
                n = 3;
                break;
            }
            case 9: {
                char c = string.charAt(0);
                if (c == 'f') {
                    string2 = "fontcolor";
                    n = 26;
                    break;
                }
                if (c != 's') break;
                string2 = "substring";
                n = 10;
                break;
            }
            case 10: {
                string2 = "charCodeAt";
                n = 6;
                break;
            }
            case 11: {
                switch (string.charAt(2)) {
                    case 'L': {
                        string2 = "toLowerCase";
                        n = 11;
                        break block0;
                    }
                    case 'U': {
                        string2 = "toUpperCase";
                        n = 12;
                        break block0;
                    }
                    case 'n': {
                        string2 = "constructor";
                        n = 2;
                        break block0;
                    }
                    case 's': {
                        string2 = "lastIndexOf";
                        n = 8;
                        break block0;
                    }
                }
                break;
            }
            case 16: {
                string2 = "equalsIgnoreCase";
                n = 30;
            }
        }
        if (string2 == null) return n;
        if (string2 == string) return n;
        if (string2.equals(string)) return n;
        return 0;
    }
}

