/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSPriority;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class LAFUtil {
    public static final String SHOW_SECTION_BORDER_PROP = "show.section.border";
    public static final Color SECTION_HEADER_COLOR0 = new Color(255, 255, 255, 51);
    public static final Color SECTION_HEADER_COLOR1 = new Color(255, 255, 255, 76);
    public static final Color BUTTON_PRESSED_TRANSPARENT = new Color(255, 255, 255, 0);
    private static final Color DEFAULT_COLOR_1 = new Color(222, 222, 222);
    private static final Color DEFAULT_COLOR_2 = new Color(161, 161, 161);

    private LAFUtil() {
    }

    public static Color[] getTabContentBackgroundColors(ToolstripTab toolstripTab) {
        Color[] colorArray = LAFUtil.getBackgroundColors(toolstripTab);
        colorArray[0] = DEFAULT_COLOR_1;
        colorArray[1] = DEFAULT_COLOR_2;
        return colorArray;
    }

    public static Color[] getTabBackgroundColors(ToolstripTab toolstripTab) {
        return LAFUtil.getBackgroundColors(toolstripTab);
    }

    private static Color[] getBackgroundColors(ToolstripTab toolstripTab) {
        DefaultToolstrip defaultToolstrip = (DefaultToolstrip)toolstripTab.getToolstrip();
        if (defaultToolstrip == null) {
            return new Color[]{DEFAULT_COLOR_1, DEFAULT_COLOR_2};
        }
        int n = defaultToolstrip.getHeaderHeight();
        int n2 = defaultToolstrip.getContentHeight();
        float f = (float)n / (float)(n + n2);
        float f2 = 1.0f - f;
        Color color = LAFUtil.getTabColor(toolstripTab);
        Color color2 = ColorUtils.darker((Color)color, (double)0.82);
        return new Color[]{color, color, color2};
    }

    public static Color getTabColor(ToolstripTab toolstripTab) {
        Color color = toolstripTab != null ? (Color)toolstripTab.getAttribute(ToolstripTab.COLOR) : null;
        return color != null ? color : new Color(0xE6E6E6);
    }

    public static void paintTriangle(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2) {
        Color color3 = graphics2D.getColor();
        int n5 = 0;
        n3 = Math.max(n3, 2);
        int n6 = n3 / 2 - 1;
        graphics2D.translate(n, n2);
        graphics2D.setColor(color);
        switch (n4) {
            case 1: {
                int n7;
                for (n7 = 0; n7 < n3; ++n7) {
                    graphics2D.drawLine(n6 - n7, n7, n6 + n7, n7);
                }
                if (bl) break;
                graphics2D.setColor(color2);
                graphics2D.drawLine(n6 - n7 + 2, n7, n6 + n7, n7);
                break;
            }
            case 5: {
                int n8;
                if (!bl) {
                    graphics2D.translate(1, 1);
                    graphics2D.setColor(color2);
                    for (n8 = n3 - 1; n8 >= 0; --n8) {
                        graphics2D.drawLine(n6 - n8, n5, n6 + n8, n5);
                        ++n5;
                    }
                    graphics2D.translate(-1, -1);
                    graphics2D.setColor(color);
                }
                n5 = 0;
                for (n8 = n3 - 1; n8 >= 0; --n8) {
                    graphics2D.drawLine(n6 - n8, n5, n6 + n8, n5);
                    ++n5;
                }
                break;
            }
            case 7: {
                int n9;
                for (n9 = 0; n9 < n3; ++n9) {
                    graphics2D.drawLine(n9, n6 - n9, n9, n6 + n9);
                }
                if (bl) break;
                graphics2D.setColor(color2);
                graphics2D.drawLine(n9, n6 - n9 + 2, n9, n6 + n9);
                break;
            }
            case 3: {
                int n10;
                if (!bl) {
                    graphics2D.translate(1, 1);
                    graphics2D.setColor(color2);
                    for (n10 = n3 - 1; n10 >= 0; --n10) {
                        graphics2D.drawLine(n5, n6 - n10, n5, n6 + n10);
                        ++n5;
                    }
                    graphics2D.translate(-1, -1);
                    graphics2D.setColor(color);
                }
                n5 = 0;
                for (n10 = n3 - 1; n10 >= 0; --n10) {
                    graphics2D.drawLine(n5, n6 - n10, n5, n6 + n10);
                    ++n5;
                }
                break;
            }
        }
        graphics2D.translate(-n, -n2);
        graphics2D.setColor(color3);
    }

    public static Rectangle getWorkArea(JComponent jComponent) {
        return LAFUtil.getWorkArea(jComponent, jComponent.getWidth(), jComponent.getHeight());
    }

    public static Rectangle getWorkArea(JComponent jComponent, int n, int n2) {
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = n - (insets.right + insets.left);
        rectangle.height = n2 - (insets.bottom + insets.top);
        return rectangle;
    }

    public static void drawRoundButtonPressedRect(Graphics2D graphics2D, Shape shape, ToolstripTheme toolstripTheme) {
        Rectangle rectangle = shape.getBounds();
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 8.0f, 8.0f);
        RoundRectangle2D.Float float_2 = new RoundRectangle2D.Float(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4, 8.0f, 8.0f);
        LAFUtil.drawButtonPressedRect(graphics2D, shape, float_, float_2, toolstripTheme);
    }

    public static void drawButtonPressedRect(Graphics2D graphics2D, Shape shape, ToolstripTheme toolstripTheme) {
        Rectangle rectangle = shape.getBounds();
        Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        LAFUtil.drawButtonPressedRect(graphics2D, shape, float_, float_2, toolstripTheme);
    }

    public static void drawButtonPressedRect(Graphics2D graphics2D, Shape shape, Shape shape2, Shape shape3, ToolstripTheme toolstripTheme) {
        graphics2D.setColor(toolstripTheme.getPressedBackground());
        graphics2D.fill(shape);
        graphics2D.setColor(toolstripTheme.getPressedSplitbuttonBorder());
        graphics2D.draw(shape);
        Color color = toolstripTheme.getPressedBorder();
        Rectangle rectangle = shape2.getBounds();
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x, rectangle.y + rectangle.height, LAFUtil.composeWithAlpha(color, 64)));
        graphics2D.draw(shape2);
        Rectangle rectangle2 = shape3.getBounds();
        graphics2D.setPaint(new GradientPaint(rectangle2.x, rectangle2.y, LAFUtil.composeWithAlpha(color, 160), rectangle2.x, rectangle2.y + rectangle2.height, LAFUtil.composeWithAlpha(color, 32)));
        graphics2D.draw(shape3);
        int n = rectangle2.x + 1;
        int n2 = rectangle2.y + 1;
        int n3 = rectangle2.x + rectangle2.width - 1;
        graphics2D.setPaint(LAFUtil.composeWithAlpha(color, 112));
        graphics2D.drawLine(n, n2, n3, n2);
    }

    public static RectangularShape getButtonRect(Rectangle rectangle) {
        return LAFUtil.getButtonRect(rectangle, rectangle.width, rectangle.height);
    }

    public static RectangularShape drawButtonArmedRect(Graphics2D graphics2D, Rectangle rectangle, ToolstripTheme toolstripTheme) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        RectangularShape rectangularShape = LAFUtil.getButtonRect(rectangle, n, n2);
        double d = rectangularShape.getHeight();
        Rectangle2D rectangle2D = rectangularShape.getFrame();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = (int)(0.3 * d);
        int n8 = (int)(0.7 * d);
        Color color = LAFUtil.composeWithAlpha(Color.white, 32);
        Color color2 = LAFUtil.composeWithAlpha(Color.white, 80);
        graphics2D.setPaint(new GradientPaint(n3, n6, color, n4, n7, color2));
        rectangle2D.setFrame(n3 + 2, n6 + 2, (double)n3 + rectangularShape.getWidth() - 2.0, n7);
        graphics2D.fill(rectangle2D);
        graphics2D.setPaint(new GradientPaint(n4, n7, color2, n5, n8, color2));
        rectangle2D.setFrame(n4 + 2, n7 + 2, (double)n3 + rectangularShape.getWidth() - 1.0, n8 - n7);
        graphics2D.fill(rectangle2D);
        graphics2D.setPaint(new GradientPaint(n5, n8, color2, 0.0f, (int)rectangularShape.getHeight(), color));
        rectangle2D.setFrame(n5 + 2, n8 + 2, (double)n3 + rectangularShape.getWidth() - 1.0, (int)rectangularShape.getHeight());
        graphics2D.fill(rectangle2D);
        graphics2D.setColor(LAFUtil.composeWithAlpha(toolstripTheme.getArmedBorder(), 32));
        graphics2D.draw(rectangularShape);
        return rectangularShape;
    }

    public static RectangularShape drawbuttonArmedDropDownRect(Graphics2D graphics2D, Rectangle rectangle, ToolstripTheme toolstripTheme) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        RectangularShape rectangularShape = LAFUtil.getButtonRect(rectangle, n, n2);
        graphics2D.setPaint(toolstripTheme.getArmedBackground());
        graphics2D.fill(rectangularShape);
        graphics2D.setColor(toolstripTheme.getPressedSplitbuttonBorder());
        graphics2D.draw(rectangularShape);
        return rectangularShape;
    }

    public static RectangularShape drawbuttonArmedDropDownRectHorizontalLeft(Graphics2D graphics2D, Rectangle rectangle, ToolstripTheme toolstripTheme) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        RectangularShape rectangularShape = LAFUtil.getButtonRect(rectangle, n, n2);
        graphics2D.setPaint(BUTTON_PRESSED_TRANSPARENT);
        graphics2D.fill(rectangularShape);
        graphics2D.setColor(toolstripTheme.getPressedSplitbuttonBorder());
        graphics2D.draw(rectangularShape);
        return rectangularShape;
    }

    public static void drawbuttonHorizontalRight(Graphics2D graphics2D, Rectangle rectangle, ToolstripTheme toolstripTheme) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        RectangularShape rectangularShape = LAFUtil.getButtonRect(rectangle, n, n2);
        graphics2D.setPaint(BUTTON_PRESSED_TRANSPARENT);
        graphics2D.fill(rectangularShape);
        graphics2D.setColor(toolstripTheme.getPressedSplitbuttonBorder());
        graphics2D.draw(rectangularShape);
    }

    public static RectangularShape getButtonRect(Rectangle rectangle, int n, int n2) {
        return new RoundRectangle2D.Float(rectangle.x, rectangle.y, n - 1, n2 - 1, 8.0f, 8.0f);
    }

    public static String[] breakText(String string) {
        if (string != null && string.trim().length() > 0) {
            int n;
            for (int i = n = string.length() / 2; i >= 0; --i) {
                if (!Character.isWhitespace(string.charAt(i))) continue;
                return new String[]{string.substring(0, i), string.substring(i + 1)};
            }
            return new String[]{string, ""};
        }
        return new String[]{"", ""};
    }

    public static Color composeWithAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static void paintTriangleAt(Graphics2D graphics2D, int n, int n2, Color color, Color color2) {
        graphics2D.setColor(color);
        graphics2D.drawLine(n, n2, n + 7, n2);
        graphics2D.setColor(color2);
        graphics2D.drawLine(n + 1, n2 + 1, n + 1 + 5, n2 + 1);
        graphics2D.drawLine(n + 2, n2 + 2, n + 2 + 3, n2 + 2);
        graphics2D.drawLine(n + 3, n2 + 3, n + 3 + 1, n2 + 3);
    }

    public static void paintBigTriangleAt(Graphics2D graphics2D, int n, int n2, Color color, Color color2) {
        graphics2D.setColor(color);
        graphics2D.drawLine(n, n2, n + 9, n2);
        graphics2D.setColor(color2);
        graphics2D.drawLine(n + 1, n2 + 1, n + 1 + 7, n2 + 1);
        graphics2D.drawLine(n + 2, n2 + 2, n + 2 + 5, n2 + 2);
        graphics2D.drawLine(n + 3, n2 + 3, n + 3 + 3, n2 + 3);
        graphics2D.drawLine(n + 4, n2 + 4, n + 4 + 1, n2 + 4);
    }

    public static void paintDarkTriangle(Graphics2D graphics2D, int n, int n2) {
        ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
        LAFUtil.paintTriangleAt(graphics2D, n, n2, toolstripTheme.getDarkTriangle0(), toolstripTheme.getDarkTriangle1());
    }

    public static void paintBigDarkTriangle(Graphics2D graphics2D, int n, int n2) {
        ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
        LAFUtil.paintBigTriangleAt(graphics2D, n, n2, toolstripTheme.getDarkTriangle0(), toolstripTheme.getDarkTriangle1());
    }

    public static void paintWhiteTriangle(Graphics2D graphics2D, int n, int n2) {
        ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
        LAFUtil.paintTriangleAt(graphics2D, n, n2, toolstripTheme.getWhiteTriangle0(), toolstripTheme.getWhiteTriangle1());
    }

    public static Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        String string = "disabledIcon." + icon.getIconWidth();
        Icon icon2 = (Icon)jComponent.getClientProperty(string);
        if (icon2 == null) {
            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(jComponent, bufferedImage.getGraphics(), 0, 0);
            icon2 = new ImageIcon(LAFUtil.disableImage(bufferedImage));
            jComponent.putClientProperty(string, icon2);
        }
        return icon2;
    }

    public static BufferedImage disableImage(BufferedImage bufferedImage) {
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = n >> 24 & 0xFF;
            if (n2 == 0) {
                nArray[i] = 0;
                continue;
            }
            int n3 = n >> 16 & 0xFF;
            int n4 = n >> 8 & 0xFF;
            int n5 = n & 0xFF;
            n2 = (int)((float)n2 * 0.3f);
            double d = 0.0;
            double d2 = 0.299 * (double)n3 + 0.587 * (double)n4 + 0.114 * (double)n5;
            n3 = (int)(d2 + d * ((double)n3 - d2));
            n4 = (int)(d2 + d * ((double)n4 - d2));
            n5 = (int)(d2 + d * ((double)n5 - d2));
            nArray[i] = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        }
        return bufferedImage;
    }

    public static void drawSectionBorder(Graphics2D graphics2D, JComponent jComponent, int n, int n2, int n3) {
        Object object = jComponent.getClientProperty(SHOW_SECTION_BORDER_PROP);
        if (object == null || object.toString().equals("true")) {
            ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
            int n4 = toolstripTheme.getSectionTitleBorderPadding();
            graphics2D.setPaint(new GradientPaint(n, n2 += n4, toolstripTheme.getSectionTitleVBorderColor0(), n, n3 -= n4, toolstripTheme.getSectionTitleVBorderColor1()));
            graphics2D.drawLine(n, n2, n, n3);
        }
    }

    public static void drawSectionHeaderBackground(Graphics2D graphics2D, Rectangle rectangle) {
        LAFUtil.drawSectionHeaderBackground(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawSectionHeaderBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = n + n3 / 3;
        int n6 = n + n3 - n3 / 3;
        graphics2D.setPaint(new GradientPaint(n, n2, SECTION_HEADER_COLOR0, n5, n2, SECTION_HEADER_COLOR1));
        graphics2D.fillRect(n, n2, n5 - n, n4);
        graphics2D.setPaint(SECTION_HEADER_COLOR1);
        graphics2D.fillRect(n5, n2, n6 - n5, n4);
        graphics2D.setPaint(new GradientPaint(n6, n2, SECTION_HEADER_COLOR1, n + n3, n2, SECTION_HEADER_COLOR0));
        graphics2D.fillRect(n6, n2, n + n3 - n6, n4);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        RenderingHints renderingHints = GraphicsUtils.getAntialiasingRenderingHints();
        if (renderingHints != null) {
            graphics2D.setRenderingHints(renderingHints);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics2D.drawString(string, n, n2);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
    }

    public static String getComponentDescription(TSComponent tSComponent) {
        return LAFUtil.getComponentDescription(tSComponent, null);
    }

    public static String getComponentDescription(TSComponent tSComponent, String string) {
        return tSComponent.getClass().getName() + "[" + ((JComponent)((Object)tSComponent)).getName() + "," + (string == null ? "" : "\"" + string + "\"") + "," + LAFUtil.getLayoutMode(tSComponent) + "," + (Object)((Object)LAFUtil.getPriority(tSComponent)) + "]";
    }

    public static String[] parseMnemonic(String string) {
        String[] stringArray = null;
        if (string != null) {
            int n;
            int n2 = string.indexOf(38);
            if (n2 >= 0 && n2 != string.length() - 1 && string.charAt(n2 + 1) != ' ') {
                String string2 = n2 > 0 && string.charAt(n2 - 1) == '(' ? string.substring(0, n2 - 1) : string.substring(0, n2) + string.substring(n2 + 1);
                stringArray = new String[]{string2, string.substring(n2 + 1, n2 + 2)};
            }
            if ((n2 = string.indexOf(91)) >= 0 && (n = string.indexOf(93, n2 + 1)) >= 0 && n2 + 1 != n) {
                stringArray = new String[]{string.substring(0, n2) + string.substring(n + 1), string.substring(n2 + 1, n)};
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{string, null};
        }
        return stringArray;
    }

    public static TSPriority getPriority(TSComponent tSComponent) {
        return LAFUtil.getPriority((JComponent)((Object)tSComponent));
    }

    public static TSPriority getPriority(JComponent jComponent) {
        TSPriority tSPriority = (TSPriority)((Object)jComponent.getClientProperty("toolstripPriority"));
        return tSPriority == null ? TSPriority.NORMAL : tSPriority;
    }

    public static TSComponent setPriority(TSComponent tSComponent, TSPriority tSPriority) {
        return (TSComponent)((Object)LAFUtil.setPriority((JComponent)((Object)tSComponent), tSPriority));
    }

    public static JComponent setPriority(JComponent jComponent, TSPriority tSPriority) {
        jComponent.putClientProperty("toolstripPriority", (Object)tSPriority);
        return jComponent;
    }

    public static LayoutMode getLayoutMode(TSComponent tSComponent) {
        return LAFUtil.getLayoutMode((JComponent)((Object)tSComponent));
    }

    public static LayoutMode getLayoutMode(JComponent jComponent) {
        LayoutMode layoutMode = (LayoutMode)jComponent.getClientProperty("toolstripLayoutMode");
        return layoutMode == null ? LayoutMode.HORIZONTAL_ONLY_CAPABILITIES : layoutMode;
    }

    public static TSComponent setLayoutMode(TSComponent tSComponent, LayoutMode layoutMode) {
        LAFUtil.setLayoutMode((JComponent)((Object)tSComponent), layoutMode);
        return tSComponent;
    }

    public static JComponent setLayoutMode(JComponent jComponent, LayoutMode layoutMode) {
        jComponent.putClientProperty("toolstripLayoutMode", layoutMode);
        return jComponent;
    }

    public static Rectangle convertRectangleToScreen(Rectangle rectangle, Component component) {
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, component);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    public static Rectangle convertRectangleFromScreen(Rectangle rectangle, Component component) {
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointFromScreen(point, component);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }
}

