/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.mwswing.ResizableIcon;
import com.mathworks.mwswing.SimpleStringTrimmer;
import com.mathworks.toolstrip.components.gallery.GalleryButton;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.RegularButtonUI;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.StringUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;

public class GalleryButtonUI
extends RegularButtonUI {
    private static final GalleryButtonUI GALLERY_BUTTON_UI = new GalleryButtonUI();
    private static final int MAX_FONT_HEIGHT = 15;
    private static final int MIN_FONT_SIZE = 6;
    private static final Insets DEFAULT_MARGINS = new Insets(1, 1, 1, 1);
    private static final int GAP = LanguageUtils.isCJK() ? 0 : 1;

    public static GalleryButtonUI createUI(JComponent jComponent) {
        return GALLERY_BUTTON_UI;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        ((AbstractButton)jComponent).setMargin(DEFAULT_MARGINS);
    }

    @Override
    protected void paintContent(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle, boolean bl) {
        int n;
        int n2 = ((GalleryButton)((Object)abstractButton)).getLabelLineCount();
        int n3 = 0;
        int n4 = 0;
        FontMetrics fontMetrics = null;
        if (n2 > 0) {
            Font font = abstractButton.getFont();
            graphics2D.setFont(font);
            fontMetrics = graphics2D.getFontMetrics();
            n = font.getSize();
            while (fontMetrics.getHeight() > 15 && --n >= 6) {
                font = font.deriveFont(n);
                graphics2D.setFont(font);
                fontMetrics = graphics2D.getFontMetrics();
            }
            n4 = Math.min(fontMetrics.getHeight(), 15);
            graphics2D.setColor(abstractButton.isEnabled() ? abstractButton.getForeground() : this.fTheme.getButtonDisabledTextColor());
            n3 = n2 * n4;
        }
        int n5 = abstractButton.getWidth();
        n = abstractButton.getHeight();
        Insets insets = abstractButton.getMargin();
        int n6 = n5 - insets.left - insets.right;
        int n7 = n - insets.top - insets.bottom - n3 - GAP;
        Icon icon = abstractButton.getIcon();
        if (icon instanceof ResizableIcon) {
            ((ResizableIcon)icon).setDimension(n6, n7);
        }
        if (icon != null) {
            if (!abstractButton.isEnabled()) {
                icon = LAFUtil.getDisabledIcon(abstractButton, icon);
            }
            icon.paintIcon(abstractButton, graphics2D, insets.left + (n6 - icon.getIconWidth()) / 2, insets.top + (n7 - icon.getIconHeight()) / 2);
        }
        if (n2 > 0) {
            int n8 = insets.left;
            int n9 = insets.top + n7 + GAP;
            if (n2 == 1) {
                GalleryButtonUI.drawText(graphics2D, abstractButton.getText(), n8, n9, n6, fontMetrics);
            } else {
                List<String> list = GalleryButtonUI.wrapText(abstractButton.getText(), n6, fontMetrics);
                for (String string : list) {
                    GalleryButtonUI.drawText(graphics2D, string, n8, n9, n6, fontMetrics);
                    n9 += n4;
                }
            }
        }
    }

    private static List<String> wrapText(String string, int n, FontMetrics fontMetrics) {
        if ((string = string.trim()).indexOf(10) >= 0) {
            return StringUtils.split((String)string, (String)"\n");
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        int n2 = fontMetrics.stringWidth(string);
        if (n2 <= n) {
            arrayList.add(string);
        } else {
            for (int i = string.length() - 1; i > 0; --i) {
                String string2;
                if (!Character.isWhitespace(string.charAt(i)) || fontMetrics.stringWidth(string2 = string.substring(0, i)) > n) continue;
                arrayList.add(string2);
                arrayList.add(string.substring(i + 1, string.length()));
            }
            if (arrayList.isEmpty()) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private static void drawText(Graphics2D graphics2D, String string, int n, int n2, int n3, FontMetrics fontMetrics) {
        SimpleStringTrimmer simpleStringTrimmer = new SimpleStringTrimmer();
        String string2 = simpleStringTrimmer.shortenString(string, fontMetrics, n3);
        int n4 = fontMetrics.stringWidth(string2);
        LAFUtil.drawString(graphics2D, string2, n + (n3 - n4) / 2, n2 + fontMetrics.getAscent());
    }
}

