/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.attr.AttributeChangeListener;
import com.mathworks.desktop.attr.DefaultAttributes;
import com.mathworks.desktop.attr.EnumAttribute;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.toolstrip.components.gallery.GalleryIcon;
import com.mathworks.toolstrip.components.gallery.GalleryOptions;
import com.mathworks.toolstrip.components.gallery.GalleryResources;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.model.SearchableGalleryModel;
import com.mathworks.toolstrip.components.gallery.popupview.AnimationTarget;
import com.mathworks.toolstrip.components.gallery.popupview.Animator;
import com.mathworks.toolstrip.components.gallery.popupview.CategoryContentPanel;
import com.mathworks.toolstrip.components.gallery.popupview.CategoryPanel;
import com.mathworks.toolstrip.components.gallery.popupview.GallerySelectionModel;
import com.mathworks.toolstrip.components.gallery.popupview.SearchFieldProxy;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class GalleryPopupView
extends DefaultAttributes {
    public static final EnumAttribute<GalleryOptions.PopupViewType> VIEW_TYPE = new EnumAttribute("toolstrip-state", GalleryOptions.PopupViewType.class);
    private static boolean sIsTesting = false;
    private final SearchableGalleryModel fModel;
    private PropertyChangeListener fPropertyListener;
    private final Map<String, CategoryPanel> fCategoryPanels;
    private final MJLayeredPane fGalleryArea;
    private final MJPanel fAnimationLayer;
    private final MJPanel fMainLayer;
    private final MJPanel fComponent;
    private final GallerySelectionModel fSelectionModel;
    private PopupMenuCustomizer fPopupMenuCustomizer;
    private ActionListener fActionListener;
    private final int fPreferredWidth;
    private final Dimension fItemSize;
    private final int fLabelLineCount;
    private final MJScrollPane fScrollPane;
    private SearchFieldProxy fSearchField;
    private MJToggleButton fListViewButton;
    private MJToggleButton fIconViewButton;
    private MJButton fCloseButton;

    public GalleryPopupView(SearchableGalleryModel searchableGalleryModel, GalleryOptions.PopupViewType popupViewType, int n, Dimension dimension, int n2) {
        this.fModel = searchableGalleryModel;
        this.fPropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GalleryPopupView.this.refresh();
            }
        };
        this.fModel.addPropertyChangeListener(this.fPropertyListener);
        this.fPreferredWidth = n;
        this.fItemSize = dimension;
        this.fLabelLineCount = n2;
        this.setAttribute((Attribute)VIEW_TYPE, (Object)popupViewType);
        this.addAttributeChangeListener(new AttributeChangeListener(){

            public void attributeChange(AttributeChangeEvent attributeChangeEvent) {
                if (attributeChangeEvent.getAttribute() == VIEW_TYPE) {
                    for (CategoryPanel categoryPanel : GalleryPopupView.this.fCategoryPanels.values()) {
                        categoryPanel.setViewType((GalleryOptions.PopupViewType)((Object)attributeChangeEvent.getNewValue()));
                    }
                }
            }
        });
        this.fSelectionModel = new GallerySelectionModel();
        this.fCategoryPanels = new HashMap<String, CategoryPanel>();
        this.fMainLayer = new VerticalBox();
        this.fAnimationLayer = new MJPanel();
        this.fAnimationLayer.setLayout(null);
        this.fAnimationLayer.setOpaque(false);
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout());
        this.fGalleryArea = new MJLayeredPane(){

            public Dimension getPreferredSize() {
                Dimension dimension = GalleryPopupView.this.fMainLayer.getPreferredSize();
                dimension.width = GalleryPopupView.this.fPreferredWidth;
                return dimension;
            }

            public void doLayout() {
                GalleryPopupView.this.fMainLayer.setBounds(0, 0, this.getWidth(), this.getHeight());
                GalleryPopupView.this.fAnimationLayer.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        };
        this.fGalleryArea.add((Component)this.fMainLayer, (Object)MJLayeredPane.DEFAULT_LAYER);
        this.fGalleryArea.add((Component)this.fAnimationLayer, (Object)MJLayeredPane.DRAG_LAYER);
        this.fSearchField = new SearchFieldProxy(GalleryResources.getString("search.prompt"));
        this.fSearchField.enableFocusRelinquishing();
        this.fSearchField.getComponent().setName("Gallery_Search_TextField");
        this.fSearchField.addSearchTextFieldListener(new SearchFieldProxy.Listener(){

            @Override
            public void search(String string) {
                GalleryPopupView.this.fModel.search(string);
            }

            @Override
            public void searchTextChanged(String string) {
                GalleryPopupView.this.fModel.search(string);
            }

            @Override
            public void searchCleared() {
                GalleryPopupView.this.fModel.endSearch();
            }
        });
        this.fScrollPane = new MJScrollPane((Component)this.fGalleryArea);
        this.fScrollPane.setName("Gallery_PopupView_ScrollPane");
        this.fScrollPane.setBorder(null);
        this.fScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)this.fSearchField.getComponent(), (Object)"Center");
        this.fListViewButton = new MJToggleButton((Icon)GalleryIcon.LIST_VIEW_ICON.getIcon(), popupViewType == GalleryOptions.PopupViewType.LIST);
        this.fListViewButton.setSelectedIcon((Icon)GalleryIcon.LIST_VIEW_DEPRESSED_ICON.getIcon());
        this.fListViewButton.setName("Gallery_List_View_Button");
        this.fListViewButton.setToolTipText(GalleryResources.getString("listview.tooltip"));
        MJToolBar.configureButton((MJToggleButton)this.fListViewButton);
        this.fListViewButton.setBorder(null);
        this.fListViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GalleryPopupView.this.fListViewButton.isSelected()) {
                    GalleryPopupView.this.setAttribute((Attribute)VIEW_TYPE, (Object)GalleryOptions.PopupViewType.LIST);
                    ItemLocationInfo itemLocationInfo = GalleryPopupView.this.getFirstItem();
                    GalleryPopupView.this.fSelectionModel.setSelectedItem(itemLocationInfo.iCategory, itemLocationInfo.iItem, false);
                }
            }
        });
        this.fIconViewButton = new MJToggleButton((Icon)GalleryIcon.ICON_VIEW_ICON.getIcon(), popupViewType != GalleryOptions.PopupViewType.LIST);
        this.fIconViewButton.setSelectedIcon((Icon)GalleryIcon.ICON_VIEW_DEPRESSED_ICON.getIcon());
        this.fIconViewButton.setName("Gallery_Icon_View_Button");
        this.fIconViewButton.setToolTipText(GalleryResources.getString("iconview.tooltip"));
        MJToolBar.configureButton((MJToggleButton)this.fIconViewButton);
        this.fIconViewButton.setBorder(null);
        this.fIconViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GalleryPopupView.this.fIconViewButton.isSelected()) {
                    GalleryPopupView.this.setAttribute((Attribute)VIEW_TYPE, (Object)GalleryOptions.PopupViewType.ICON);
                    ItemLocationInfo itemLocationInfo = GalleryPopupView.this.getFirstItem();
                    GalleryPopupView.this.fSelectionModel.setSelectedItem(itemLocationInfo.iCategory, itemLocationInfo.iItem, false);
                }
            }
        });
        this.fCloseButton = new MJButton((Icon)GalleryIcon.CLOSE.getIcon());
        this.fCloseButton.setName("CloseGalleryPopupButton");
        this.fCloseButton.setRolloverIcon((Icon)GalleryIcon.CLOSE_HOVER.getIcon());
        this.fCloseButton.setPressedIcon((Icon)GalleryIcon.CLOSE_PRESSED.getIcon());
        MJToolBar.configureButton((MJButton)this.fCloseButton);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(8));
        box.add((Component)this.fListViewButton);
        box.add(Box.createHorizontalStrut(2));
        box.add((Component)this.fIconViewButton);
        box.add(Box.createHorizontalStrut(5));
        box.add((Component)this.fCloseButton);
        mJPanel.add((Component)box, (Object)"East");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fIconViewButton);
        buttonGroup.add((AbstractButton)this.fListViewButton);
        this.fComponent.add((Component)mJPanel, (Object)"North");
        this.fComponent.add((Component)this.fScrollPane, (Object)"Center");
        this.fMainLayer.setBackground(ToolstripTheme.getInstance().getGalleryNonSelectedBackgroundColor());
        this.fComponent.setBackground(ToolstripTheme.getInstance().getGalleryNonSelectedBackgroundColor());
        this.fScrollPane.getViewport().setBackground(ToolstripTheme.getInstance().getGalleryNonSelectedBackgroundColor());
        this.refresh();
        this.configureActionMap();
    }

    private void configureActionMap() {
        this.fGalleryArea.getActionMap().put("up", new AbstractAction("up"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GalleryPopupView.this.processNavigationKeyPress(false, true, false);
            }
        });
        this.fGalleryArea.getActionMap().put("down", new AbstractAction("down"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GalleryPopupView.this.processNavigationKeyPress(true, false, true);
            }
        });
        this.fGalleryArea.getActionMap().put("enter", new AbstractAction("enter"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GalleryPopupView.this.fSelectionModel.getSelectedItem() != null && GalleryPopupView.this.fSelectionModel.getSelectedItem().isEnabled()) {
                    GalleryPopupView.this.fSelectionModel.getSelectedItem().getAction().actionPerformed(actionEvent);
                }
            }
        });
        this.fGalleryArea.getActionMap().put("right", new AbstractAction("right"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((GalleryOptions.PopupViewType)((Object)GalleryPopupView.this.getAttribute((Attribute)VIEW_TYPE))).equals((Object)GalleryOptions.PopupViewType.LIST)) {
                    return;
                }
                GalleryPopupView.this.processNavigationKeyPress(true, false, false);
            }
        });
        this.fGalleryArea.getActionMap().put("left", new AbstractAction("left"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((GalleryOptions.PopupViewType)((Object)GalleryPopupView.this.getAttribute((Attribute)VIEW_TYPE))).equals((Object)GalleryOptions.PopupViewType.LIST)) {
                    return;
                }
                GalleryPopupView.this.processNavigationKeyPress(false, false, false);
            }
        });
        InputMap inputMap = this.fGalleryArea.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("UP"), "up");
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "down");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "enter");
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "right");
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "left");
        ItemLocationInfo itemLocationInfo = this.getFirstItem();
        this.fSelectionModel.setSelectedItem(itemLocationInfo.iCategory, itemLocationInfo.iItem, false);
    }

    private void processNavigationKeyPress(boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        ItemLocationInfo itemLocationInfo = null;
        if (bl2 && ((GalleryOptions.PopupViewType)((Object)this.getAttribute((Attribute)VIEW_TYPE))).equals((Object)GalleryOptions.PopupViewType.ICON)) {
            object2 = this.getPreviousCategory();
            if (object2 != null && this.fModel.getItems((Category)object2) != null && !this.fModel.getItems((Category)object2).isEmpty()) {
                this.fSelectionModel.deselect();
                object = (CategoryContentPanel)((Object)this.fCategoryPanels.get(((Category)object2).getName()).getContentPanel());
                this.fSelectionModel.setSelectedItem((Category)object2, ((CategoryContentPanel)object).getNextItem(null), false);
            }
        } else if (bl3 && ((GalleryOptions.PopupViewType)((Object)this.getAttribute((Attribute)VIEW_TYPE))).equals((Object)GalleryOptions.PopupViewType.ICON)) {
            object2 = this.getNextCategory();
            if (object2 != null && this.fModel.getItems((Category)object2) != null && !this.fModel.getItems((Category)object2).isEmpty()) {
                this.fSelectionModel.deselect();
                object = (CategoryContentPanel)((Object)this.fCategoryPanels.get(((Category)object2).getName()).getContentPanel());
                this.fSelectionModel.setSelectedItem((Category)object2, ((CategoryContentPanel)object).getNextItem(null), false);
            }
        } else {
            itemLocationInfo = bl ? this.getNextItem() : this.getPreviousItem();
        }
        if (itemLocationInfo != null && itemLocationInfo.iItem != null && itemLocationInfo.iCategory != null) {
            this.fSelectionModel.deselect();
            this.fSelectionModel.setSelectedItem(itemLocationInfo.iCategory, itemLocationInfo.iItem, false);
        }
        if (this.fScrollPane.getVerticalScrollBar().isShowing()) {
            object2 = this.fScrollPane.getViewport().getViewPosition();
            object = this.fSelectionModel.getSelectedCategory();
            if (object == null) {
                return;
            }
            CategoryContentPanel categoryContentPanel = (CategoryContentPanel)((Object)this.fCategoryPanels.get(((Category)object).getName()).getContentPanel());
            Point point = categoryContentPanel.getLocation();
            Point point2 = SwingUtilities.convertPoint((Component)((Object)categoryContentPanel), point, (Component)this.fGalleryArea);
            if (bl3 && point2.getY() > ((Point)object2).getY() + 300.0) {
                if (this.fScrollPane.isAtBottom()) {
                    return;
                }
                point2.y -= 100;
                this.fScrollPane.getViewport().setViewPosition(point2);
            } else if (bl2 && point2.getY() < ((Point)object2).getY() + 300.0) {
                if (((Point)object2).getY() == 0.0) {
                    return;
                }
                point2.y -= 100;
                this.fScrollPane.getViewport().setViewPosition(point2);
            }
        }
    }

    private ItemLocationInfo getFirstItem() {
        ItemLocationInfo itemLocationInfo = new ItemLocationInfo();
        List<Category> list = this.fModel.getCategories();
        for (Category category : list) {
            List<Item> list2 = this.fModel.getItems(category);
            if (list2 == null || list2.isEmpty()) continue;
            itemLocationInfo.iCategory = category;
            itemLocationInfo.iItem = list2.get(0);
            break;
        }
        return itemLocationInfo;
    }

    private ItemLocationInfo getNextItem() {
        ItemLocationInfo itemLocationInfo = new ItemLocationInfo();
        Item item = this.fSelectionModel.getSelectedItem();
        Category category = this.fSelectionModel.getSelectedCategory();
        if (category != null) {
            CategoryContentPanel categoryContentPanel = (CategoryContentPanel)((Object)this.fCategoryPanels.get(category.getName()).getContentPanel());
            itemLocationInfo.iItem = categoryContentPanel.getNextItem(item);
            itemLocationInfo.iCategory = category;
            if (itemLocationInfo.iItem == null) {
                itemLocationInfo.iCategory = this.getNextCategory();
                if (itemLocationInfo.iCategory == null) {
                    return null;
                }
                CategoryContentPanel categoryContentPanel2 = (CategoryContentPanel)((Object)this.fCategoryPanels.get(itemLocationInfo.iCategory.getName()).getContentPanel());
                itemLocationInfo.iItem = categoryContentPanel2.getNextItem(null);
            }
        }
        return itemLocationInfo;
    }

    private ItemLocationInfo getPreviousItem() {
        ItemLocationInfo itemLocationInfo = new ItemLocationInfo();
        Item item = this.fSelectionModel.getSelectedItem();
        Category category = this.fSelectionModel.getSelectedCategory();
        if (category != null) {
            CategoryContentPanel categoryContentPanel = (CategoryContentPanel)((Object)this.fCategoryPanels.get(category.getName()).getContentPanel());
            itemLocationInfo.iItem = categoryContentPanel.getPreviousItem(item);
            itemLocationInfo.iCategory = category;
            if (itemLocationInfo.iItem == null) {
                itemLocationInfo.iCategory = this.getPreviousCategory();
                if (itemLocationInfo.iCategory == null) {
                    return null;
                }
                CategoryContentPanel categoryContentPanel2 = (CategoryContentPanel)((Object)this.fCategoryPanels.get(itemLocationInfo.iCategory.getName()).getContentPanel());
                itemLocationInfo.iItem = categoryContentPanel2.getPreviousItem(null);
            }
        }
        return itemLocationInfo;
    }

    private Category getNextCategory() {
        Category category = this.fSelectionModel.getSelectedCategory();
        List<Category> list = this.fModel.getCategories();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(category) || i + 1 >= list.size()) continue;
            Category category2 = list.get(i + 1);
            if (!this.fModel.getItems(category2).isEmpty() && this.doesCategoryHaveEnabledItems(category2)) {
                return category2;
            }
            int n = 2;
            while (n < list.size() && i + n <= list.size() - 1) {
                Category category3 = list.get(i + n);
                if (!this.fModel.getItems(category3).isEmpty()) {
                    if (this.doesCategoryHaveEnabledItems(category3)) {
                        return category3;
                    }
                    ++n;
                    continue;
                }
                ++n;
            }
        }
        return null;
    }

    private Category getPreviousCategory() {
        Category category = this.fSelectionModel.getSelectedCategory();
        List<Category> list = this.fModel.getCategories();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(category) || i - 1 < 0) continue;
            Category category2 = list.get(i - 1);
            if (!this.fModel.getItems(category2).isEmpty() && this.doesCategoryHaveEnabledItems(category2)) {
                return category2;
            }
            int n = 2;
            while (i - n >= 0) {
                Category category3 = list.get(i - n);
                if (!this.fModel.getItems(category3).isEmpty()) {
                    if (this.doesCategoryHaveEnabledItems(category3)) {
                        return category3;
                    }
                    ++n;
                    continue;
                }
                ++n;
            }
        }
        return null;
    }

    private boolean doesCategoryHaveEnabledItems(Category category) {
        boolean bl = false;
        List<Item> list = this.fModel.getItems(category);
        for (Item item : list) {
            if (!item.isEnabled()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void dispose() {
        this.fModel.removePropertyChangeListener(this.fPropertyListener);
        this.fModel.dispose();
        this.fMainLayer.removeAll();
        for (CategoryPanel categoryPanel : this.fCategoryPanels.values()) {
            categoryPanel.dispose();
        }
        this.fCategoryPanels.clear();
    }

    public void setCloseActionListener(ActionListener actionListener) {
        this.fCloseButton.addActionListener(actionListener);
        for (CategoryPanel categoryPanel : this.fCategoryPanels.values()) {
            categoryPanel.setCloseListener(actionListener);
        }
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this.fPopupMenuCustomizer = popupMenuCustomizer;
    }

    private PopupMenuCustomizer getPopupMenuCustomizerProxy() {
        return new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                if (GalleryPopupView.this.fPopupMenuCustomizer != null) {
                    GalleryPopupView.this.fPopupMenuCustomizer.customize(jPopupMenu);
                }
            }
        };
    }

    public void setActionListener(ActionListener actionListener) {
        this.fActionListener = actionListener;
        for (CategoryPanel categoryPanel : this.fCategoryPanels.values()) {
            categoryPanel.setActionListener(actionListener);
        }
    }

    public Item getItemAtPoint(Point point) {
        for (CategoryPanel categoryPanel : this.fCategoryPanels.values()) {
            Point point2;
            Item item = categoryPanel.getItemAtPoint(point2 = SwingUtilities.convertPoint((Component)this.fComponent, point, categoryPanel.getComponent()));
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public JComponent getSearchField() {
        return this.fSearchField.getComponent();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public CategoryPanel getCategoryPanel(String string) {
        return this.fCategoryPanels.get(string);
    }

    public void requestFocus() {
        this.fGalleryArea.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.fGalleryArea.requestFocusInWindow();
    }

    public List<Category> getVisibleCategories() {
        ArrayList<Category> arrayList = new ArrayList<Category>();
        for (Category category : this.fModel.getCategories()) {
            if (this.fModel.getItems(category).isEmpty()) continue;
            arrayList.add(category);
        }
        return arrayList;
    }

    public int getPreferredHeight() {
        int n = 0;
        for (CategoryPanel categoryPanel : this.fCategoryPanels.values()) {
            n += categoryPanel.getComponent().getPreferredSize().height;
        }
        if (this.fSearchField != null) {
            n += this.fSearchField.getComponent().getPreferredSize().height;
        }
        return n + 2;
    }

    private void refresh() {
        this.fMainLayer.removeAll();
        for (CategoryPanel object2 : this.fCategoryPanels.values()) {
            object2.dispose();
        }
        this.fCategoryPanels.clear();
        boolean bl = false;
        List<Category> list = this.getVisibleCategories();
        for (int i = 0; i < list.size(); ++i) {
            Category category = list.get(i);
            CategoryPanel categoryPanel = new CategoryPanel(category, this.fModel, this.fSelectionModel, this.getPopupMenuCustomizerProxy(), i == 0 || bl ? null : new MoveToTop(category), (GalleryOptions.PopupViewType)((Object)this.getAttribute((Attribute)VIEW_TYPE)), new FavoritesAnimation(category), this.fPreferredWidth, this.fItemSize, this.fLabelLineCount, i, category.equals(Category.FAVORITES));
            categoryPanel.setActionListener(this.fActionListener);
            categoryPanel.setCloseListener(this.fCloseButton.getActionListeners()[0]);
            this.fCategoryPanels.put(category.getName(), categoryPanel);
            this.fMainLayer.add((Component)categoryPanel.getComponent());
            bl = category.equals(Category.FAVORITES);
        }
        this.fMainLayer.revalidate();
        this.fMainLayer.repaint();
    }

    public GallerySelectionModel getSelectionModel() {
        return this.fSelectionModel;
    }

    private Category getNonFavoriteCategory(Item item) {
        List<Category> list = this.fModel.getCategories();
        for (Category category : list) {
            if (category.equals(Category.FAVORITES)) continue;
            List<Item> list2 = this.fModel.getItems(category);
            for (Item item2 : list2) {
                if (!item2.equals(item)) continue;
                return category;
            }
        }
        return null;
    }

    public static void setIsTesting(boolean bl) {
        sIsTesting = bl;
    }

    private static class VerticalBox
    extends MJPanel {
        private VerticalBox() {
            this.setLayout(null);
        }

        public void doLayout() {
            int n = this.getWidth();
            int n2 = 0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                int n3 = component.getPreferredSize().height;
                component.setBounds(0, n2, n, n3);
                n2 += n3;
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                Dimension dimension2 = component.getPreferredSize();
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
                dimension.height += dimension2.height;
            }
            return dimension;
        }
    }

    private class FavoritesAnimation
    implements Runnable,
    AnimationTarget,
    FavoriteAnimation {
        private Item iItem;
        private Category iCategory;
        private MJLabel iMovingLabel;
        private MJPanel iMovingPanel;
        private boolean iMoveTo;
        private Timer fAnimationTimer;

        FavoritesAnimation(Category category) {
            this.iCategory = category;
        }

        @Override
        public void setItem(Item item) {
            this.iItem = item;
        }

        @Override
        public void setMoveTo(boolean bl) {
            this.iMoveTo = bl;
        }

        @Override
        public void run() {
            Category category = GalleryPopupView.this.getNonFavoriteCategory(this.iItem);
            if (!sIsTesting && category != null) {
                CategoryPanel categoryPanel = (CategoryPanel)GalleryPopupView.this.fCategoryPanels.get(Category.FAVORITES.getName());
                Point point = null;
                Point point2 = new Point(0, 0);
                GalleryOptions.PopupViewType popupViewType = (GalleryOptions.PopupViewType)((Object)GalleryPopupView.this.getAttribute((Attribute)VIEW_TYPE));
                if (this.iMoveTo) {
                    CategoryPanel categoryPanel2 = (CategoryPanel)GalleryPopupView.this.fCategoryPanels.get(this.iCategory.getName());
                    if (categoryPanel2 == null) {
                        return;
                    }
                    if (popupViewType.equals((Object)GalleryOptions.PopupViewType.ICON)) {
                        this.iMovingLabel = new MJLabel(this.iItem.getIcon());
                        GalleryPopupView.this.fAnimationLayer.add((Component)this.iMovingLabel);
                        CategoryContentPanel categoryContentPanel = (CategoryContentPanel)((Object)categoryPanel2.getContentPanel());
                        Component component = categoryContentPanel.getComponentForItem(this.iItem);
                        point = SwingUtilities.convertPoint(component, component.getLocation(), (Component)GalleryPopupView.this.fGalleryArea);
                        point.x = component.getX() - categoryPanel2.getComponent().getWidth() / 2 + 40;
                        if (categoryPanel != null) {
                            point2.y = categoryPanel.getComponent().getY() + categoryPanel.getComponent().getHeight() / 2;
                            point2.x = point.x;
                        }
                    } else if (popupViewType.equals((Object)GalleryOptions.PopupViewType.LIST)) {
                        CategoryContentPanel categoryContentPanel = (CategoryContentPanel)((Object)categoryPanel2.getContentPanel());
                        Component component = categoryContentPanel.getComponentForItem(this.iItem);
                        this.iMovingPanel = new MJPanel((LayoutManager)new BorderLayout());
                        this.iMovingPanel.add(component);
                        GalleryPopupView.this.fAnimationLayer.add((Component)this.iMovingPanel);
                        point = SwingUtilities.convertPoint((Component)((Object)categoryContentPanel), component.getLocation(), (Component)GalleryPopupView.this.fGalleryArea);
                        if (categoryPanel != null) {
                            point2.y = categoryPanel.getComponent().getY() + categoryPanel.getComponent().getHeight();
                        }
                    }
                } else {
                    CategoryPanel categoryPanel3 = (CategoryPanel)GalleryPopupView.this.fCategoryPanels.get(category.getName());
                    if (popupViewType.equals((Object)GalleryOptions.PopupViewType.ICON)) {
                        this.iMovingLabel = new MJLabel(this.iItem.getIcon());
                        GalleryPopupView.this.fAnimationLayer.add((Component)this.iMovingLabel);
                        CategoryContentPanel categoryContentPanel = (CategoryContentPanel)((Object)categoryPanel.getContentPanel());
                        Component component = categoryContentPanel.getComponentForItem(this.iItem);
                        point = SwingUtilities.convertPoint(component, component.getLocation(), (Component)GalleryPopupView.this.fGalleryArea);
                        point.x = component.getX() - categoryPanel.getComponent().getWidth() / 2 + 40;
                        point2.y = categoryPanel3.getComponent().getY() + categoryPanel3.getComponent().getHeight() / 2;
                        point2.x = point.x;
                    } else if (popupViewType.equals((Object)GalleryOptions.PopupViewType.LIST)) {
                        CategoryContentPanel categoryContentPanel = (CategoryContentPanel)((Object)categoryPanel.getContentPanel());
                        Component component = categoryContentPanel.getComponentForItem(this.iItem);
                        this.iMovingPanel = new MJPanel((LayoutManager)new BorderLayout());
                        this.iMovingPanel.add(component);
                        GalleryPopupView.this.fAnimationLayer.add((Component)this.iMovingPanel);
                        point = SwingUtilities.convertPoint((Component)((Object)categoryContentPanel), component.getLocation(), (Component)GalleryPopupView.this.fGalleryArea);
                        point2.y = categoryPanel3.getComponent().getY() + categoryPanel3.getComponent().getHeight() / 2;
                    }
                }
                this.fAnimationTimer = new Timer(16, new Animator(this, point, point2));
                this.fAnimationTimer.start();
            } else if (this.iMoveTo) {
                GalleryPopupView.this.fModel.addToFavorites(this.iItem);
            } else {
                GalleryPopupView.this.fModel.removeFromFavorites(this.iItem);
            }
        }

        @Override
        public void setAnimationLocation(Point point) {
            if (point == null) {
                return;
            }
            if (this.iMovingLabel != null) {
                this.iMovingLabel.setBounds((int)point.getX(), (int)point.getY(), GalleryPopupView.this.fGalleryArea.getWidth(), (int)this.iMovingLabel.getPreferredSize().getHeight());
            } else if (this.iMovingPanel != null) {
                this.iMovingPanel.setBounds((int)point.getX(), (int)point.getY(), GalleryPopupView.this.fGalleryArea.getWidth(), (int)this.iMovingPanel.getPreferredSize().getHeight());
            }
            GalleryPopupView.this.fGalleryArea.revalidate();
            GalleryPopupView.this.fGalleryArea.repaint();
        }

        @Override
        public void animationStart() {
        }

        @Override
        public void animationComplete() {
            if (this.iMovingLabel != null) {
                GalleryPopupView.this.fAnimationLayer.remove((Component)this.iMovingLabel);
            }
            if (this.iMovingPanel != null) {
                GalleryPopupView.this.fAnimationLayer.remove((Component)this.iMovingPanel);
            }
            if (this.iItem != null) {
                if (this.iMoveTo) {
                    GalleryPopupView.this.fModel.addToFavorites(this.iItem);
                } else {
                    GalleryPopupView.this.fModel.removeFromFavorites(this.iItem);
                }
            }
            GalleryPopupView.this.refresh();
            this.fAnimationTimer.stop();
            this.iMovingLabel = null;
            this.iItem = null;
            this.iMovingPanel = null;
        }

        @Override
        public boolean isRunning() {
            return this.fAnimationTimer != null && this.fAnimationTimer.isRunning();
        }
    }

    public static interface FavoriteAnimation {
        public void setItem(Item var1);

        public void setMoveTo(boolean var1);

        public boolean isRunning();
    }

    private class MoveToTop
    implements Runnable,
    AnimationTarget {
        private final Category iCategory;
        private CategoryPanel iMovingPanel;

        MoveToTop(Category category) {
            this.iCategory = category;
        }

        @Override
        public void run() {
            if (!sIsTesting) {
                CategoryPanel categoryPanel = (CategoryPanel)GalleryPopupView.this.fCategoryPanels.get(this.iCategory.getName());
                if (categoryPanel != null) {
                    this.iMovingPanel = new CategoryPanel(categoryPanel);
                    GalleryPopupView.this.fAnimationLayer.add((Component)this.iMovingPanel.getComponent());
                    Point point = categoryPanel.getComponent().getLocation();
                    Point point2 = new Point(0, 0);
                    CategoryPanel categoryPanel2 = (CategoryPanel)GalleryPopupView.this.fCategoryPanels.get(Category.FAVORITES.getName());
                    if (categoryPanel2 != null && !GalleryPopupView.this.fModel.getItems(Category.FAVORITES).isEmpty()) {
                        point2.y = categoryPanel2.getComponent().getY() + categoryPanel2.getComponent().getHeight();
                    }
                    Timer timer = new Timer(16, new Animator(this, point, point2));
                    timer.start();
                }
            } else {
                GalleryPopupView.this.fModel.moveCategory(this.iCategory, 1);
                GalleryPopupView.this.refresh();
            }
        }

        @Override
        public void setAnimationLocation(Point point) {
            this.iMovingPanel.getComponent().setBounds((int)point.getX(), (int)point.getY(), GalleryPopupView.this.fGalleryArea.getWidth(), (int)this.iMovingPanel.getComponent().getPreferredSize().getHeight());
            GalleryPopupView.this.fGalleryArea.revalidate();
            GalleryPopupView.this.fGalleryArea.repaint();
        }

        @Override
        public void animationStart() {
        }

        @Override
        public void animationComplete() {
            if (this.iMovingPanel != null) {
                GalleryPopupView.this.fAnimationLayer.remove((Component)this.iMovingPanel.getComponent());
            }
            GalleryPopupView.this.fModel.moveCategory(this.iCategory, 1);
            GalleryPopupView.this.refresh();
            this.iMovingPanel.dispose();
        }
    }

    private static class ItemLocationInfo {
        private Item iItem;
        private Category iCategory;

        private ItemLocationInfo() {
        }
    }
}

