/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jidesoft.swing.MultilineLabel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.WarningState;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WarningsWidget
extends AbstractParamWidget<Map<String, WarningState>> {
    private final Map<String, MJRadioButton> fEnableChecks;
    private final Map<String, MJRadioButton> fDisableChecks;
    private final Map<String, MJRadioButton> fErrorChecks;
    private final Map<String, WarningState> fDefaults;
    private final MJPanel fComponent;
    private final MJButton fDisableAllButton;
    private final MJButton fEnableAllButton;
    private final MJButton fErrorAllButton;
    private final MJButton fDefaultButton;
    private boolean fWidgetEnabled = true;

    public WarningsWidget(String string, String string2, Map<String, String> map, Map<String, WarningState> map2) {
        this.fDefaults = new HashMap<String, WarningState>(map2);
        this.fEnableChecks = new HashMap<String, MJRadioButton>();
        this.fDisableChecks = new HashMap<String, MJRadioButton>();
        this.fErrorChecks = new HashMap<String, MJRadioButton>();
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 10));
        this.fComponent.setOpaque(false);
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        MJLabel mJLabel = new MJLabel(BuiltInResources.getString("build.warning.disable"));
        mJLabel.setName(string + ".header.disable");
        MJLabel mJLabel2 = new MJLabel(BuiltInResources.getString("build.warning.enable"));
        mJLabel.setName(string + ".header.enable");
        MJLabel mJLabel3 = new MJLabel(BuiltInResources.getString("build.warning.error"));
        mJLabel.setName(string + ".header.error");
        MJLabel mJLabel4 = new MJLabel(BuiltInResources.getString("build.warning.title"));
        mJLabel4.setName(string + ".header.name");
        mJPanel.add((Component)mJLabel, (Object)gridBagConstraints);
        ++gridBagConstraints.gridx;
        mJPanel.add((Component)mJLabel2, (Object)gridBagConstraints);
        ++gridBagConstraints.gridx;
        mJPanel.add((Component)mJLabel3, (Object)gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)mJLabel4, (Object)gridBagConstraints);
        for (Map.Entry<String, String> object : map.entrySet()) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            MJRadioButton mJRadioButton = new MJRadioButton();
            mJRadioButton.setOpaque(false);
            mJRadioButton.setName(string + ".radio.disable." + object.getKey());
            MJRadioButton mJRadioButton2 = new MJRadioButton();
            mJRadioButton2.setName(string + ".radio.enable." + object.getKey());
            mJRadioButton2.setOpaque(false);
            MJRadioButton mJRadioButton3 = new MJRadioButton();
            mJRadioButton3.setName(string + ".radio.error." + object.getKey());
            mJRadioButton3.setOpaque(false);
            mJPanel.add((Component)mJRadioButton, (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            mJPanel.add((Component)mJRadioButton2, (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            mJPanel.add((Component)mJRadioButton3, (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            mJPanel.add((Component)new MJLabel(object.getValue()), (Object)gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)mJRadioButton);
            buttonGroup.add((AbstractButton)mJRadioButton2);
            buttonGroup.add((AbstractButton)mJRadioButton3);
            this.fEnableChecks.put(object.getKey(), mJRadioButton2);
            this.fDisableChecks.put(object.getKey(), mJRadioButton);
            this.fErrorChecks.put(object.getKey(), mJRadioButton3);
            mJRadioButton2.addItemListener(this.createItemListener());
            mJRadioButton.addItemListener(this.createItemListener());
            mJRadioButton3.addItemListener(this.createItemListener());
        }
        this.fDisableAllButton = new MJButton(BuiltInResources.getString("warnings.disableAll"));
        this.fDisableAllButton.setName(string + ".button.disable.all");
        this.fDisableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (MJRadioButton mJRadioButton : WarningsWidget.this.fDisableChecks.values()) {
                    mJRadioButton.setSelected(true);
                }
            }
        });
        this.fEnableAllButton = new MJButton(BuiltInResources.getString("warnings.enableAll"));
        this.fEnableAllButton.setName(string + ".button.enable.all");
        this.fEnableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (MJRadioButton mJRadioButton : WarningsWidget.this.fEnableChecks.values()) {
                    mJRadioButton.setSelected(true);
                }
            }
        });
        this.fErrorAllButton = new MJButton(BuiltInResources.getString("warnings.errorAll"));
        this.fErrorAllButton.setName(string + ".button.error.all");
        this.fErrorAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (MJRadioButton mJRadioButton : WarningsWidget.this.fErrorChecks.values()) {
                    mJRadioButton.setSelected(true);
                }
            }
        });
        this.fDefaultButton = new MJButton(BuiltInResources.getString("warnings.default"));
        this.fDefaultButton.setName(string + ".button.default");
        this.fDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WarningsWidget.this.setData(WarningsWidget.this.fDefaults);
            }
        });
        JPanel jPanel = ButtonBarFactory.buildLeftAlignedBar((JButton)this.fDisableAllButton, (JButton)this.fEnableAllButton, (JButton)this.fErrorAllButton, (JButton)this.fDefaultButton);
        jPanel.setOpaque(false);
        if (string2 != null) {
            MultilineLabel multilineLabel = new MultilineLabel(string2){

                public Dimension getPreferredSize() {
                    return new Dimension(0, (int)super.getPreferredSize().getHeight());
                }
            };
            multilineLabel.setOpaque(false);
            this.fComponent.add((Component)multilineLabel, (Object)"North");
        }
        this.fComponent.add((Component)mJPanel, (Object)"Center");
        this.fComponent.add((Component)jPanel, (Object)"South");
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WarningsWidget.this.updateButtonStates();
            }
        });
    }

    private void updateButtonStates() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                for (Map.Entry entry : WarningsWidget.this.getData().entrySet()) {
                    if (entry.getValue() != WarningState.ON) {
                        bl = true;
                    }
                    if (entry.getValue() != WarningState.OFF) {
                        bl2 = true;
                    }
                    if (entry.getValue() != WarningState.ERROR) {
                        bl4 = true;
                    }
                    if (entry.getValue() == WarningsWidget.this.fDefaults.get(entry.getKey())) continue;
                    bl3 = true;
                }
                WarningsWidget.this.fEnableAllButton.setEnabled(WarningsWidget.this.fWidgetEnabled && bl);
                WarningsWidget.this.fDisableAllButton.setEnabled(WarningsWidget.this.fWidgetEnabled && bl2);
                WarningsWidget.this.fDefaultButton.setEnabled(WarningsWidget.this.fWidgetEnabled && bl3);
                WarningsWidget.this.fErrorAllButton.setEnabled(WarningsWidget.this.fWidgetEnabled && bl4);
            }
        });
    }

    public Map<String, WarningState> getData() {
        HashMap<String, WarningState> hashMap = new HashMap<String, WarningState>();
        for (Map.Entry<String, MJRadioButton> entry : this.fEnableChecks.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            hashMap.put(entry.getKey(), WarningState.ON);
        }
        for (Map.Entry<String, MJRadioButton> entry : this.fErrorChecks.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            hashMap.put(entry.getKey(), WarningState.ERROR);
        }
        for (Map.Entry<String, MJRadioButton> entry : this.fDisableChecks.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            hashMap.put(entry.getKey(), WarningState.OFF);
        }
        return hashMap;
    }

    public void setEnabled(boolean bl) {
        this.fWidgetEnabled = bl;
        this.updateButtonStates();
        for (MJRadioButton mJRadioButton : this.fEnableChecks.values()) {
            mJRadioButton.setEnabled(bl);
        }
        for (MJRadioButton mJRadioButton : this.fDisableChecks.values()) {
            mJRadioButton.setEnabled(bl);
        }
        for (MJRadioButton mJRadioButton : this.fErrorChecks.values()) {
            mJRadioButton.setEnabled(bl);
        }
    }

    public void setData(Map<String, WarningState> map) {
        for (Map.Entry<String, WarningState> entry : map.entrySet()) {
            if (entry.getValue() == WarningState.ON) {
                this.fEnableChecks.get(entry.getKey()).setSelected(true);
                continue;
            }
            if (entry.getValue() == WarningState.OFF) {
                this.fDisableChecks.get(entry.getKey()).setSelected(true);
                continue;
            }
            this.fErrorChecks.get(entry.getKey()).setSelected(true);
        }
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
    }

    @Override
    public boolean isExternalLabelRequired() {
        return false;
    }
}

