/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.settingsui.DefaultNavigationBarPainter;
import com.mathworks.project.impl.settingsui.MacNavigationBarPainter;
import com.mathworks.project.impl.settingsui.NavigationBarPainter;
import com.mathworks.project.impl.settingsui.SettingsPaintingUtils;
import com.mathworks.services.FontPrefs;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class NavigationBar {
    private final MJPanel fComponent;
    private final NavigationBarPainter fPainter = !PlatformInfo.isMacintosh() ? new DefaultNavigationBarPainter() : new MacNavigationBarPainter();
    private final ParameterRunnable<Component> fSelector;
    private final List<Element> fElements;
    private final Map<Element, Rectangle2D> fElementRects;
    private final FocusDetector fFocusDetector;
    private int fRightEdge;
    private Element fSelectedElement;
    private Element fPressedElement;
    private Element fHoveredElement;
    private Icon fDarkIcon;
    private Point fMouseDownLocation;
    private Timer fHoverTimer;

    public NavigationBar(ParameterRunnable<Component> parameterRunnable) {
        this.fComponent = new BarComponent();
        this.fSelector = parameterRunnable;
        this.fElements = new ArrayList<Element>();
        this.fElementRects = new HashMap<Element, Rectangle2D>();
        this.fFocusDetector = new FocusDetector();
        this.fComponent.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Element element = NavigationBar.this.getElementAtPoint(mouseEvent.getPoint());
                if (element != NavigationBar.this.fPressedElement) {
                    NavigationBar.this.fPressedElement = element;
                    NavigationBar.this.fDarkIcon = SettingsPaintingUtils.makeDarkIcon(element.getIcon());
                    NavigationBar.this.fComponent.revalidate();
                    NavigationBar.this.fComponent.repaint();
                }
                if (element == null) {
                    NavigationBar.this.fMouseDownLocation = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(NavigationBar.this.fMouseDownLocation, (Component)NavigationBar.this.fComponent);
                } else {
                    NavigationBar.this.fMouseDownLocation = null;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (NavigationBar.this.fPressedElement != null && NavigationBar.this.fPressedElement == NavigationBar.this.fHoveredElement) {
                    NavigationBar.this.fSelectedElement = NavigationBar.this.fPressedElement;
                    NavigationBar.this.fSelector.run((Object)NavigationBar.this.fSelectedElement.getComponent());
                }
                NavigationBar.this.fPressedElement = null;
                NavigationBar.this.fComponent.revalidate();
                NavigationBar.this.fComponent.repaint();
            }
        });
        this.fComponent.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (PlatformInfo.isMacintosh() && NavigationBar.this.fMouseDownLocation != null) {
                    Point point = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(point, (Component)NavigationBar.this.fComponent);
                    Window window = SwingUtilities.windowForComponent((Component)NavigationBar.this.fComponent);
                    window.setLocation((int)((double)window.getX() + point.getX() - NavigationBar.this.fMouseDownLocation.getX()), (int)((double)window.getY() + point.getY() - NavigationBar.this.fMouseDownLocation.getY()));
                    NavigationBar.this.fMouseDownLocation = point;
                }
                NavigationBar.this.updateHover(mouseEvent.getPoint());
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                NavigationBar.this.updateHover(mouseEvent.getPoint());
            }
        });
    }

    public void dispose() {
    }

    private void startHoverTimer() {
        this.fHoverTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Point point;
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                Point point2 = point = pointerInfo == null ? null : pointerInfo.getLocation();
                if (point != null) {
                    SwingUtilities.convertPointFromScreen(point, (Component)NavigationBar.this.fComponent);
                }
                NavigationBar.this.updateHover(point);
            }
        });
        this.fHoverTimer.start();
    }

    private void stopHoverTimer() {
        if (this.fHoverTimer != null) {
            this.fHoverTimer.stop();
            this.fHoverTimer = null;
        }
    }

    private void updateHover(Point point) {
        Element element;
        Element element2 = element = point == null ? null : this.getElementAtPoint(point);
        if (element != this.fHoveredElement) {
            if (this.fHoveredElement == null) {
                this.stopHoverTimer();
            } else {
                this.startHoverTimer();
            }
            this.fHoveredElement = element;
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }
    }

    public void reset() {
        this.fElements.clear();
        this.fElementRects.clear();
        this.fComponent.revalidate();
        this.fComponent.repaint();
        this.fHoveredElement = null;
        this.fPressedElement = null;
        this.fSelectedElement = null;
    }

    public void addElement(String string, Icon icon, Component component) {
        Element element = new Element(string, icon, component);
        this.fElements.add(element);
        if (this.fSelectedElement == null) {
            this.fSelectedElement = element;
            this.fSelector.run((Object)element.getComponent());
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    private Element getElementAtPoint(Point point) {
        for (Map.Entry<Element, Rectangle2D> entry : this.fElementRects.entrySet()) {
            if (!entry.getValue().contains(point)) continue;
            return entry.getKey();
        }
        return null;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private static class Element {
        private final String fText;
        private final Icon fIcon;
        private final Component fComponent;

        Element(String string, Icon icon, Component component) {
            this.fText = string;
            this.fIcon = icon;
            this.fComponent = component;
        }

        public String getText() {
            return this.fText;
        }

        public Icon getIcon() {
            return this.fIcon;
        }

        public Component getComponent() {
            return this.fComponent;
        }
    }

    private class FocusDetector {
        private boolean fValue = true;
        private Long fFirstQueryTime;
        private long fLastChangeTime = System.currentTimeMillis();
        private Timer fNoiseCancellationTimer;
        private final int fNoiseDelay = 500;

        private FocusDetector() {
        }

        public void notifyValue(boolean bl) {
            if (bl != this.fValue) {
                if (System.currentTimeMillis() - this.fLastChangeTime > 500L) {
                    this.setValue(bl);
                } else {
                    this.waitForNoiseToEnd();
                }
            }
        }

        private void waitForNoiseToEnd() {
            if (this.fNoiseCancellationTimer == null) {
                this.fNoiseCancellationTimer = new Timer((int)Math.max(0L, 500L - (System.currentTimeMillis() - this.fLastChangeTime)), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NavigationBar.this.fComponent.revalidate();
                        NavigationBar.this.fComponent.repaint();
                        FocusDetector.this.fNoiseCancellationTimer.start();
                    }
                });
                this.fNoiseCancellationTimer.setRepeats(false);
                this.fNoiseCancellationTimer.start();
            }
        }

        private void setValue(boolean bl) {
            this.fValue = bl;
            this.fLastChangeTime = System.currentTimeMillis();
        }

        public boolean isFocused() {
            if (this.fFirstQueryTime == null) {
                this.fFirstQueryTime = System.currentTimeMillis();
            }
            return System.currentTimeMillis() - this.fFirstQueryTime < 1500L ? true : this.fValue;
        }
    }

    private class BarComponent
    extends MJPanel {
        private BarComponent() {
        }

        public Dimension getPreferredSize() {
            if (NavigationBar.this.fRightEdge == 0) {
                this.paint(this.getGraphics(), true);
            }
            return new Dimension(NavigationBar.this.fRightEdge + 8, PlatformInfo.isMacintosh() ? 60 : 80);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            this.paint(graphics, false);
        }

        public void paint(Graphics graphics, boolean bl) {
            Object object;
            NavigationBar.this.fFocusDetector.notifyValue(SwingUtilities.windowForComponent((Component)NavigationBar.this.fComponent).isFocused());
            boolean bl2 = NavigationBar.this.fFocusDetector.isFocused();
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (graphics2D == null) {
                object = new BufferedImage(1, 1, 2);
                graphics2D = ((BufferedImage)object).createGraphics();
            }
            object = PlatformInfo.isMacintosh() ? FontPrefs.getTextFont().deriveFont(10.0f) : FontUtils.getSystemUIFont().deriveFont(11);
            graphics2D.setFont((Font)object);
            if (!bl) {
                NavigationBar.this.fPainter.paintBackground(graphics2D, new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()), bl2);
            }
            int n = 4;
            Icon icon = null;
            int n2 = 0;
            for (Element element : NavigationBar.this.fElements) {
                Icon icon2 = element.getIcon();
                int n3 = (int)((Font)object).getStringBounds(element.getText(), graphics2D.getFontRenderContext()).getWidth();
                int n4 = 24;
                if (icon != null) {
                    n4 = Math.max(24, 64 - (n + icon2.getIconWidth() / 2 - (n2 + icon.getIconWidth() / 2)));
                }
                if (!PlatformInfo.isMacintosh()) {
                    n4 += 6;
                }
                n2 = n + (n3 += n4) / 2 - icon2.getIconWidth() / 2;
                icon = icon2;
                Rectangle2D.Double double_ = new Rectangle2D.Double(n, 2.0, n3, this.getHeight() - 4);
                NavigationBar.this.fElementRects.put(element, double_);
                if (!bl) {
                    NavigationBar.this.fPainter.paintButton(graphics2D, element.getText(), element.getIcon(), NavigationBar.this.fDarkIcon, n2, double_, n4, bl2, element == NavigationBar.this.fSelectedElement, element == NavigationBar.this.fHoveredElement, element == NavigationBar.this.fPressedElement && element == NavigationBar.this.fHoveredElement);
                }
                n += n3;
            }
            NavigationBar.this.fRightEdge = n;
        }
    }
}

