/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.project.impl.settingsui.ListTextField;
import com.mathworks.project.impl.settingsui.ListTextFieldStyle;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractListWidget<T>
extends AbstractParamWidget<List<T>> {
    private final ListTextField fField;

    protected AbstractListWidget(Project project, Param param, ListTextFieldStyle listTextFieldStyle) {
        this(project, param, listTextFieldStyle, new ArrayList<FileSetFilter>());
    }

    protected AbstractListWidget(Project project, Param param, ListTextFieldStyle listTextFieldStyle, List<FileSetFilter> list) {
        this.fField = new ListTextField(param.getKey(), listTextFieldStyle, false, list);
        this.fField.addDocumentListener(this.createDocumentListener());
        if (param.getValidationRule() != null) {
            this.fField.installBasicTextValidator(param.getValidationRule());
        }
        DetailedToolTip.install((Component)this.fField.getTextField(), project.getConfiguration(), param);
    }

    protected ListTextField getField() {
        return this.fField;
    }

    public void setEnabled(boolean bl) {
        this.fField.setEnabled(bl);
    }

    public Component getComponent() {
        return this.fField.getComponent();
    }

    @Override
    public boolean showValidationMessage(ValidationMessage validationMessage) {
        return this.fField.showValidationMessage(validationMessage);
    }

    @Override
    public void clearValidationMessage() {
        this.fField.clearValidationMessage();
    }

    public void dispose() {
        DetailedToolTip.uninstall(this.fField.getTextField());
        this.fField.dispose();
    }
}

