/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.util.Holder;
import com.mathworks.util.ObjectPool;
import com.mathworks.util.ReturnRunnable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XmlReaderImpl
implements XmlReader {
    private Element fElement;
    private final XmlReaderImpl fParent;
    private final String[] fSearchNames;
    private final int fSearchIndex;
    private static final ObjectPool<DocumentBuilder> fBuilderPool = new ObjectPool((ReturnRunnable)new ReturnRunnable<DocumentBuilder>(){

        public DocumentBuilder run() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IllegalStateException(parserConfigurationException);
            }
        }
    }, Integer.valueOf(3));

    XmlReaderImpl(String string) throws IOException {
        this(null, null, null, 0);
        this.fElement = XmlReaderImpl.parseInput(new StringReader(string));
    }

    XmlReaderImpl(File file) throws IOException {
        this(null, null, null, 0);
        this.fElement = XmlReaderImpl.parseInput(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
    }

    XmlReaderImpl(XmlReaderImpl xmlReaderImpl, Element element) {
        this(xmlReaderImpl, element, null, 0);
    }

    private XmlReaderImpl(XmlReaderImpl xmlReaderImpl, Element element, String[] stringArray, int n) {
        this.fParent = xmlReaderImpl;
        this.fElement = element;
        this.fSearchNames = stringArray == null ? null : (String[])stringArray.clone();
        this.fSearchIndex = n;
    }

    private static Element parseInput(Reader reader) throws IOException {
        DocumentBuilder documentBuilder = (DocumentBuilder)fBuilderPool.acquire();
        try {
            final Holder holder = new Holder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    holder.set((Object)sAXParseException);
                }
            });
            DOMBuilder dOMBuilder = new DOMBuilder();
            Document document = dOMBuilder.build(documentBuilder.parse(new InputSource(reader)));
            if (holder.get() != null) {
                throw (SAXParseException)holder.get();
            }
            Element element = document.getRootElement();
            return element;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        catch (SAXException sAXException) {
            throw new IOException("XML error " + sAXException.getMessage());
        }
        finally {
            reader.close();
            documentBuilder.setErrorHandler(null);
            fBuilderPool.release((Object)documentBuilder);
        }
    }

    Element getElement() {
        return this.fElement;
    }

    public String readText(String string) {
        return this.getChild(string).readText();
    }

    public int readInt(String string) {
        String string2 = this.readText(string);
        return string2 == null ? 0 : Integer.parseInt(string2);
    }

    public boolean readBoolean(String string) {
        String string2 = this.readText(string);
        return string2 != null && Boolean.parseBoolean(string2);
    }

    public String readText() {
        return this.fElement != null ? this.fElement.getText() : null;
    }

    public String[] readTextList(String string) {
        final LinkedList linkedList = new LinkedList();
        this.loop(new XmlLooper(){

            public void iterate(XmlReader xmlReader) {
                linkedList.add(xmlReader.readText());
            }
        }, string);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public Map<String, String> readAttributes() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Attribute attribute : this.fElement.getAttributes()) {
            treeMap.put(attribute.getName(), attribute.getValue());
        }
        return treeMap;
    }

    public String readAttribute(String string) {
        if (this.fElement == null) {
            return null;
        }
        if (this.fElement.getAttribute(string) == null) {
            return null;
        }
        return this.fElement.getAttribute(string).getValue();
    }

    public void loop(XmlLooper xmlLooper, String ... stringArray) {
        XmlReaderImpl xmlReaderImpl = this.getChild(stringArray);
        while (xmlReaderImpl.isPresent()) {
            xmlLooper.iterate((XmlReader)xmlReaderImpl);
            xmlReaderImpl = xmlReaderImpl.next();
        }
    }

    private static int findNext(Element element, int n, String ... stringArray) {
        List list = element.getChildren();
        for (int i = n; i < list.size(); ++i) {
            Content content = (Content)list.get(i);
            if (!(content instanceof Element)) continue;
            Element element2 = (Element)content;
            if (stringArray == null || stringArray.length == 0) {
                return i;
            }
            for (String string : stringArray) {
                if (!element2.getName().equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public XmlReaderImpl getChild() {
        return this.getChild(new String[0]);
    }

    public XmlReaderImpl getChild(String ... stringArray) {
        int n;
        if (this.fElement != null && (n = XmlReaderImpl.findNext(this.fElement, 0, stringArray)) >= 0) {
            Element element = (Element)this.fElement.getChildren().get(n);
            return new XmlReaderImpl(this, element, stringArray, n + 1);
        }
        return new XmlReaderImpl(this, null);
    }

    public XmlReaderImpl getParent() {
        return this.fParent;
    }

    public boolean isPresent() {
        return this.fElement != null;
    }

    public XmlReaderImpl next() {
        int n;
        if (this.fElement != null && this.fParent != null && this.fParent.fElement != null && (n = XmlReaderImpl.findNext(this.fParent.fElement, this.fSearchIndex, this.fSearchNames)) >= 0) {
            Element element = (Element)this.fParent.fElement.getChildren().get(n);
            return new XmlReaderImpl(this.fParent, element, this.fSearchNames, n + 1);
        }
        return new XmlReaderImpl(this, null);
    }

    public String getCurrentElementName() {
        return this.fElement.getName();
    }

    public XmlReaderImpl getCurrentSubtree() {
        return new XmlReaderImpl(null, this.fElement);
    }

    public synchronized String getXML() {
        if (!this.isPresent()) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            xMLOutputter.output(this.fElement, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return stringWriter.toString();
    }

    public String toString() {
        return this.getXML();
    }

    public int hashCode() {
        return this.getXML().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof XmlReader && this.getXML().equals(((XmlReader)object).getXML());
    }
}

