/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Target;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.MulticastChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class PrefsWatcher {
    private String fPreferenceXml;
    private final Set<String> fUsedPrefs = new HashSet<String>();
    private final PrefListener fPrefListener;
    private final MulticastChangeListener fChangeListeners = new MulticastChangeListener();

    PrefsWatcher(Target target) {
        String string = target.getPlugin().getXml();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}<>/\"' \t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("prefs") || !stringTokenizer.hasMoreTokens()) continue;
            this.fUsedPrefs.add(stringTokenizer.nextToken());
        }
        this.fPrefListener = new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                PrefsWatcher.this.regeneratePreferenceXml();
                PrefsWatcher.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        };
        for (String string3 : this.fUsedPrefs) {
            Prefs.addListener((PrefListener)this.fPrefListener, (String)string3);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public synchronized String getPreferenceXml() {
        if (this.fPreferenceXml == null) {
            this.regeneratePreferenceXml();
        }
        return this.fPreferenceXml;
    }

    private synchronized void regeneratePreferenceXml() {
        XmlWriter xmlWriter = XmlApi.getInstance().create("prefs");
        xmlWriter.writeText("prefdir", new Object[]{Prefs.getPropertyDirectory()});
        for (String string : this.fUsedPrefs) {
            xmlWriter.writeText(string, new Object[]{Prefs.getPref((String)string)});
        }
        this.fPreferenceXml = xmlWriter.getXML();
    }

    public Set<String> getUsedKeys() {
        return new HashSet<String>(this.fUsedPrefs);
    }

    public void destroy() {
        for (String string : this.fUsedPrefs) {
            Prefs.removeListener((PrefListener)this.fPrefListener, (String)string);
        }
    }
}

