/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.XslInput;

public final class PackageType
implements FilePatternFilter {
    private final String fKey;
    private final String fName;
    private final String fExtension;
    private final DynamicTargetAttribute fEnabled;

    public PackageType(String string, String string2, String string3, DynamicTargetAttribute dynamicTargetAttribute) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("The key cannot be null or empty");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("The name cannot be null or empty");
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("The extension cannot be null or empty");
        }
        this.fKey = string;
        this.fName = string2;
        this.fExtension = (!string3.startsWith(".") ? "." : "") + string3;
        this.fEnabled = dynamicTargetAttribute;
    }

    public String getKey() {
        return this.fKey;
    }

    public String getName() {
        return this.fName;
    }

    public String getExtension() {
        return this.fExtension;
    }

    public String getDescription() {
        return this.fName + " (*" + this.fExtension + ")";
    }

    public String[] getPatterns() {
        return new String[]{"*" + this.fExtension};
    }

    public boolean isEnabled(Project project) {
        return this.fEnabled == null || this.fEnabled.evaluateBoolean(new XslInput(project.getXslInput()));
    }
}

