/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.engine;

import com.mathworks.project.api.Command;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.engine.CommandStatusImpl;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.util.RequestFilter;
import java.util.ArrayList;
import java.util.List;

final class DeploymentProcessImpl
implements DeploymentProcess {
    private final Configuration fConfiguration;
    private final Object fCancelLock;
    private final Object fMonitorListLock;
    private final List<DeploymentProcessMonitor> fMonitors;
    private final RequestFilter fCancelRequestor;
    private final SubProcessType fInitialSubProcessType;
    private Thread fThread;
    private SubProcessType fCurrentSubProcessType;
    private boolean fStarted;
    private boolean fCancelRequested;
    private Command fCurrentCommand;

    DeploymentProcessImpl(Configuration configuration, SubProcessType subProcessType) {
        this.fCurrentSubProcessType = subProcessType;
        this.fInitialSubProcessType = subProcessType;
        this.fConfiguration = configuration;
        this.fCancelLock = new Object();
        this.fMonitorListLock = new Object();
        this.fMonitors = new ArrayList<DeploymentProcessMonitor>();
        this.fCancelRequestor = new RequestFilter(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = DeploymentProcessImpl.this.fCancelLock;
                synchronized (object) {
                    DeploymentProcessImpl.this.fCancelRequested = true;
                    if (DeploymentProcessImpl.this.fCurrentCommand != null) {
                        DeploymentProcessImpl.this.fCurrentCommand.cancel();
                    }
                }
            }
        });
    }

    void setCurrentSubProcessType(SubProcessType subProcessType) {
        this.fCurrentSubProcessType = subProcessType;
    }

    public SubProcessType getCurrentSubProcessType() {
        return this.fCurrentSubProcessType;
    }

    synchronized void setThread(Thread thread) {
        this.fThread = thread;
    }

    public synchronized void start() {
        assert (this.fThread != null);
        assert (!this.fThread.equals(Thread.currentThread()));
        if (!this.fStarted) {
            this.fStarted = true;
            this.fThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CommandStatusImpl setCurrentCommand(Command command) {
        Object object = this.fCancelLock;
        synchronized (object) {
            this.fCurrentCommand = command;
            for (DeploymentProcessMonitor deploymentProcessMonitor : this.getMonitors()) {
                deploymentProcessMonitor.commandStarted(command.toString());
            }
            return new CommandStatusImpl(command, this);
        }
    }

    public Configuration getConfiguration() {
        return this.fConfiguration;
    }

    public SubProcessType getInitialSubProcessType() {
        return this.fInitialSubProcessType;
    }

    public void cancel() {
        this.fCancelRequestor.request();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCancelRequested() {
        Object object = this.fCancelLock;
        synchronized (object) {
            return this.fCancelRequested;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(DeploymentProcessMonitor deploymentProcessMonitor) {
        Object object = this.fMonitorListLock;
        synchronized (object) {
            this.fMonitors.add(deploymentProcessMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitor(DeploymentProcessMonitor deploymentProcessMonitor) {
        Object object = this.fMonitorListLock;
        synchronized (object) {
            this.fMonitors.remove(deploymentProcessMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DeploymentProcessMonitor> getMonitors() {
        Object object = this.fMonitorListLock;
        synchronized (object) {
            return new ArrayList<DeploymentProcessMonitor>(this.fMonitors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireOutputLine(Command command, String string) {
        Object object = this.fCancelLock;
        synchronized (object) {
            if (command.equals(this.fCurrentCommand)) {
                for (DeploymentProcessMonitor deploymentProcessMonitor : this.getMonitors()) {
                    deploymentProcessMonitor.commandOutput(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireErrorLine(Command command, String string) {
        Object object = this.fCancelLock;
        synchronized (object) {
            if (command.equals(this.fCurrentCommand)) {
                for (DeploymentProcessMonitor deploymentProcessMonitor : this.getMonitors()) {
                    deploymentProcessMonitor.commandError(string);
                }
            }
        }
    }
}

