/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.InvalidProjectException;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DeployToolTestUtils;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.DeploymentProcessAction;
import com.mathworks.project.impl.desktop.ProjectClient;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.PackageType;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.util.Predicate;
import com.mathworks.util.ReturnRunnable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;

public class PackageAction
extends DeploymentProcessAction {
    private final ReturnRunnable<Component> fBuildPromptParent;
    public static final String KEY = "PACKAGE";

    public PackageAction(ProjectClient projectClient, ReturnRunnable<Component> returnRunnable) {
        super(projectClient, KEY, (Icon)DocumentIcon.PACKAGE.getIcon());
        this.fBuildPromptParent = returnRunnable;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MJFileChooserPerPlatform mJFileChooserPerPlatform;
        Project project = ProjectGUI.getInstance().getCurrentProject();
        if (project == null) {
            return;
        }
        ProjectManager.waitForSave(project);
        Configuration configuration = project.getConfiguration();
        List<PackageType> list = configuration.getTarget().getSupportedPackageTypes(project);
        assert (!list.isEmpty());
        Object object = null;
        PackageType packageType = null;
        if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
            mJFileChooserPerPlatform = DeployToolTestUtils.showSimpleFileChooser();
            if (mJFileChooserPerPlatform == null) {
                return;
            }
            if (((MJFileChooserPerPlatform)mJFileChooserPerPlatform).length != 1) {
                throw new IllegalStateException("Only one file can be chosen here");
            }
            object = mJFileChooserPerPlatform[0];
            for (PackageType packageType2 : list) {
                if (!object.getName().toLowerCase(Locale.ENGLISH).endsWith(packageType2.getExtension().toLowerCase(Locale.ENGLISH))) continue;
                packageType = packageType2;
            }
            if (packageType == null) {
                throw new IllegalStateException("Extension must match a supported package type");
            }
        } else {
            mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
            File file = configuration.getPreferredPackageLocation();
            if (file == null) {
                file = new File(MatlabPath.getCWD());
            }
            if ((packageType = configuration.getPreferredPackageType()) == null) {
                packageType = list.iterator().next();
            }
            File file2 = new File(file, configuration.getName() + "_pkg");
            mJFileChooserPerPlatform.setCurrentDirectory(file);
            mJFileChooserPerPlatform.setSelectedFile(file2);
            mJFileChooserPerPlatform.setDialogTitle(BuiltInResources.getString("package.choose.title"));
            mJFileChooserPerPlatform.setAcceptAllFileFilterUsed(false);
            mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)packageType);
            for (PackageType packageType3 : list) {
                if (packageType3.equals(packageType)) continue;
                mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)packageType3);
            }
            mJFileChooserPerPlatform.showSaveDialog((Component)this.getClient().getComponent());
            if (mJFileChooserPerPlatform.getState() == 0) {
                object = mJFileChooserPerPlatform.getSelectedFile();
                packageType = (PackageType)mJFileChooserPerPlatform.getFileFilter();
            }
        }
        if (object != null && packageType != null) {
            if (!object.getName().toLowerCase(Locale.ENGLISH).endsWith(packageType.getExtension().toLowerCase(Locale.ENGLISH))) {
                object = new File(object.getParentFile(), object.getName() + packageType.getExtension());
            }
            configuration.setPreferredPackageLocation(object.getParentFile());
            configuration.setPreferredPackageType(packageType);
            try {
                mJFileChooserPerPlatform = DeploymentEngine.createPackageProcess(project, packageType, (File)object, new Predicate<Project>(){

                    public boolean accept(Project project) {
                        return MJOptionPane.showConfirmDialog((Component)((Component)PackageAction.this.fBuildPromptParent.run()), (Object)BuiltInResources.getString("build.outdated.prompt"), (String)BuiltInResources.getString("build.outdated.title"), (int)0, (int)2) == 0;
                    }
                });
                ProjectManager.waitForSave(project);
                this.start((DeploymentProcess)mJFileChooserPerPlatform);
            }
            catch (InvalidProjectException invalidProjectException) {
                this.displayValidationError(invalidProjectException);
            }
        }
    }

    public void startPackage() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PackageAction.this.actionPerformed(null);
            }
        });
    }

    @Override
    public boolean isApplicable(Project project) {
        return project != null && project.getConfiguration().getTarget().getPackageScript() != null && project.getConfiguration().isPackageEnabled();
    }
}

