/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.cert.CertificateParsingException;
import ice.cert.X500Name;
import ice.debug.Debug;
import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.SSLSocket;
import ice.ssl.ServerHandshake;
import ice.ssl.SessionState;
import java.util.Hashtable;

final class CertificateRequest
extends ServerHandshake {
    private static Hashtable OEAB = new Hashtable();
    private static final int[] Z = new int[]{14};
    static final int RSA_SIGN = 1;
    static final int DSS_SIGN = 2;
    static final int RSA_FIXED_DH = 3;
    static final int DSS_FIXED_DH = 4;
    static final int RSA_EPHEMERAL_DH = 5;
    static final int DSS_EPHEMERAL_DH = 6;

    CertificateRequest(SSLSocket sSLSocket, SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        block6: {
            super(sSLSocket, sessionState, connectionState, handshakeState);
            handshakeState.askedCert = true;
            int n = handshakeState.offset;
            int n2 = handshakeState.data[n++] & 0xFF;
            byte[] byArray = new byte[n2];
            System.arraycopy(handshakeState.data, n, byArray, 0, n2);
            n += n2;
            n2 = (handshakeState.data[n++] & 0xFF) << 8;
            byte[] byArray2 = new byte[n2 += handshakeState.data[n++] & 0xFF];
            System.arraycopy(handshakeState.data, n, byArray2, 0, n2);
            n += n2;
            try {
                handshakeState.acceptedIssuers = X500Name.parseNames(byArray2);
            }
            catch (CertificateParsingException certificateParsingException) {
                if (!Debug.ex) break block6;
                Debug.ex((Throwable)certificateParsingException);
            }
        }
        Object var9_10 = null;
        if (sSLSocket.getCertificateManager() != null) {
            handshakeState.clientCertificateChain = sSLSocket.getCertificateManager().selectName(handshakeState.acceptedIssuers);
            if (handshakeState.clientCertificateChain != null) {
                handshakeState.clientCertificate = handshakeState.clientCertificateChain[0];
            }
        }
        if (handshakeState.clientCertificate == null && SSLSocket.getCertificateCallback() != null) {
            handshakeState.clientCertificateChain = SSLSocket.getCertificateCallback().selectName(handshakeState.acceptedIssuers);
            if (handshakeState.clientCertificateChain != null) {
                handshakeState.clientCertificate = handshakeState.clientCertificateChain[0];
            }
        }
        handshakeState.next = Z;
        handshakeState.offset += this.length - 4;
    }
}

