/*
 * Decompiled with CFR 0.152.
 */
package ice.cert;

import ice.cert.OID;
import java.math.BigInteger;
import java.util.Date;

class DERValue {
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 1;
    public static final int CONTEXT_SPECIFIC = 2;
    public static final int PRIVATE = 3;
    public static final int UNSUPPORTED = -1;
    public static final int SPECIFIC = 0;
    public static final int SEQUENCE = 1;
    public static final int SET = 2;
    public static final int OID = 3;
    public static final int BIT_STRING = 4;
    public static final int OCTET_STRING = 5;
    public static final int STRING = 6;
    public static final int INTEGER = 7;
    public static final int DATE = 8;
    public static final int NULL = 9;
    public static final int BOOLEAN = 10;
    private int OEAB;
    private int append;
    private int equals;
    private int getClass;
    byte[] byteArray;
    OID oid;
    BigInteger bigInteger;
    Date date;
    String string;
    boolean bool = false;

    DERValue() {
    }

    public void setData(byte[] byArray) {
        this.byteArray = byArray;
    }

    public void setData(OID oID) {
        this.oid = oID;
    }

    public void setData(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }

    public void setData(String string) {
        this.string = string;
    }

    public void setData(Date date) {
        this.date = date;
    }

    public void setData(boolean bl) {
        this.bool = bl;
    }

    public Object getData() {
        switch (this.append) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                return this.byteArray;
            }
            case 3: {
                return this.oid;
            }
            case 6: {
                return this.string;
            }
            case 4: 
            case 7: {
                return this.bigInteger;
            }
            case 8: {
                return this.date;
            }
            case 9: {
                return null;
            }
            case 10: {
                return new Boolean(this.bool);
            }
        }
        return null;
    }

    public void setDerClass(int n) {
        this.equals = n;
    }

    public int getDerClass() {
        return this.equals;
    }

    public String getDerClassName() {
        return DERValue.getDerClassName(this.equals);
    }

    public static String getDerClassName(int n) {
        if (n == 0) {
            return "universal";
        }
        if (n == 1) {
            return "application";
        }
        if (n == 2) {
            return "context specific";
        }
        if (n == 3) {
            return "private";
        }
        return null;
    }

    public void setTagNumber(int n) {
        this.OEAB = n;
    }

    public int getTagNumber() {
        return this.OEAB;
    }

    public void setTag(int n) {
        this.append = n;
    }

    public int getTag() {
        return this.append;
    }

    public String getTagName() {
        return DERValue.getTagName(this.append);
    }

    public static String getTagName(int n) {
        switch (n) {
            case 1: {
                return "Sequence";
            }
            case 2: {
                return "Set";
            }
            case 3: {
                return "ObjectIdentifier";
            }
            case 6: {
                return "String";
            }
            case 4: {
                return "BitString";
            }
            case 5: {
                return "OctetString";
            }
            case 7: {
                return "Integer";
            }
            case 8: {
                return "Date";
            }
            case 9: {
                return "Null";
            }
            case 10: {
                return "Boolean";
            }
            case 0: {
                return "Specific";
            }
            case -1: {
                return "Unsupported";
            }
        }
        return "Unknown";
    }

    public void setLength(int n) {
        this.getClass = n;
    }

    public int getLength() {
        return this.getClass;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof DERValue)) {
            return false;
        }
        DERValue dERValue = (DERValue)object;
        if (this.OEAB != dERValue.OEAB || this.equals != dERValue.equals) {
            return false;
        }
        if (this.getClass != dERValue.getClass) {
            return false;
        }
        switch (this.append) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                if (this.byteArray.length != dERValue.byteArray.length) {
                    return false;
                }
                int n = 0;
                while (n < this.byteArray.length) {
                    if (this.byteArray[n] != dERValue.byteArray[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            case 3: {
                return this.oid.equals(dERValue.oid);
            }
            case 6: {
                return this.string.equals(dERValue.string);
            }
            case 4: 
            case 7: {
                return this.bigInteger.equals(dERValue.bigInteger);
            }
            case 8: {
                return this.date.equals(dERValue.date);
            }
            case 9: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[tag=" + this.getTagName() + "(" + this.getTagNumber() + ");class=" + this.getDerClassName() + "(" + this.getDerClass() + ");length=" + this.getLength() + ";data=" + this.getData() + "]";
    }
}

