/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.panels;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabException;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang.ArrayUtils;

public class TicksDialog
extends MJPanel {
    private static final int FIRST_COL_WIDTH = 150;
    private Object[] fAxesObjects;
    private MJTabbedPane fTabbedPane;
    private AxisTickPanel xAxisPanel;
    private AxisTickPanel yAxisPanel;
    private AxisTickPanel zAxisPanel;
    private MJDialog fDialog;
    private JButton fOKBtn;
    private final TickDataStruct[] fTickData = new TickDataStruct[]{new TickDataStruct(), new TickDataStruct(), new TickDataStruct()};

    public TicksDialog() {
        this.setName("TicksDialog");
        this.xAxisPanel = new AxisTickPanel("X");
        this.yAxisPanel = new AxisTickPanel("Y");
        this.zAxisPanel = new AxisTickPanel("Z");
        this.fTabbedPane = new MJTabbedPane();
        this.fTabbedPane.addTab(MessageFormat.format(PropertyEditorResources.getBundle().getString("label.axis"), "X"), (Component)((Object)this.xAxisPanel));
        this.fTabbedPane.addTab(MessageFormat.format(PropertyEditorResources.getBundle().getString("label.axis"), "Y"), (Component)((Object)this.yAxisPanel));
        this.fTabbedPane.addTab(MessageFormat.format(PropertyEditorResources.getBundle().getString("label.axis"), "Z"), (Component)((Object)this.zAxisPanel));
        MJPanel mJPanel = this.createBtnPanel();
        this.setLayout(new BorderLayout());
        this.fTabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.add((Component)this.fTabbedPane, "Center");
        this.add((Component)mJPanel, "South");
    }

    public void setObjects(Object object) {
        this.fAxesObjects = (Object[])object;
    }

    public void launch(String string) {
        if (this.fDialog == null) {
            this.fDialog = new MJDialog((Frame)null, true);
            this.fDialog.setTitle(PropertyEditorResources.getBundle().getString("TicksDialog.title"));
            this.fDialog.setCloseOnEscapeEnabled(true);
            this.fDialog.getRootPane().setDefaultButton(this.fOKBtn);
            this.fDialog.getContentPane().add((Component)((Object)this), "Center");
            this.fDialog.pack();
        }
        AxisTickPanel axisTickPanel = this.xAxisPanel;
        if (string.startsWith("X")) {
            axisTickPanel = this.xAxisPanel;
        } else if (string.startsWith("Y")) {
            axisTickPanel = this.yAxisPanel;
        } else if (string.startsWith("Z")) {
            axisTickPanel = this.zAxisPanel;
        }
        this.fTabbedPane.setSelectedComponent((Component)((Object)axisTickPanel));
        this.update();
        this.fDialog.show();
    }

    public void update() {
        if (this.fAxesObjects.length == 0) {
            return;
        }
        final Object object = this.fAxesObjects[0];
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 3; ++i) {
                        String string = "";
                        switch (i) {
                            case 0: {
                                string = "x";
                                break;
                            }
                            case 1: {
                                string = "y";
                                break;
                            }
                            case 2: {
                                string = "z";
                            }
                        }
                        Object object2 = TicksDialog.this.getPropertyValue(object, string + "Lim");
                        ((TicksDialog)TicksDialog.this).fTickData[i].axesMin = ((double[])object2)[0];
                        ((TicksDialog)TicksDialog.this).fTickData[i].axesMax = ((double[])object2)[1];
                        object2 = TicksDialog.this.getPropertyValue(object, string + "TickMode");
                        ((TicksDialog)TicksDialog.this).fTickData[i].tickLocationAuto = "auto".equals(object2);
                        object2 = TicksDialog.this.getPropertyValue(object, string + "Tick");
                        double[] dArray = (double[])object2;
                        ((TicksDialog)TicksDialog.this).fTickData[i].tickLocations = new Vector(dArray.length);
                        for (int j = 0; j < dArray.length; ++j) {
                            ((TicksDialog)TicksDialog.this).fTickData[i].tickLocations.add(dArray[j]);
                        }
                        if (((TicksDialog)TicksDialog.this).fTickData[i].tickLocationAuto) {
                            ((TicksDialog)TicksDialog.this).fTickData[i].autoTickLocations = dArray;
                        } else {
                            TicksDialog.this.setPropertyValue(object, string + "TickMode", "auto");
                            double[] dArray2 = (double[])TicksDialog.this.getPropertyValue(object, string + "Tick");
                            TicksDialog.this.setPropertyValue(object, string + "Tick", dArray);
                            ((TicksDialog)TicksDialog.this).fTickData[i].autoTickLocations = dArray2;
                        }
                        object2 = TicksDialog.this.getPropertyValue(object, string + "TickLabelMode");
                        ((TicksDialog)TicksDialog.this).fTickData[i].tickLabelAuto = "auto".equals(object2);
                        object2 = TicksDialog.this.getPropertyValue(object, string + "TickLabel");
                        if (object2 instanceof String && ((String)object2).length() > 0) {
                            String string2 = (String)object2;
                            String[] stringArray = new String[string2.length()];
                            for (int j = 0; j < string2.length(); ++j) {
                                stringArray[j] = String.valueOf(string2.charAt(j));
                            }
                            object2 = stringArray;
                        }
                        if (((TicksDialog)TicksDialog.this).fTickData[i].tickLabelAuto) {
                            ((TicksDialog)TicksDialog.this).fTickData[i].tickLabels = LabelFormatter.createAutoTickLabels(((TicksDialog)TicksDialog.this).fTickData[i].tickLocations);
                        } else if (!(object2 instanceof String[])) {
                            ((TicksDialog)TicksDialog.this).fTickData[i].tickLabels = new Vector(0);
                        } else {
                            String[] stringArray = object2;
                            ((TicksDialog)TicksDialog.this).fTickData[i].tickLabels = new Vector(stringArray.length);
                            for (String string3 : stringArray) {
                                ((TicksDialog)TicksDialog.this).fTickData[i].tickLabels.add(string3);
                            }
                        }
                        object2 = TicksDialog.this.getPropertyValue(object, string + "MinorTick");
                        ((TicksDialog)TicksDialog.this).fTickData[i].showMinorTicks = "on".equals(object2);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TicksDialog.this.xAxisPanel.update(TicksDialog.this.fTickData[0]);
                            TicksDialog.this.yAxisPanel.update(TicksDialog.this.fTickData[1]);
                            TicksDialog.this.zAxisPanel.update(TicksDialog.this.fTickData[2]);
                            TicksDialog.this.revalidate();
                        }
                    });
                }
                catch (Exception exception) {
                    ErrorHandler.showJavaException("update() for the ticks dialog", exception);
                }
            }
        });
    }

    void commit(final boolean bl) {
        this.xAxisPanel.finishEditing();
        this.yAxisPanel.finishEditing();
        this.zAxisPanel.finishEditing();
        if (this.fAxesObjects.length == 0) {
            return;
        }
        final Object object = this.fAxesObjects[0];
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 3; ++i) {
                        int n;
                        Object[] objectArray;
                        String string = "";
                        switch (i) {
                            case 0: {
                                string = "x";
                                break;
                            }
                            case 1: {
                                string = "y";
                                break;
                            }
                            case 2: {
                                string = "z";
                            }
                        }
                        String string2 = ((TicksDialog)TicksDialog.this).fTickData[i].tickLocationAuto ? "auto" : "manual";
                        TicksDialog.this.setPropertyValue(object, string + "TickMode", string2);
                        if (string2.equals("manual")) {
                            objectArray = new double[((TicksDialog)TicksDialog.this).fTickData[i].tickLocations.size()];
                            for (n = 0; n < ((TicksDialog)TicksDialog.this).fTickData[i].tickLocations.size(); ++n) {
                                objectArray[n] = ((TicksDialog)TicksDialog.this).fTickData[i].tickLocations.get(n);
                                if (n <= 0 || !(objectArray[n] <= objectArray[n - 1])) continue;
                                throw new MatlabException(PropertyEditorResources.getBundle().getString("TicksDialog.monotonic"));
                            }
                            TicksDialog.this.setPropertyValue(object, string + "Tick", objectArray);
                        }
                        string2 = ((TicksDialog)TicksDialog.this).fTickData[i].tickLabelAuto ? "auto" : "manual";
                        TicksDialog.this.setPropertyValue(object, string + "TickLabelMode", string2);
                        if (string2.equals("manual")) {
                            objectArray = new String[((TicksDialog)TicksDialog.this).fTickData[i].tickLabels.size()];
                            for (n = 0; n < ((TicksDialog)TicksDialog.this).fTickData[i].tickLabels.size(); ++n) {
                                objectArray[n] = (double)((TicksDialog)TicksDialog.this).fTickData[i].tickLabels.get(n);
                            }
                            TicksDialog.this.setPropertyValue(object, string + "TickLabel", objectArray);
                        }
                        string2 = ((TicksDialog)TicksDialog.this).fTickData[i].showMinorTicks ? "on" : "off";
                        TicksDialog.this.setPropertyValue(object, string + "MinorTick", string2);
                    }
                    if (bl) {
                        TicksDialog.this.fDialog.hide();
                    }
                }
                catch (MatlabException matlabException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog((Component)TicksDialog.this.fDialog, matlabException.getMessage(), "MATLAB", 0);
                            TicksDialog.this.update();
                        }
                    });
                }
                catch (Exception exception) {
                    ErrorHandler.showJavaException("While committing the ticks dialog", exception);
                }
            }
        });
    }

    private Object getPropertyValue(Object object, String string) throws Exception {
        return Matlab.mtFeval((String)"get", (Object[])new Object[]{object, string}, (int)1);
    }

    private void setPropertyValue(Object object, String string, Object object2) throws Exception {
        Matlab.mtFeval((String)"set", (Object[])new Object[]{object, string, object2}, (int)0);
    }

    private MJPanel createBtnPanel() {
        this.fOKBtn = new MJButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.ok"));
        MJButton mJButton = new MJButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.apply"));
        MJButton mJButton2 = new MJButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.cancel"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(1, 3, 5, 5));
        mJPanel.add((Component)this.fOKBtn);
        mJPanel.add((Component)mJButton);
        mJPanel.add((Component)mJButton2);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel2.add((Component)mJPanel, (Object)"East");
        this.fOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicksDialog.this.commit(true);
            }
        });
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicksDialog.this.commit(false);
            }
        });
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicksDialog.this.xAxisPanel.cancelEditing();
                TicksDialog.this.yAxisPanel.cancelEditing();
                TicksDialog.this.zAxisPanel.cancelEditing();
                TicksDialog.this.fDialog.hide();
            }
        });
        return mJPanel2;
    }

    static class TickDataStruct {
        public boolean tickLocationAuto;
        public Vector<Double> tickLocations;
        public boolean tickLabelAuto;
        public Vector<String> tickLabels;
        public boolean showMinorTicks;
        public double axesMin;
        public double axesMax;
        public double[] autoTickLocations;

        TickDataStruct() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("tickLocationAuto = ");
            stringBuffer.append(this.tickLocationAuto);
            stringBuffer.append("\ntickLocations = ");
            stringBuffer.append(this.tickLocations);
            stringBuffer.append("\ntickLabelAuto = ");
            stringBuffer.append(this.tickLabelAuto);
            stringBuffer.append("\ntickLabels = ");
            stringBuffer.append(this.tickLabels);
            stringBuffer.append("\nshowMinorTicks = ");
            stringBuffer.append(this.showMinorTicks);
            return new String(stringBuffer);
        }
    }

    private static class LabelFormatter {
        private static NumberFormat sNumFormat = null;

        private LabelFormatter() {
        }

        public static NumberFormat getNumberFormat() {
            if (sNumFormat == null) {
                sNumFormat = NumberFormat.getInstance();
                sNumFormat.setMaximumFractionDigits(6);
            }
            return sNumFormat;
        }

        public static Vector<String> createAutoTickLabels(Vector vector) {
            Vector<String> vector2 = new Vector<String>(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                vector2.add(LabelFormatter.getNumberFormat().format(vector.get(i)));
            }
            return vector2;
        }

        public static String format(double d) {
            return LabelFormatter.getNumberFormat().format(d);
        }

        public static String format(long l) {
            return LabelFormatter.getNumberFormat().format(l);
        }
    }

    static class TickTableModel
    extends AbstractTableModel {
        private TickDataStruct fTDS = null;
        private JRadioButton fLocManual;
        private JRadioButton fLblManual;

        public TickTableModel(JRadioButton jRadioButton, JRadioButton jRadioButton2) {
            this.fLocManual = jRadioButton;
            this.fLblManual = jRadioButton2;
        }

        @Override
        public int getRowCount() {
            return this.fTDS == null ? 0 : this.fTDS.tickLocations.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (!(this.fTDS == null || n2 == 0 && n >= this.fTDS.tickLocations.size() || n2 == 1 && n >= this.fTDS.tickLabels.size())) {
                if (n2 == 0) {
                    object = this.fTDS.tickLocations.get(n);
                } else if (n2 == 1) {
                    object = this.fTDS.tickLabels.get(n);
                }
            }
            return object;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this.fTDS == null || object == null || object.equals(this.getValueAt(n, n2))) {
                return;
            }
            if (n2 == 0) {
                this.fLocManual.setSelected(true);
                this.fTDS.tickLocationAuto = false;
                if (n >= this.fTDS.tickLocations.size()) {
                    this.fTDS.tickLocations.add((Double)object);
                    this.fTDS.tickLabels.add("");
                    this.fireTableRowsInserted(n, n);
                } else {
                    this.fTDS.tickLocations.set(n, (Double)object);
                    if (this.fTDS.tickLabelAuto) {
                        this.fTDS.tickLabels.set(n, LabelFormatter.getNumberFormat().format(object));
                    }
                }
                if (this.fTDS.tickLabelAuto) {
                    this.fireTableCellUpdated(n, 1);
                }
            } else if (n2 == 1) {
                this.fLblManual.setSelected(true);
                this.fTDS.tickLabelAuto = false;
                if (n >= this.fTDS.tickLabels.size()) {
                    this.fTDS.tickLabels.add((String)object);
                    this.fTDS.tickLocations.add(this.fTDS.tickLocations.lastElement());
                    this.fireTableRowsInserted(n, n);
                } else {
                    this.fTDS.tickLabels.set(n, (String)object);
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Double.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Locations";
            }
            return "Labels";
        }

        public void setData(TickDataStruct tickDataStruct) {
            this.fTDS = tickDataStruct;
            this.fireTableRowsInserted(0, this.fTDS.tickLocations.size() - 1);
        }

        public void addNewRow() {
            if (this.fTDS.tickLocations.size() == 0) {
                this.fTDS.tickLocations.add(this.fTDS.axesMin);
            } else {
                this.fTDS.tickLocations.add(this.fTDS.tickLocations.lastElement());
            }
            this.fTDS.tickLabels.add("");
            this.fireTableRowsInserted(this.fTDS.tickLocations.size() - 1, this.fTDS.tickLocations.size() - 1);
        }

        public void insertNewRow(int n) {
            if (n == -1) {
                this.addNewRow();
                return;
            }
            if (n >= this.fTDS.tickLocations.size()) {
                return;
            }
            this.fTDS.tickLocations.insertElementAt(this.fTDS.tickLocations.get(n), n);
            this.fTDS.tickLabels.insertElementAt("", n);
            this.fTDS.tickLocationAuto = false;
            this.fTDS.tickLabelAuto = false;
            this.fLocManual.setSelected(true);
            this.fLblManual.setSelected(true);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteRow(int n) {
            if (n == -1 || n == this.fTDS.tickLocations.size()) {
                return;
            }
            this.fTDS.tickLocations.remove(n);
            if (n < this.fTDS.tickLabels.size()) {
                this.fTDS.tickLabels.remove(n);
            }
            this.fTDS.tickLocationAuto = false;
            this.fLocManual.setSelected(true);
            this.fireTableRowsDeleted(n, n);
        }

        public void setupLocationsAuto() {
            this.fTDS.tickLocationAuto = true;
            this.fTDS.tickLocations = new Vector(this.fTDS.autoTickLocations.length);
            for (int i = 0; i < this.fTDS.autoTickLocations.length; ++i) {
                this.fTDS.tickLocations.add(this.fTDS.autoTickLocations[i]);
            }
            if (this.fTDS.tickLabelAuto) {
                this.setupLabelsAuto();
            } else {
                this.fTDS.tickLabels.setSize(this.fTDS.tickLocations.size());
            }
            this.fireTableDataChanged();
        }

        public void setupLabelsAuto() {
            this.fTDS.tickLabelAuto = true;
            this.fTDS.tickLabels = LabelFormatter.createAutoTickLabels(this.fTDS.tickLocations);
            this.fireTableDataChanged();
        }

        public void setupLocationsManual() {
            this.fTDS.tickLocationAuto = false;
        }

        public void setupLabelsManual() {
            this.fTDS.tickLabelAuto = false;
        }

        public void setupLocationsByStep(double d) {
            this.fTDS.tickLocationAuto = false;
            Vector<Double> vector = new Vector<Double>();
            Vector<String> vector2 = new Vector<String>();
            for (double d2 = this.fTDS.axesMin; d2 < this.fTDS.axesMax; d2 += d) {
                vector.add(d2);
                if (!this.fTDS.tickLabelAuto) continue;
                vector2.add(LabelFormatter.getNumberFormat().format(d2));
            }
            vector.add(this.fTDS.axesMax);
            if (this.fTDS.tickLabelAuto) {
                vector2.add(LabelFormatter.getNumberFormat().format(this.fTDS.axesMax));
            }
            this.fTDS.tickLocations = vector;
            if (this.fTDS.tickLabelAuto) {
                this.fTDS.tickLabels = vector2;
            } else {
                this.fTDS.tickLabels.setSize(this.fTDS.tickLocations.size());
            }
            this.fireTableDataChanged();
        }
    }

    static class TickLocationCellEditor
    extends DefaultCellEditor {
        Class[] argTypes = new Class[]{String.class};
        Constructor constructor;
        Object value;
        Component hostComponent;

        public TickLocationCellEditor(Component component) {
            super(new JTextField());
            this.hostComponent = component;
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = string;
                }
                super.stopCellEditing();
            }
            if ("NaN".equals(string)) {
                return super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.hostComponent, PropertyEditorResources.getBundle().getString("TicksDialog.numeric"), "MATLAB", 0);
                super.stopCellEditing();
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> clazz = jTable.getColumnClass(n2);
                if (clazz == Object.class) {
                    clazz = String.class;
                }
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    class AxisTickPanel
    extends MJPanel {
        private String fAxis;
        private TickTableModel fTickTableModel;
        private TickDataStruct fTDS;
        private MJRadioButton locAuto = new MJRadioButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.auto"));
        private MJRadioButton locManual = new MJRadioButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.manual"));
        private MJRadioButton locStep = new MJRadioButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.stepby"));
        private MJRadioButton lblAuto = new MJRadioButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.auto"));
        private MJRadioButton lblManual = new MJRadioButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.manual"));
        private MJTextField stepByTF = new MJTextField();
        private MJCheckBox minorTicksCB = new MJCheckBox(PropertyEditorResources.getBundle().getString("TicksDialog.button.minorticks"));
        private final JTable table;
        private String fLastValidTickStep = null;
        private boolean fTickDialogShowing = false;

        public AxisTickPanel(String string) {
            this.fAxis = string;
            this.setName(string + "AxisTickPanel");
            String string2 = string;
            MJLabel mJLabel = new MJLabel(string2 + " " + PropertyEditorResources.getBundle().getString("TicksDialog.tickLocations"));
            MJLabel mJLabel2 = new MJLabel(string2 + " " + PropertyEditorResources.getBundle().getString("TicksDialog.tickLabels"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.locAuto);
            buttonGroup.add((AbstractButton)this.locManual);
            buttonGroup.add((AbstractButton)this.locStep);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add((AbstractButton)this.lblAuto);
            buttonGroup2.add((AbstractButton)this.lblManual);
            this.stepByTF.setColumns(5);
            this.stepByTF.setName(string + "StepTextField");
            this.table = this.createTable();
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MJRadioButton mJRadioButton = (MJRadioButton)actionEvent.getSource();
                    if (mJRadioButton == AxisTickPanel.this.locAuto) {
                        AxisTickPanel.this.fTickTableModel.setupLocationsAuto();
                    } else if (mJRadioButton == AxisTickPanel.this.locManual) {
                        AxisTickPanel.this.fTickTableModel.setupLocationsManual();
                    } else if (mJRadioButton == AxisTickPanel.this.locStep) {
                        AxisTickPanel.this.performStepBy();
                    } else if (mJRadioButton == AxisTickPanel.this.lblAuto) {
                        AxisTickPanel.this.fTickTableModel.setupLabelsAuto();
                    } else if (mJRadioButton == AxisTickPanel.this.lblManual) {
                        AxisTickPanel.this.fTickTableModel.setupLabelsManual();
                    }
                }
            };
            this.locAuto.addActionListener(actionListener);
            this.locManual.addActionListener(actionListener);
            this.locStep.addActionListener(actionListener);
            this.lblAuto.addActionListener(actionListener);
            this.lblManual.addActionListener(actionListener);
            this.stepByTF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AxisTickPanel.this.performStepBy();
                }
            });
            this.stepByTF.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    AxisTickPanel.this.performStepBy();
                }
            });
            this.minorTicksCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((AxisTickPanel)AxisTickPanel.this).fTDS.showMinorTicks = AxisTickPanel.this.minorTicksCB.isSelected();
                }
            });
            MJPanel mJPanel = new MJPanel();
            mJPanel.setLayout((LayoutManager)new BoxLayout((Container)mJPanel, 0));
            mJPanel.add((Component)this.locStep);
            mJPanel.add(Box.createHorizontalStrut(5));
            mJPanel.add((Component)this.stepByTF);
            MJPanel mJPanel2 = new MJPanel();
            mJPanel2.setLayout((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints.gridy = 0;
            mJPanel2.add((Component)mJLabel, (Object)gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 20, 0, 0);
            gridBagConstraints.gridy = 1;
            mJPanel2.add((Component)this.locAuto, (Object)gridBagConstraints);
            gridBagConstraints.gridy = 2;
            mJPanel2.add((Component)this.locManual, (Object)gridBagConstraints);
            gridBagConstraints.gridy = 3;
            mJPanel2.add((Component)mJPanel, (Object)gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 40, 5, 0);
            gridBagConstraints.gridy = 0;
            mJPanel2.add((Component)mJLabel2, (Object)gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 60, 0, 0);
            gridBagConstraints.gridy = 1;
            mJPanel2.add((Component)this.lblAuto, (Object)gridBagConstraints);
            gridBagConstraints.gridy = 2;
            mJPanel2.add((Component)this.lblManual, (Object)gridBagConstraints);
            MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel3.add((Component)mJPanel2, (Object)"West");
            MJScrollPane mJScrollPane = new MJScrollPane((Component)this.table);
            MJPanel mJPanel4 = this.createRowOpsPanel(this.table);
            MJPanel mJPanel5 = this.createHeaderPanel();
            MJPanel mJPanel6 = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel6.add((Component)mJScrollPane, (Object)"Center");
            mJPanel6.add((Component)mJPanel4, (Object)"East");
            mJPanel6.add((Component)mJPanel5, (Object)"North");
            mJPanel6.setPreferredSize(new Dimension(400, 250));
            mJPanel6.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)mJPanel3, "North");
            this.add((Component)mJPanel6, "Center");
            this.add((Component)this.minorTicksCB, "South");
            mJPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        }

        private void performStepBy() {
            if (this.stepByTF.getText().trim().length() > 0) {
                double d;
                try {
                    d = Double.parseDouble(this.stepByTF.getText());
                }
                catch (Exception exception) {
                    d = -1.0;
                }
                if (d > 0.0) {
                    this.fLastValidTickStep = this.stepByTF.getText();
                    this.fTickTableModel.setupLocationsByStep(d);
                    this.locStep.setSelected(true);
                } else if (!this.fTickDialogShowing) {
                    this.fTickDialogShowing = true;
                    ErrorHandler.showSimpleError(PropertyEditorResources.getBundle().getString("TicksDialog.error.badstep"), this.getTopLevelAncestor());
                    if (this.fLastValidTickStep == null) {
                        this.stepByTF.setText("");
                    } else {
                        this.stepByTF.setText(this.fLastValidTickStep);
                    }
                    this.fTickDialogShowing = false;
                }
            }
        }

        public void update(TickDataStruct tickDataStruct) {
            this.fTDS = tickDataStruct;
            this.locAuto.setSelected(tickDataStruct.tickLocationAuto);
            this.locManual.setSelected(!tickDataStruct.tickLocationAuto);
            this.locStep.setSelected(false);
            this.lblAuto.setSelected(tickDataStruct.tickLabelAuto);
            this.lblManual.setSelected(!tickDataStruct.tickLabelAuto);
            this.minorTicksCB.setSelected(tickDataStruct.showMinorTicks);
            this.table.getSelectionModel().clearSelection();
            this.fTickTableModel.setData(tickDataStruct);
        }

        public void finishEditing() {
            if (this.table.isEditing()) {
                TableCellEditor tableCellEditor = this.table.getCellEditor();
                tableCellEditor.stopCellEditing();
            }
        }

        public void cancelEditing() {
            if (this.table.isEditing()) {
                TableCellEditor tableCellEditor = this.table.getCellEditor();
                tableCellEditor.cancelCellEditing();
            }
        }

        private MJPanel createHeaderPanel() {
            MJLabel mJLabel = new MJLabel(PropertyEditorResources.getBundle().getString("TicksDialog.label.locations"), 4);
            mJLabel.setPreferredSize(new Dimension(145, mJLabel.getPreferredSize().height));
            MJLabel mJLabel2 = new MJLabel(PropertyEditorResources.getBundle().getString("TicksDialog.label.labels"));
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(20, 20));
            mJPanel.add((Component)mJLabel, (Object)"West");
            mJPanel.add((Component)mJLabel2, (Object)"Center");
            return mJPanel;
        }

        private MJPanel createRowOpsPanel(JTable jTable) {
            final MJButton mJButton = new MJButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.insert"));
            final MJButton mJButton2 = new MJButton(PropertyEditorResources.getBundle().getString("TicksDialog.button.delete"));
            final JTable jTable2 = jTable;
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = jTable2.getSelectedRow();
                    AxisTickPanel.this.finishEditing();
                    if (actionEvent.getSource() == mJButton) {
                        if (n == -1 || n == jTable2.getRowCount() - 1) {
                            AxisTickPanel.this.fTickTableModel.addNewRow();
                            int n2 = jTable2.getRowCount();
                            jTable2.setRowSelectionInterval(n2 - 1, n2 - 1);
                        } else {
                            AxisTickPanel.this.fTickTableModel.insertNewRow(n + 1);
                            jTable2.setRowSelectionInterval(n + 1, n + 1);
                        }
                    } else if (actionEvent.getSource() == mJButton2) {
                        if (n == -1) {
                            return;
                        }
                        AxisTickPanel.this.fTickTableModel.deleteRow(n);
                        int n3 = jTable2.getRowCount();
                        if (n3 == 0) {
                            return;
                        }
                        if (n >= n3) {
                            jTable2.setRowSelectionInterval(n - 1, n - 1);
                        } else {
                            jTable2.setRowSelectionInterval(n, n);
                        }
                    }
                }
            };
            mJButton.addActionListener(actionListener);
            mJButton2.addActionListener(actionListener);
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(2, 1, 5, 5));
            mJPanel.add((Component)mJButton);
            mJPanel.add((Component)mJButton2);
            MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            mJPanel2.add((Component)mJPanel, (Object)"North");
            return mJPanel2;
        }

        private JTable createTable() {
            this.fTickTableModel = new TickTableModel((JRadioButton)this.locManual, (JRadioButton)this.lblManual);
            MJTable mJTable = new MJTable((TableModel)this.fTickTableModel);
            mJTable.setName(this.fAxis + "TickTable");
            mJTable.setAutoResizeMode(3);
            mJTable.setSelectionMode(0);
            mJTable.setRowSelectionAllowed(true);
            mJTable.setColumnSelectionAllowed(true);
            mJTable.setCellSelectionEnabled(true);
            mJTable.setTableHeader(null);
            mJTable.setIntercellSpacing(new Dimension(20, 0));
            mJTable.setDefaultEditor(mJTable.getColumnClass(0), new TickLocationCellEditor((Component)mJTable));
            TableColumn tableColumn = mJTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(150);
            tableColumn.setMaxWidth(150);
            tableColumn.setResizable(false);
            KeyAdapter keyAdapter = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        TicksDialog.this.fDialog.getRootPane().getDefaultButton().doClick();
                    }
                }
            };
            ListSelectionListener listSelectionListener = new ListSelectionListener((JTable)mJTable, keyAdapter){
                final /* synthetic */ JTable val$table;
                final /* synthetic */ KeyListener val$enterLsnr;
                {
                    this.val$table = jTable;
                    this.val$enterLsnr = keyListener;
                }

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    int n = this.val$table.getSelectedRow();
                    int n2 = this.val$table.getSelectedColumn();
                    this.val$table.editCellAt(n, n2);
                    JTextField jTextField = (JTextField)this.val$table.getEditorComponent();
                    if (jTextField != null) {
                        jTextField.requestFocus();
                        jTextField.selectAll();
                        if (!ArrayUtils.contains((Object[])jTextField.getKeyListeners(), (Object)this.val$enterLsnr)) {
                            jTextField.addKeyListener(this.val$enterLsnr);
                        }
                    }
                }
            };
            mJTable.getSelectionModel().addListSelectionListener(listSelectionListener);
            mJTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
            return mJTable;
        }
    }
}

