/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.plaf;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MacAppearanceUtils;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.NativeMacObjC;
import com.mathworks.util.PlatformInfo;
import com.sun.java.swing.plaf.windows.WindowsTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.CompoundBorder;

public class PlafUtils {
    private static boolean sLookAndFeelAlreadySet = false;
    private static final int SIZE = 9;
    private static final int HALF_SIZE = 4;

    public static boolean isMotifLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
    }

    public static boolean isPlasticLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getName().equals("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
    }

    public static boolean isWindowsLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
    }

    public static boolean isMetalLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getName().equals("javax.swing.plaf.metal.MetalLookAndFeel");
    }

    public static boolean isAquaLookAndFeel() {
        return PlatformInfo.isMacintosh();
    }

    public static void correctPlatformLookAndFeel() {
        if (PlafUtils.isAquaLookAndFeel()) {
            PlafUtils.correctMacintoshLookAndFeel();
        } else if (PlafUtils.isWindowsLookAndFeel()) {
            PlafUtils.correctWindowsLookAndFeel();
        } else if (PlafUtils.isPlasticLookAndFeel()) {
            PlafUtils.correctPlasticLookAndFeel();
        }
    }

    public static void correctWindowsLookAndFeel() {
        PlafUtils.correctWindowsCaretBlinkRate();
        PlafUtils.correctWindowsFonts();
        PlafUtils.trackWindowsSystemColors();
        PlafUtils.updateTreeIcons();
        UIManager.put("TextField.disabledBackground", UIManager.getColor("control"));
        UIManager.put("TextField.inactiveBackground", UIManager.getColor("control"));
        UIManager.put("PopupMenu.consumeEventOnClose", false);
        if (PlatformInfo.isWindowsModernAppearance()) {
            PlafUtils.correctXPMenuBorders();
        }
        if (MJUtilities.isHighContrast()) {
            UIManager.put("Table.scrollPaneBorder", BorderFactory.createLineBorder((Color)UIManager.get("windowBorder"), 1));
        }
    }

    public static void correctPlasticLookAndFeel() {
        UIManager.put("MenuItem.acceleratorDelimiter", "+");
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        PlafUtils.updateTreeIcons();
        UIManager.put("CheckBox.icon", new CorrectedPlasticCheckBoxIcon(UIManager.getIcon("CheckBox.icon")));
    }

    public static void correctMacintoshLookAndFeel() {
        MacAppearanceUtils.initialize();
        String string = System.getProperty("apple.laf.useScreenMenuBar");
        boolean bl = PlatformInfo.getVersion() >= 7 && "true".equals(string);
        System.setProperty("apple.laf.useScreenMenuBar", bl ? "true" : "false");
        if (PlatformInfo.isMacintosh() && bl) {
            NativeMacObjC.setDefaultMenuBar();
        }
        System.setProperty("apple.awt.showGrowBox", "true");
    }

    public static void correctWindowsCaretBlinkRate() {
        Integer n = MJUtilities.getCaretBlinkRate();
        UIManager.put("TextField.caretBlinkRate", n);
        UIManager.put("FormattedTextField.caretBlinkRate", n);
        UIManager.put("PasswordField.caretBlinkRate", n);
        UIManager.put("TextArea.caretBlinkRate", n);
        UIManager.put("TextPane.caretBlinkRate", n);
        UIManager.put("EditorPane.caretBlinkRate", n);
    }

    public static void correctWindowsFonts() {
        Font font = FontUtils.getSystemUIFont();
        if (LanguageUtils.isCJK()) {
            UIManager.put("Menu.font", font);
            UIManager.put("MenuItem.font", font);
            UIManager.put("CheckBoxMenuItem.font", font);
            UIManager.put("RadioButtonMenuItem.font", font);
        }
        UIManager.getDefaults().put("Button.font", font);
        UIManager.getDefaults().put("CheckBox.font", font);
        UIManager.getDefaults().put("ComboBox.font", font);
        UIManager.getDefaults().put("EditorPane.font", font);
        UIManager.getDefaults().put("FormattedTextField.font", font);
        UIManager.getDefaults().put("Label.font", font);
        UIManager.getDefaults().put("List.font", font);
        UIManager.getDefaults().put("Panel.font", font);
        UIManager.getDefaults().put("ProgressBar.font", font);
        UIManager.getDefaults().put("RadioButton.font", font);
        UIManager.getDefaults().put("ScrollPane.font", font);
        UIManager.getDefaults().put("TabbedPane.font", font);
        UIManager.getDefaults().put("Table.font", font);
        UIManager.getDefaults().put("TableHeader.font", font);
        UIManager.getDefaults().put("TextField.font", font);
        UIManager.getDefaults().put("TextPane.font", font);
        UIManager.getDefaults().put("TitledBorder.font", font);
        UIManager.getDefaults().put("ToggleButton.font", font);
        UIManager.getDefaults().put("Tree.font", font);
        UIManager.getDefaults().put("Viewport.font", font);
    }

    public static void setLookAndFeel() {
        if (!sLookAndFeelAlreadySet) {
            try {
                if (PlatformInfo.isXWindows()) {
                    PlafUtils.setUnixLookAndFeel();
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                System.out.println("Look & Feel not supported.");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Look & Feel could not be accessed.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Look & Feel could not be found.");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Look & Feel could not be instantiated.");
            }
            PlafUtils.correctPlatformLookAndFeel();
            sLookAndFeelAlreadySet = true;
        }
    }

    private static void setUnixLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Options.setUseNarrowButtons((boolean)false);
        Plastic3DLookAndFeel.setPlasticTheme((PlasticTheme)((PlasticTheme)Class.forName("com.jgoodies.looks.plastic.theme.ExperienceRoyale").newInstance()));
        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
    }

    private static void correctXPMenuBorders() {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("controlShadow")), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        UIManager.put("PopupMenu.border", compoundBorder);
    }

    private static void trackWindowsSystemColors() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        SystemColorTracker systemColorTracker = new SystemColorTracker();
        toolkit.addPropertyChangeListener("win.3d.backgroundColor", systemColorTracker);
        toolkit.addPropertyChangeListener("win.3d.highlightColor", systemColorTracker);
        toolkit.addPropertyChangeListener("win.3d.lightColor", systemColorTracker);
        toolkit.addPropertyChangeListener("win.3d.shadowColor", systemColorTracker);
    }

    public static void updateTreeIcons() {
        UIManager.put("Tree.expandedIcon", (Object)new ContrastingExpandedIcon());
        UIManager.put("Tree.collapsedIcon", (Object)new ContrastingCollapsedIcon());
    }

    private PlafUtils() {
    }

    private static class ContrastingCollapsedIcon
    extends WindowsTreeUI.CollapsedIcon {
        private ContrastingCollapsedIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (PlatformInfo.isWindowsModernAppearance() || !ColorUtils.isDark(component.getBackground())) {
                super.paintIcon(component, graphics, n, n2);
            } else {
                graphics.setColor(component.getBackground());
                graphics.fillRect(n, n2, 8, 8);
                graphics.setColor(Color.gray);
                graphics.drawRect(n, n2, 8, 8);
                graphics.setColor(Color.white);
                graphics.drawLine(n + 2, n2 + 4, n + 6, n2 + 4);
                graphics.drawLine(n + 4, n2 + 2, n + 4, n2 + 6);
            }
        }
    }

    private static class ContrastingExpandedIcon
    extends WindowsTreeUI.ExpandedIcon {
        private ContrastingExpandedIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (PlatformInfo.isWindowsModernAppearance() || !ColorUtils.isDark(component.getBackground())) {
                super.paintIcon(component, graphics, n, n2);
            } else {
                graphics.setColor(component.getBackground());
                graphics.fillRect(n, n2, 8, 8);
                graphics.setColor(Color.gray);
                graphics.drawRect(n, n2, 8, 8);
                graphics.setColor(Color.white);
                graphics.drawLine(n + 2, n2 + 4, n + 6, n2 + 4);
            }
        }
    }

    private static class SystemColorTracker
    implements PropertyChangeListener {
        private SystemColorTracker() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("win.3d.backgroundColor")) {
                Color color = UIManager.getColor("control");
                SystemColor systemColor = SystemColor.control;
                if (color.getRGB() != systemColor.getRGB()) {
                    UIManager.put("control", systemColor);
                }
                color = UIManager.getColor("textText");
                systemColor = SystemColor.textText;
                if (color.getRGB() != systemColor.getRGB()) {
                    UIManager.put("textText", systemColor);
                }
                color = UIManager.getColor("textInactiveText");
                systemColor = SystemColor.textInactiveText;
                if (color.getRGB() != systemColor.getRGB()) {
                    UIManager.put("textInactiveText", systemColor);
                }
            } else if (string.equals("win.3d.highlightColor")) {
                Color color = UIManager.getColor("controlLtHighlight");
                SystemColor systemColor = SystemColor.controlLtHighlight;
                if (color.getRGB() != systemColor.getRGB()) {
                    UIManager.put("controlLtHighlight", systemColor);
                }
            } else if (string.equals("win.3d.lightColor")) {
                Color color = UIManager.getColor("controlHighlight");
                SystemColor systemColor = SystemColor.controlHighlight;
                if (color.getRGB() != systemColor.getRGB()) {
                    UIManager.put("controlHighlight", systemColor);
                }
            } else if (string.equals("win.3d.shadowColor")) {
                Color color = UIManager.getColor("controlShadow");
                SystemColor systemColor = SystemColor.controlShadow;
                if (color.getRGB() != systemColor.getRGB()) {
                    UIManager.put("controlShadow", systemColor);
                }
                color = UIManager.getColor("controlDkShadow");
                systemColor = SystemColor.controlDkShadow;
                if (color.getRGB() != systemColor.getRGB()) {
                    UIManager.put("controlDkShadow", systemColor);
                }
            }
        }
    }

    private static class CorrectedPlasticCheckBoxIcon
    implements Icon {
        private final Icon fIcon;

        private CorrectedPlasticCheckBoxIcon(Icon icon) {
            this.fIcon = icon;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Plastic3DLookAndFeel.getControl());
            graphics.fillRect(n, n2, 13, 13);
            this.fIcon.paintIcon(component, graphics, n, n2);
        }

        @Override
        public int getIconWidth() {
            return this.fIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.fIcon.getIconHeight();
        }
    }
}

