/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.datatransfer;

import com.mathworks.mwswing.datatransfer.MJTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class MJDataFlavor
extends DataFlavor {
    public static final DataFlavor RTF_FLAVOR = new DataFlavor("text/rtf", "Rich Formatted Text");
    public static final DataFlavor URI_DATA_FLAVOR = MJDataFlavor.createConstant("text/uri-list;class=java.lang.String", null);

    public static boolean isDecodableFileFlavor(Transferable transferable) {
        return transferable.isDataFlavorSupported(javaFileListFlavor) || transferable.isDataFlavorSupported(URI_DATA_FLAVOR);
    }

    public static boolean isDecodableFileFlavor(DropTargetDragEvent dropTargetDragEvent) {
        return dropTargetDragEvent != null && MJDataFlavor.isDecodableFileFlavor(dropTargetDragEvent.getTransferable());
    }

    public static boolean isDecodableFileFlavor(DropTargetDropEvent dropTargetDropEvent) {
        return dropTargetDropEvent != null && MJDataFlavor.isDecodableFileFlavor(dropTargetDropEvent.getTransferable());
    }

    public static File[] decodeJavaFileListFlavor(Transferable transferable) throws UnsupportedFlavorException, IOException, IllegalArgumentException {
        File[] fileArray;
        try {
            List<File> list;
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                list = (List<File>)transferable.getTransferData(javaFileListFlavor);
            } else if (transferable.isDataFlavorSupported(URI_DATA_FLAVOR)) {
                list = MJDataFlavor.textURIListToFileList((String)transferable.getTransferData(URI_DATA_FLAVOR));
            } else {
                throw new UnsupportedFlavorException(DataFlavor.javaFileListFlavor);
            }
            fileArray = new File[list.size()];
            int n = 0;
            for (File file : list) {
                fileArray[n++] = file;
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("An element in the flavor's data list does not satisfy the general contract of the DataFlavor.", classCastException);
        }
        return fileArray;
    }

    public static Transferable encodeJavaFileListFlavor(File[] fileArray) {
        return new MJTransferable(Arrays.asList(fileArray), javaFileListFlavor);
    }

    protected static DataFlavor createConstant(String string, String string2) {
        try {
            return new DataFlavor(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static List<File> textURIListToFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                URI uRI = new URI(string2);
                File file = new File(uRI);
                arrayList.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return arrayList;
    }
}

