/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.checkboxtree;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.checkboxtree.Selectable;
import com.mathworks.mwswing.checkboxtree.SelectionState;
import com.mathworks.mwswing.checkboxtree.TriStateButtonUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class CheckBoxTreeCellRenderer
implements TreeCellRenderer {
    static final String SELECTION_STATE_PROPERTY = "selectionState";
    private final JCheckBox fCheckBox;
    private final TreeCellRenderer fRenderer;
    private final JPanel fPanel;
    private boolean fEnabled;
    private boolean fProgrammaticSelection;

    public CheckBoxTreeCellRenderer() {
        this(new DefaultTreeCellRenderer());
    }

    public CheckBoxTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (treeCellRenderer == null) {
            throw new IllegalArgumentException("'renderer' cannot be null");
        }
        this.fRenderer = treeCellRenderer;
        this.fCheckBox = CheckBoxTreeCellRenderer.createCheckBox();
        this.fEnabled = true;
        this.fPanel = new JPanel(new BorderLayout());
        this.fPanel.add((Component)this.fCheckBox, "West");
        this.fPanel.setOpaque(false);
    }

    public void setShowDefaultIcons(boolean bl) {
        if (this.fRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.fRenderer;
            defaultTreeCellRenderer.setOpenIcon(bl ? defaultTreeCellRenderer.getDefaultOpenIcon() : null);
            defaultTreeCellRenderer.setClosedIcon(bl ? defaultTreeCellRenderer.getDefaultClosedIcon() : null);
            defaultTreeCellRenderer.setLeafIcon(bl ? defaultTreeCellRenderer.getDefaultLeafIcon() : null);
            this.fPanel.revalidate();
        }
    }

    public void setEnabled(boolean bl) {
        this.fEnabled = bl;
    }

    public boolean isSelected() {
        return this.fCheckBox.isSelected();
    }

    public boolean isProgrammaticSelection() {
        return this.fProgrammaticSelection;
    }

    public void addItemListener(ItemListener itemListener) {
        this.fCheckBox.addItemListener(itemListener);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component;
        if (object instanceof Selectable) {
            this.update(jTree, (Selectable)object);
            component = this.fPanel;
            Component component2 = this.fRenderer.getTreeCellRendererComponent(jTree, object, bl || bl4, bl2, bl3, n, bl4);
            this.fPanel.add(component2, "Center");
            if (this.fRenderer instanceof Component) {
                this.fCheckBox.setEnabled(this.fEnabled && ((Component)((Object)this.fRenderer)).isEnabled());
            }
        } else {
            component = this.fRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
        return component;
    }

    public void updateClientProperty(SelectionState selectionState) {
        this.fCheckBox.putClientProperty(SELECTION_STATE_PROPERTY, selectionState);
    }

    protected TreeCellRenderer getDelegate() {
        return this.fRenderer;
    }

    private void update(JTree jTree, Selectable selectable) {
        this.updateClientProperty(selectable.getSelectionState());
        this.fProgrammaticSelection = true;
        this.fCheckBox.setSelected(selectable.getSelectionState() == SelectionState.SELECTED || selectable.getSelectionState() == SelectionState.MIXED);
        this.fProgrammaticSelection = false;
        this.fCheckBox.setEnabled(jTree.isEnabled() && this.fEnabled);
        this.fCheckBox.setForeground(jTree.getForeground());
        this.fCheckBox.setBackground(jTree.getBackground());
        this.fCheckBox.setFont(jTree.getFont());
        if (this.fRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.fRenderer;
            defaultTreeCellRenderer.setForeground(jTree.getForeground());
            defaultTreeCellRenderer.setBackgroundNonSelectionColor(jTree.getBackground());
            defaultTreeCellRenderer.setFont(jTree.getFont());
        }
    }

    private static MJCheckBox createCheckBox() {
        MJCheckBox mJCheckBox = new MJCheckBox();
        mJCheckBox.setUI(new TriStateButtonUI(mJCheckBox.getUI()));
        mJCheckBox.setRequestFocusEnabled(false);
        return mJCheckBox;
    }
}

