/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.util.Log;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;

public class TextComponentUtils {
    private static final String MATLAB_IDENTIFIER_REGEXP = "[A-Za-z][A-Za-z0-9_]*";
    private static final String MATLAB_IDENTIFIERS_WITH_PERIODS_REGEXP = "([A-Za-z][A-Za-z0-9_]*\\.[A-Za-z][A-Za-z0-9_]*)*";

    private TextComponentUtils() {
    }

    public static String getIdentifierAtCaret(JTextComponent jTextComponent, boolean bl) {
        if (jTextComponent == null) {
            throw new IllegalArgumentException("'text' cannot be null");
        }
        return TextComponentUtils.getIdentifierAt(jTextComponent, jTextComponent.getCaretPosition(), bl);
    }

    public static String getFunctionAtCaret(JTextComponent jTextComponent, boolean bl) {
        Validate.notNull((Object)jTextComponent, (String)"The given TextComponent cannot be null.");
        return TextComponentUtils.getFunctionAt(jTextComponent.getDocument(), jTextComponent.getCaretPosition(), bl);
    }

    public static String getFunctionAt(JTextComponent jTextComponent, int n, boolean bl) {
        return TextComponentUtils.getFunctionAt(jTextComponent.getDocument(), n, bl);
    }

    public static String getFunctionAt(Document document, int n, boolean bl) {
        try {
            String string = null;
            if (n == 0 || TextComponentUtils.isIdentifierChar(document.getText(n, 1).charAt(0))) {
                string = TextComponentUtils.getIdentifierAt(document, n, bl);
            } else {
                for (int i = n - 1; i >= 0; --i) {
                    char c = document.getText(i, 1).charAt(0);
                    if ((Character.isWhitespace(c) || c == '(') && c != '\n') continue;
                    string = TextComponentUtils.getIdentifierAt(document, i + 1, bl);
                    break;
                }
            }
            return string;
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return null;
        }
    }

    public static String getIdentifierAt(JTextComponent jTextComponent, int n, boolean bl) {
        return TextComponentUtils.getIdentifierAt(jTextComponent.getDocument(), n, bl);
    }

    public static String getIdentifierAt(Document document, int n, boolean bl) {
        FullIdentifier fullIdentifier = TextComponentUtils.getFullIdentifierAt(document, n, bl);
        return fullIdentifier != null ? fullIdentifier.getIdentifier() : null;
    }

    public static FullIdentifier getFullIdentifierAt(Document document, int n, boolean bl) {
        Validate.notNull((Object)document, (String)"The given Document cannot be null.");
        try {
            String string;
            String string2;
            int n2;
            int n3;
            int n4 = n;
            boolean bl2 = false;
            for (n3 = n - 1; n3 >= 0; --n3) {
                n2 = document.getText(n3, 1).charAt(0);
                if (n2 == 46 && bl && !bl2) {
                    bl2 = true;
                    continue;
                }
                if (!TextComponentUtils.isIdentifierChar((char)n2)) break;
                bl2 = false;
                n4 = n3;
            }
            n3 = n;
            for (n2 = n; n2 < document.getLength(); ++n2) {
                char c = document.getText(n2, 1).charAt(0);
                if (c == '.' && bl && !bl2) {
                    bl2 = true;
                    continue;
                }
                if (!TextComponentUtils.isIdentifierChar(c)) break;
                bl2 = false;
                n3 = n2 + 1;
            }
            String string3 = string2 = (string = document.getText(n4, n3 - n4).trim().replaceAll("^\\.", "").replaceAll("\\.$", "")).length() > 0 && (string.matches(MATLAB_IDENTIFIER_REGEXP) || bl && string.matches(MATLAB_IDENTIFIERS_WITH_PERIODS_REGEXP)) ? string : null;
            if (string2 != null) {
                return new FullIdentifier(string2, n4);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return new FullIdentifier(null, -1);
    }

    private static boolean isIdentifierChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static class FullIdentifier {
        private final String fIdentifier;
        private final int fStartPosition;

        public FullIdentifier(String string, int n) {
            this.fIdentifier = string;
            this.fStartPosition = n;
        }

        public String getIdentifier() {
            return this.fIdentifier;
        }

        public int getStartPosition() {
            return this.fStartPosition;
        }
    }
}

