/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ScreenInformationProvider;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;

public class SystemGraphicsEnvironment
implements ScreenInformationProvider {
    private static final ScreenInformationProvider INSTANCE = new SystemGraphicsEnvironment();

    private SystemGraphicsEnvironment() {
    }

    @Override
    public GraphicsDevice[] getScreenDevices() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
    }

    @Override
    public GraphicsDevice getDefaultScreenDevice() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    @Override
    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
    }

    @Override
    public int getActiveTitleBarHeight() {
        Integer n = 25;
        if (PlatformInfo.isWindows()) {
            n = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.captionHeight");
        }
        return n;
    }

    @Override
    public Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static ScreenInformationProvider getInstance() {
        return INSTANCE;
    }
}

