/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MouseWheelRedirector;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.util.PlatformInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;

public class MJStartupForDesktop {
    private static final boolean WARN_ABOUT_LOOK_AND_FEEL_CHANGE = "true".equals(System.getProperty("mathworks.WarnAboutLookAndFeelChange"));
    private static boolean sInitialized = false;

    private MJStartupForDesktop() {
    }

    static void init() {
        if (sInitialized) {
            return;
        }
        if (PlatformInfo.isWindows()) {
            MouseWheelRedirector.setEnabled(true);
        }
        PlafUtils.setLookAndFeel();
        MJStartupForDesktop.warnAboutLookAndFeelChanging();
        sInitialized = true;
    }

    private static void warnAboutLookAndFeelChanging() {
        if (WARN_ABOUT_LOOK_AND_FEEL_CHANGE) {
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                        new RuntimeException("The Swing Look and Feel should not be changed").printStackTrace();
                    }
                }
            });
        }
    }

    static {
        MJStartupForDesktop.init();
    }
}

