/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Icon;
import javax.swing.JLabel;

public class MJLabel
extends JLabel {
    private boolean fTreatAmpersandAsMnemonic = true;
    private String fTextWithMnemonic;
    private boolean fIsArmed;
    private ComponentListener fTruncationListener;
    private boolean fHasBeenInitialized = true;

    public MJLabel() {
        this.addSafetyListener();
    }

    public MJLabel(Icon icon) {
        super(icon);
        this.addSafetyListener();
    }

    public MJLabel(Icon icon, int n) {
        super(icon, n);
        this.addSafetyListener();
    }

    public MJLabel(String string) {
        this(string, true);
    }

    public MJLabel(String string, boolean bl) {
        this.fTreatAmpersandAsMnemonic = bl;
        this.setText(string, bl);
        this.setArmed(bl);
        this.addSafetyListener();
    }

    public MJLabel(String string, Icon icon, int n) {
        super(string, icon, n);
        this.setArmed(true);
        this.addSafetyListener();
    }

    public MJLabel(String string, int n) {
        super(string, n);
        this.setArmed(true);
        this.addSafetyListener();
    }

    private void addSafetyListener() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    public void setTipWhenTruncatedEnabled(boolean bl) {
        if (bl != this.isTipWhenTruncatedEnabled()) {
            if (bl) {
                this.setToolTipText(this.isTruncated() ? this.getText() : null);
                this.fTruncationListener = new TruncationListener();
                this.addComponentListener(this.fTruncationListener);
            } else {
                if (super.getToolTipText() == this.getText()) {
                    this.setToolTipText(null);
                }
                this.removeComponentListener(this.fTruncationListener);
            }
        }
    }

    public boolean isTipWhenTruncatedEnabled() {
        return this.fTruncationListener != null;
    }

    private boolean isTruncated() {
        return this.getPreferredSize().width > this.getWidth();
    }

    @Override
    public void setText(String string) {
        if (this.fHasBeenInitialized) {
            this.setText(string, this.fTreatAmpersandAsMnemonic);
        } else {
            this.setText(string, true);
        }
    }

    public void setText(String string, boolean bl) {
        if (bl) {
            this.fTextWithMnemonic = string;
            String string2 = MJUtilities.exciseAmpersand(string);
            super.setText(string2);
            this.setArmed(this.fIsArmed);
            if (this.isTipWhenTruncatedEnabled()) {
                this.setToolTipText(this.isTruncated() ? string2 : null);
            }
        } else {
            super.setText(string);
            if (this.isTipWhenTruncatedEnabled()) {
                this.setToolTipText(this.isTruncated() ? string : null);
            }
        }
    }

    public void setArmed(boolean bl) {
        this.fIsArmed = bl;
        MJUtilities.setMnemonicFromText(this, this.fIsArmed ? this.fTextWithMnemonic : MJUtilities.exciseAmpersand(this.fTextWithMnemonic));
    }

    public void setLabelForWithoutGrabbingFocus(final Component component) {
        this.setLabelFor(component);
        this.addFocusListener(new FocusAdapter(){
            private Component iPreviousFocusOwner;

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() == component && this.iPreviousFocusOwner != null) {
                    this.iPreviousFocusOwner.requestFocus();
                    this.iPreviousFocusOwner = null;
                } else {
                    this.iPreviousFocusOwner = focusEvent.getOppositeComponent();
                }
            }
        });
    }

    private class TruncationListener
    extends ComponentAdapter {
        private TruncationListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MJLabel.this.setToolTipText(MJLabel.this.isTruncated() ? MJLabel.this.getText() : null);
        }
    }
}

