/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ComponentMover;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class MJGrip
extends JComponent {
    private boolean fDrawGripper = true;
    private boolean fDrawGradient = false;
    private int fOrientation;
    private static final String UI_CLASS_ID = "GripUI";
    private static final String COMMON_UI_CLASS = "com.mathworks.mwswing.MJGrip$CommonUI";
    private static final String MAC_UI_CLASS = "com.mathworks.mwswing.MJGrip$MacUI";

    public MJGrip() {
        this(1);
    }

    public MJGrip(int n) {
        this.fOrientation = n;
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.updateUI();
    }

    public void setComponentToMove(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        ComponentMover componentMover = new ComponentMover(component);
        this.addMouseListener(componentMover);
        this.addMouseMotionListener(componentMover);
    }

    public int getOrientation() {
        return this.fOrientation;
    }

    public void setOrientation(int n) {
        if (n != this.fOrientation) {
            this.fOrientation = n;
            this.revalidate();
        }
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public static int getPreferredThickness() {
        Object object = UIManager.getDefaults().get(UI_CLASS_ID);
        return object == MAC_UI_CLASS ? 6 : 6;
    }

    public boolean getShouldDrawGradient() {
        return this.fDrawGradient;
    }

    public void setShouldDrawGradient(boolean bl) {
        this.fDrawGradient = bl;
    }

    public boolean getShouldDrawGripper() {
        return this.fDrawGripper;
    }

    public void setShouldDrawGripper(boolean bl) {
        this.fDrawGripper = bl;
    }

    private static boolean isParentWindowFocused(JComponent jComponent) {
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        return window != null && window.isFocused();
    }

    public static void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        BasicUI basicUI = PlatformInfo.isMacintosh() ? new MacUI() : new CommonUI();
        basicUI.paintBackground(graphics, n, n2, n3, n4);
        basicUI.paintGripper(graphics, n, n2, n3, n4);
    }

    static {
        UIDefaults uIDefaults = UIManager.getDefaults();
        if (PlatformInfo.isMacintosh()) {
            uIDefaults.put(UI_CLASS_ID, MAC_UI_CLASS);
        } else {
            uIDefaults.put(UI_CLASS_ID, COMMON_UI_CLASS);
        }
    }

    public static class MacUI
    extends BasicUI {
        private static final int PREFERRED_THICKNESS = 6;
        private static final Color MAC_STRIPE_COLOR = new Color(125, 125, 125);

        public static ComponentUI createUI(JComponent jComponent) {
            return new MacUI();
        }

        private MacUI() {
            super(6);
        }

        @Override
        public Paint createPaint(JComponent jComponent) {
            Color color = ColorUtils.MAC_ACTIVE_MIDDLE_COLOR;
            Color color2 = ColorUtils.MAC_ACTIVE_BOTTOM_COLOR;
            if (!MJGrip.isParentWindowFocused(jComponent)) {
                color = ColorUtils.MAC_INACTIVE_MIDDLE_COLOR;
                color2 = ColorUtils.MAC_INACTIVE_BOTTOM_COLOR;
            }
            int n = 4 * MJGrip.getPreferredThickness() / 10;
            return new GradientPaint(0.0f, n, color, 0.0f, jComponent.getHeight(), color2, true);
        }

        @Override
        public Color getBackground() {
            return Color.WHITE;
        }

        @Override
        public void paintGripper(Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n5 = n + n3;
            int n6 = n2 + n4;
            graphics.setColor(MAC_STRIPE_COLOR);
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Shape shape = graphics.getClip();
            graphics.setClip(n, n2, n3, n4);
            if (n4 < n3) {
                int n7 = n - n4 / 4 * 4 - 1;
                int n8 = n6;
                int n9 = n7 + n4;
                int n10 = n2;
                while (n7 < n5) {
                    graphics.drawLine(n7, n8, n9, n10);
                    n7 += 4;
                    n9 += 4;
                }
            } else {
                int n11 = n5;
                int n12 = n2 - n3 / 4 * 4 - 1;
                int n13 = n;
                int n14 = n12 + n3;
                while (n12 < n6) {
                    graphics.drawLine(n11, n12, n13, n14);
                    n12 += 4;
                    n14 += 4;
                }
            }
            graphics.setClip(shape);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public static class CommonUI
    extends BasicUI {
        private static final int PREFERRED_THICKNESS = 6;

        public static ComponentUI createUI(JComponent jComponent) {
            return new CommonUI();
        }

        public CommonUI() {
            super(6);
        }

        @Override
        public Paint createPaint(JComponent jComponent) {
            Color color = ColorUtils.fade(UIManager.getColor("InternalFrame.activeTitleBackground"));
            Color color2 = ColorUtils.intensify(UIManager.getColor("InternalFrame.activeTitleBackground"));
            if (!MJGrip.isParentWindowFocused(jComponent)) {
                color = UIManager.getColor("control");
                color2 = UIManager.getColor("control");
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
                fArray[2] = 1.25f * fArray[2];
                if (fArray[2] > 1.0f) {
                    fArray[2] = 1.0f;
                }
                fArray2[2] = 0.85f * fArray2[2];
                color = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
                color2 = Color.getHSBColor(fArray2[0], fArray2[1], fArray2[2]);
            }
            return new GradientPaint(0.0f, 0.0f, color, 0.0f, jComponent.getHeight(), color2, true);
        }

        @Override
        public Color getBackground() {
            return UIManager.getColor("control");
        }

        private Color getLight() {
            return MJUtilities.isHighContrast() ? ColorUtils.getBlackOrWhiteContrasting(this.getBackground()) : this.getBackground().brighter();
        }

        private Color getDark() {
            return MJUtilities.isHighContrast() ? ColorUtils.getBlackOrWhiteContrasting(this.getLight()) : this.getBackground().darker();
        }

        @Override
        public void paintGripper(Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = n4 > n3;
            Color color = graphics.getColor();
            graphics.setColor(this.getLight());
            this.paintPatches(graphics, bl, n + (bl ? 1 : 0), n2 + 1, n3, n4);
            graphics.setColor(this.getDark());
            this.paintPatches(graphics, bl, n + (bl ? 0 : 1), n2, n3, n4);
            graphics.setColor(color);
        }

        private void paintPatches(Graphics graphics, boolean bl, int n, int n2, int n3, int n4) {
            int n5 = n3 / 3;
            int n6 = n4 / 3;
            int n7 = bl ? 0 : 1;
            int n8 = 0;
            int n9 = n;
            while (n8 < n5) {
                int n10 = n7;
                for (int i = n2 + n7 * 3; n10 < n6 && i <= n2 + n4 + 2; n10 += 2, i += 6) {
                    graphics.fillRect(n9, i, 2, 2);
                }
                ++n8;
                n9 += 3;
                n7 = 1 - n7;
            }
        }
    }

    private static abstract class BasicUI
    extends ComponentUI {
        private final int fPreferredThickness;

        private BasicUI(int n) {
            this.fPreferredThickness = n;
        }

        public abstract Color getBackground();

        @Override
        public Dimension getMaximumSize(JComponent jComponent) {
            Dimension dimension = this.getPreferredSize(jComponent);
            if (((MJGrip)jComponent).getOrientation() == 1) {
                dimension.height = Integer.MAX_VALUE;
            } else {
                dimension.width = Integer.MAX_VALUE;
            }
            return dimension;
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            Insets insets = jComponent.getInsets();
            if (((MJGrip)jComponent).getOrientation() == 1) {
                return new Dimension(insets.left + insets.right + this.fPreferredThickness, 0);
            }
            return new Dimension(0, insets.top + insets.bottom + this.fPreferredThickness);
        }

        public abstract Paint createPaint(JComponent var1);

        @Override
        public final void paint(Graphics graphics, JComponent jComponent) {
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            Insets insets = jComponent.getInsets();
            MJGrip mJGrip = (MJGrip)jComponent;
            this.paintBackground(graphics, insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
            if (mJGrip.getShouldDrawGradient()) {
                this.paintGradient(graphics, 0, 0, n, n2, this.createPaint(mJGrip));
                this.paintBorder(graphics, 0, 0, n, n2);
            }
            if (mJGrip.getShouldDrawGripper()) {
                this.paintGripper(graphics, insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
            }
        }

        public final void paintBackground(Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(color);
        }

        public final void paintGradient(Graphics graphics, int n, int n2, int n3, int n4, Paint paint) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint2 = graphics2D.getPaint();
            graphics2D.setPaint(paint);
            graphics.fillRect(n, n2, n3, n4);
            graphics2D.setPaint(paint2);
        }

        public final void paintBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(n, n4 - 1, n3, n4 - 1);
            graphics.setColor(color);
        }

        public abstract void paintGripper(Graphics var1, int var2, int var3, int var4, int var5);
    }
}

